/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import krause.common.exception.ProcessingException;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.IVNABackgroundTaskStatusListener;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNADataPool;
import krause.vna.data.VNAScanMode;
import krause.vna.device.IVNADriver;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.device.VNADriverFactory;
import krause.vna.device.VNADriverNameComparator;
import krause.vna.gui.HelpButton;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;

public class VNADriverConfigDialog
extends KrauseDialog
implements IVNABackgroundTaskStatusListener {
    private static VNAConfig config = VNAConfig.getSingleton();
    private VNADataPool datapool = VNADataPool.getSingleton();
    private JButton btCancel;
    private JButton btOK;
    private JButton btTest;
    private JList driverList;
    private JList portList;
    private IVNADriver selectedDriver = null;
    private String selectedPort = null;
    private JLabel statusBar;
    private VNAMainFrame mainFrame;
    private IVNADriver currentlyLoadedDriver = null;
    private JCheckBox cbNoFilter;

    public VNADriverConfigDialog(VNAMainFrame pMainFrame) {
        super((Window)pMainFrame.getJFrame(), true);
        this.mainFrame = pMainFrame;
        TraceHelper.entry(this, "VNADriverConfigDialog");
        this.setResizable(true);
        this.setConfigurationPrefix("VNADriverConfigDialog");
        this.setProperties(config);
        this.setTitle(VNAMessages.getString("VNADriverConfigDialog.title"));
        this.setDefaultCloseOperation(0);
        this.setLayout((LayoutManager)new MigLayout("", "[][grow,fill]", "[grow,fill][][]"));
        this.setPreferredSize(new Dimension(720, 370));
        this.add(this.createDriverPanel(), "");
        this.add(this.createPortPanel(), "wrap");
        this.add(this.createStatusPanel(), "span 2,grow,wrap");
        this.add(this.createButtonPanel(), "span 2,grow,wrap");
        this.getRootPane().setDefaultButton(this.btOK);
        this.doInit();
        TraceHelper.exit(this, "VNADriverConfigDialog");
    }

    private Component createStatusPanel() {
        JPanel rc = new JPanel((LayoutManager)new MigLayout("", "[grow,fill]", "[grow,fill]"));
        rc.setBorder(new TitledBorder(null, VNAMessages.getString("VNADriverConfigDialog.status"), 4, 2, null, null));
        this.statusBar = new JLabel();
        rc.add((Component)this.statusBar, "");
        return rc;
    }

    private Component createButtonPanel() {
        JPanel rc = new JPanel((LayoutManager)new MigLayout("", "[grow][grow][grow][grow][grow]", "[]"));
        this.btCancel = SwingUtil.createJButton("Button.Cancel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNADriverConfigDialog.this.doCANCEL();
            }
        });
        rc.add((Component)this.btCancel, "left");
        this.cbNoFilter = SwingUtil.createJCheckbox("Button.Filter", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNADriverConfigDialog.this.doFilter();
            }
        });
        rc.add((Component)this.cbNoFilter, "left");
        this.btTest = SwingUtil.createJButton("Button.Test", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNADriverConfigDialog.this.doTest();
            }
        });
        this.btTest.setEnabled(false);
        rc.add((Component)this.btTest, "center");
        rc.add((Component)new HelpButton(this, "VNADriverConfigDialog"), "center");
        this.btOK = SwingUtil.createJButton("Button.Update", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNADriverConfigDialog.this.doOK();
            }
        });
        this.btOK.setEnabled(false);
        rc.add((Component)this.btOK, "right");
        return rc;
    }

    private void fillDriverList() {
        TraceHelper.entry(this, "fillDriverList");
        List<IVNADriver> availableDrivers = VNADriverFactory.getSingleton().getDriverList();
        Collections.sort(availableDrivers, new VNADriverNameComparator());
        Vector<String> drvVector = new Vector<String>(availableDrivers.size());
        for (IVNADriver driver : availableDrivers) {
            drvVector.add(driver.getDeviceInfoBlock().getShortName());
        }
        this.driverList.setListData(drvVector);
        TraceHelper.exit(this, "fillDriverList");
    }

    private Component createDriverPanel() {
        JPanel rc = new JPanel((LayoutManager)new MigLayout("", "[grow,fill]", "[grow,fill][]"));
        rc.setBorder(new TitledBorder(null, VNAMessages.getString("VNADriverConfigDialog.drvList"), 4, 2, null, null));
        this.driverList = new JList();
        this.driverList.setVisibleRowCount(6);
        this.driverList.setSelectionMode(0);
        this.driverList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VNADriverConfigDialog.this.handleDriverListSelection(e);
            }
        });
        JScrollPane sp = new JScrollPane(this.driverList);
        rc.add((Component)sp, "wrap");
        rc.add((Component)new JLabel(VNAMessages.getString("VNADriverConfigDialog.drvUsage")), "");
        return rc;
    }

    private Component createPortPanel() {
        JPanel rc = new JPanel((LayoutManager)new MigLayout("", "[grow,fill]", "[grow,fill][]"));
        rc.setBorder(new TitledBorder(null, VNAMessages.getString("VNADriverConfigDialog.portLIst"), 4, 2, null, null));
        this.portList = new JList();
        this.portList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VNADriverConfigDialog.this.handlePortListSelection(e);
            }
        });
        JScrollPane sp = new JScrollPane(this.portList);
        rc.add((Component)sp, "wrap");
        rc.add((Component)new JLabel(VNAMessages.getString("VNADriverConfigDialog.portUsage")), "");
        return rc;
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        if (this.currentlyLoadedDriver != null) {
            this.mainFrame.loadDriver();
        }
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.fillDriverList();
        this.currentlyLoadedDriver = this.selectedDriver = this.datapool.getDriver();
        if (this.currentlyLoadedDriver != null) {
            this.mainFrame.unloadDriver();
            this.driverList.setSelectedValue(this.currentlyLoadedDriver.getDeviceInfoBlock().getShortName(), true);
        }
        this.addEscapeKey();
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    protected void doOK() {
        TraceHelper.entry(this, "doOK");
        config.setPortName(this.selectedDriver, this.selectedPort);
        this.datapool.setDeviceType(this.selectedDriver.getDeviceInfoBlock().getType());
        this.mainFrame.loadDriver();
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doOK");
    }

    protected void doFilter() {
        this.handleDriverListSelection(null);
    }

    private void fillPortList() throws ProcessingException {
        boolean filter;
        TraceHelper.entry(this, "fillPortList");
        List<String> ports = this.selectedDriver.getPortList();
        Vector<String> portVector = new Vector<String>(ports.size());
        boolean bl = filter = !this.cbNoFilter.isSelected();
        if (filter) {
            TraceHelper.text(this, "fillPortList", "Filtering serial ports ...");
        }
        for (String port : ports) {
            if (filter) {
                boolean useIt = false;
                if (config.isMac()) {
                    if (port.startsWith("cu")) {
                        useIt = true;
                    }
                } else if (config.isWindows()) {
                    useIt = true;
                } else if (!"tty".equals(port)) {
                    if (port.startsWith("tty")) {
                        String sName = port.substring(3);
                        try {
                            Integer.parseInt(sName);
                        }
                        catch (NumberFormatException e) {
                            useIt = true;
                        }
                    } else {
                        useIt = true;
                    }
                }
                if (useIt) {
                    portVector.add(port);
                    continue;
                }
                TraceHelper.text(this, "fillPortList", "port [" + port + " filtered");
                continue;
            }
            portVector.add(port);
        }
        this.portList.setListData(portVector);
        TraceHelper.exit(this, "fillPortList");
    }

    protected void handleDriverListSelection(ListSelectionEvent e) {
        TraceHelper.entry(this, "handleDriverListSelection");
        if (e != null && e.getValueIsAdjusting()) {
            return;
        }
        String selDrv = (String)this.driverList.getSelectedValue();
        TraceHelper.text(this, "handleDriverListSelection", "drv=" + selDrv);
        try {
            this.btOK.setEnabled(false);
            this.selectedDriver = VNADriverFactory.getSingleton().getDriverForShortName(selDrv);
            if (this.selectedDriver != null) {
                this.fillPortList();
                this.selectedPort = config.getPortName(this.selectedDriver);
                if (this.selectedPort != null) {
                    this.portList.setSelectedValue(this.selectedPort, true);
                }
            }
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
        TraceHelper.exit(this, "handleDriverListSelection");
    }

    protected void handlePortListSelection(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        TraceHelper.entry(this, "handlePortListSelection");
        this.selectedPort = (String)this.portList.getSelectedValue();
        TraceHelper.text(this, "handlePortListSelection", "drv=" + this.selectedPort);
        this.btTest.setEnabled(this.selectedPort != null);
        TraceHelper.exit(this, "handlePortListSelection");
    }

    private void setStatusbar(Color col, String text) {
        this.statusBar.setBackground(col);
        this.statusBar.setOpaque(true);
        this.statusBar.setText(text);
    }

    private void doTest() {
        boolean state = false;
        this.btOK.setEnabled(false);
        this.btTest.setEnabled(false);
        String oldPortName = null;
        try {
            try {
                oldPortName = config.getPortName(this.selectedDriver);
                config.setPortName(this.selectedDriver, this.selectedPort);
                VNADeviceInfoBlock dib = this.selectedDriver.getDeviceInfoBlock();
                this.setStatusbar(Color.GRAY, VNAMessages.getString("VNADriverConfigDialog.testInit"));
                this.selectedDriver.init();
                this.setStatusbar(Color.GRAY, VNAMessages.getString("VNADriverConfigDialog.testSleep"));
                Thread.sleep(3000L);
                this.setStatusbar(Color.GRAY, VNAMessages.getString("VNADriverConfigDialog.testTest"));
                state = true;
                this.selectedDriver.scan(VNAScanMode.MODE_REFLECTION, dib.getMinFrequency(), dib.getMaxFrequency(), 100, this);
                this.setStatusbar(Color.GREEN, VNAMessages.getString("VNADriverConfigDialog.statusOK"));
                this.btOK.setEnabled(true);
            }
            catch (Exception e) {
                ErrorLogHelper.exception(this, "doTest", e);
                if (!state) {
                    this.setStatusbar(Color.RED, VNAMessages.getString("VNADriverConfigDialog.statusFAIL1"));
                } else {
                    this.setStatusbar(Color.RED, VNAMessages.getString("VNADriverConfigDialog.statusFAIL2"));
                }
                this.selectedDriver.destroy();
                this.btTest.setEnabled(true);
                if (oldPortName != null) {
                    config.setPortName(this.selectedDriver, oldPortName);
                }
            }
        }
        finally {
            this.selectedDriver.destroy();
            this.btTest.setEnabled(true);
            if (oldPortName != null) {
                config.setPortName(this.selectedDriver, oldPortName);
            }
        }
    }

    @Override
    public void publishProgress(int percentage) {
    }
}

