/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.LogManager;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.comparators.VNAPropertyComparator;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.util.SwingUtil;
import krause.vna.gui.util.tables.VNAProperty;
import krause.vna.gui.util.tables.VNAPropertyTableModel;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;

public class VNAConfigEditDialog
extends KrauseDialog
implements ActionListener {
    private VNAPropertyTableModel model = new VNAPropertyTableModel();
    private VNAConfig config = VNAConfig.getSingleton();
    private JCheckBox cbAskOnExit;
    private JCheckBox cbEnableTrace;
    private JTable table;
    private JCheckBox cbAutoAfterSelect;
    private JCheckBox cbAutoAfterZoom;
    private AbstractButton cbMarkerLineMode;
    private JCheckBox cbShowBandmap;
    private JCheckBox cbExportRawData;

    private void copyConfig2Model() {
        TraceHelper.entry(this, "copyConfig2Model");
        this.model.getData().clear();
        for (String string : this.config.keySet()) {
            String value = this.config.getProperty(string);
            this.model.addElement(new VNAProperty(string, value));
        }
        Collections.sort(this.model.getData(), new VNAPropertyComparator());
        TraceHelper.exit(this, "copyConfig2Model");
    }

    private void copyModel2Config() {
        TraceHelper.entry(this, "copyModel2Config");
        List<VNAProperty> data = this.model.getData();
        int i = 0;
        while (i < data.size()) {
            VNAProperty vNAProperty = data.get(i);
            this.config.put(vNAProperty.getKey(), vNAProperty.getValue());
            ++i;
        }
        for (String string : this.config.keySet()) {
            String value = this.config.getProperty(string);
            this.model.addElement(new VNAProperty(string, value));
        }
        TraceHelper.exit(this, "copyModel2Config");
    }

    public VNAConfigEditDialog(VNAMainFrame mainFrame) {
        super((Window)mainFrame.getJFrame(), true);
        TraceHelper.entry(this, "VNAConfigEditDialog");
        this.setConfigurationPrefix("VNAConfigEditDialog");
        this.setProperties(this.config);
        this.getContentPane().setLayout(new BorderLayout());
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setBounds(100, 100, 678, 472);
        this.setTitle(VNAMessages.getString("VNAConfigEditDialog.this.title"));
        JLabel label = new JLabel(VNAMessages.getString("Dlg.Settings.1"));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VNAConfigEditDialog.this.table.setEnabled(true);
            }
        });
        this.getContentPane().add((Component)label, "First");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout((LayoutManager)new MigLayout("", "[][][][]", "[][]"));
        this.getContentPane().add((Component)centerPanel, "Center");
        this.table = new JTable(this.model);
        this.table.setPreferredScrollableViewportSize(new Dimension(600, 400));
        this.table.setEnabled(false);
        JScrollPane scrollPane = new JScrollPane(this.table);
        centerPanel.add((Component)scrollPane, "span 4, wrap");
        this.cbAskOnExit = new JCheckBox(VNAMessages.getString("VNAConfigEditDialog.cbAskOnExit.text"));
        this.cbAskOnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAConfigEditDialog.this.config.setAskOnExit(VNAConfigEditDialog.this.cbAskOnExit.isSelected());
                VNAConfigEditDialog.this.copyConfig2Model();
            }
        });
        centerPanel.add((Component)this.cbAskOnExit, "");
        this.cbEnableTrace = new JCheckBox(VNAMessages.getString("VNAConfigEditDialog.cbEnableTrace.text"));
        this.cbEnableTrace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAConfigEditDialog.this.config.putBoolean("Tracer.tracing", VNAConfigEditDialog.this.cbEnableTrace.isSelected());
                LogManager.getSingleton().setTracingEnabled(VNAConfigEditDialog.this.cbEnableTrace.isSelected());
                VNAConfigEditDialog.this.copyConfig2Model();
            }
        });
        centerPanel.add((Component)this.cbEnableTrace, "");
        this.cbExportRawData = new JCheckBox(VNAMessages.getString("VNAConfigEditDialog.cbExportRawData.text"));
        this.cbExportRawData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAConfigEditDialog.this.config.setExportRawData(VNAConfigEditDialog.this.cbExportRawData.isSelected());
                VNAConfigEditDialog.this.copyConfig2Model();
            }
        });
        centerPanel.add((Component)this.cbExportRawData, "wrap");
        this.cbMarkerLineMode = new JCheckBox(VNAMessages.getString("VNAConfigEditDialog.cbMarkerLineMode"));
        this.cbMarkerLineMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAConfigEditDialog.this.config.setMarkerModeLine(VNAConfigEditDialog.this.cbMarkerLineMode.isSelected());
                VNAConfigEditDialog.this.copyConfig2Model();
            }
        });
        centerPanel.add((Component)this.cbMarkerLineMode, "");
        this.cbShowBandmap = new JCheckBox(VNAMessages.getString("VNAConfigEditDialog.cbShowBandmap"));
        this.cbShowBandmap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAConfigEditDialog.this.config.setShowBandmap(VNAConfigEditDialog.this.cbShowBandmap.isSelected());
                VNAConfigEditDialog.this.copyConfig2Model();
            }
        });
        centerPanel.add((Component)this.cbShowBandmap, "wrap");
        this.cbAutoAfterSelect = SwingUtil.createJCheckBox("Panel.Data.cbAutoAfterSelect", this);
        this.cbAutoAfterSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAConfigEditDialog.this.config.setScanAfterTableSelect(VNAConfigEditDialog.this.cbAutoAfterSelect.isSelected());
                VNAConfigEditDialog.this.copyConfig2Model();
            }
        });
        centerPanel.add((Component)this.cbAutoAfterSelect, "");
        this.cbAutoAfterZoom = SwingUtil.createJCheckBox("Panel.Data.cbAutoAfterZoom", this);
        this.cbAutoAfterZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAConfigEditDialog.this.config.setScanAfterZoom(VNAConfigEditDialog.this.cbAutoAfterZoom.isSelected());
                VNAConfigEditDialog.this.copyConfig2Model();
            }
        });
        centerPanel.add((Component)this.cbAutoAfterZoom, "wrap");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(SwingUtil.createJButton("VNAConfigEditDialog.butShowConfigDir", this));
        buttonPanel.add(SwingUtil.createJButton("Button.Cancel", this));
        buttonPanel.add(SwingUtil.createJButton("Button.Save", this));
        this.getContentPane().add((Component)buttonPanel, "Last");
        this.doInit();
        TraceHelper.exit(this, "VNAConfigEditDialog");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        TraceHelper.entry(this, "actionPerformed");
        if ("cmdSAVE".equals(cmd)) {
            this.doSave();
        } else if ("cmdCancel".equals(cmd)) {
            this.doCANCEL();
        } else if ("cmdConfig".equals(cmd)) {
            File file = new File(this.config.getVNAConfigDirectory());
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException e1) {
                ErrorLogHelper.exception(this, "actionPerformed", e1);
            }
        }
        TraceHelper.exit(this, "actionPerformed");
    }

    private void doSave() {
        TraceHelper.entry(this, "doSave");
        this.copyModel2Config();
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doSave");
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        this.cbAskOnExit.setSelected(this.config.isAskOnExit());
        this.cbAutoAfterSelect.setSelected(this.config.isScanAfterTableSelect());
        this.cbAutoAfterZoom.setSelected(this.config.isScanAfterZoom());
        this.cbEnableTrace.setSelected(this.config.getBoolean("Tracer.tracing", false));
        this.cbMarkerLineMode.setSelected(this.config.isMarkerModeLine());
        this.cbShowBandmap.setSelected(this.config.isShowBandmap());
        this.copyConfig2Model();
        this.addEscapeKey();
        this.doShow();
    }
}

