/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;

public class VNAColorConfigDialog
extends KrauseDialog {
    private VNAConfig config = VNAConfig.getSingleton();

    public VNAColorConfigDialog(VNAMainFrame mainFrame, Frame aFrame) {
        super((Window)aFrame, true);
        this.setConfigurationPrefix("ColorDialog");
        this.setProperties(this.config);
        this.setTitle(VNAMessages.getString("ColorDialog.Title"));
        this.setPreferredSize(new Dimension(310, 280));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel pnlButtons = new JPanel();
        this.getContentPane().add((Component)pnlButtons, "South");
        JButton btnDefault = SwingUtil.createJButton("Button.Default", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAColorConfigDialog.this.doResetDefaults();
            }
        });
        pnlButtons.add(btnDefault);
        JButton btnOK = SwingUtil.createJButton("Button.Close", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAColorConfigDialog.this.doCANCEL();
            }
        });
        pnlButtons.add(btnOK);
        JPanel pnlCenter = new JPanel((LayoutManager)new MigLayout("", "", ""));
        this.getContentPane().add((Component)pnlCenter, "Center");
        JPanel pnlScales = new JPanel();
        pnlScales.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), VNAMessages.getString("ColorDialog.scales"), 4, 2, null, new Color(0, 0, 0)));
        pnlCenter.add((Component)pnlScales, "wrap,grow");
        JButton btnLeftScale = SwingUtil.createJButton("ColorDialog.Title.LeftScale", null);
        btnLeftScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(VNAColorConfigDialog.this.getOwner(), VNAMessages.getString("ColorDialog.select"), VNAColorConfigDialog.this.config.getColorScaleLeft());
                if (newColor != null) {
                    VNAColorConfigDialog.this.config.setColorScaleLeft(newColor);
                }
            }
        });
        pnlScales.add(btnLeftScale);
        JButton btnRightScale = SwingUtil.createJButton("ColorDialog.Title.RightScale", null);
        btnRightScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(VNAColorConfigDialog.this.getOwner(), VNAMessages.getString("ColorDialog.select"), VNAColorConfigDialog.this.config.getColorScaleRight());
                if (newColor != null) {
                    VNAColorConfigDialog.this.config.setColorScaleRight(newColor);
                }
            }
        });
        pnlScales.add(btnRightScale);
        JPanel pnlMarkers = new JPanel();
        pnlMarkers.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), VNAMessages.getString("ColorDialog.markers"), 4, 2, null, new Color(0, 0, 0)));
        pnlCenter.add((Component)pnlMarkers, "grow,wrap");
        JButton btnMarker = SwingUtil.createJButton("Marker.0", null);
        btnMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(VNAColorConfigDialog.this.getOwner(), "Color", VNAColorConfigDialog.this.config.getColorMarker(0));
                if (newColor != null) {
                    VNAColorConfigDialog.this.config.setColorMarker(0, newColor);
                }
            }
        });
        pnlMarkers.add(btnMarker);
        btnMarker = SwingUtil.createJButton("Marker.1", null);
        btnMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(VNAColorConfigDialog.this.getOwner(), "Color", VNAColorConfigDialog.this.config.getColorMarker(1));
                if (newColor != null) {
                    VNAColorConfigDialog.this.config.setColorMarker(1, newColor);
                }
            }
        });
        pnlMarkers.add(btnMarker);
        btnMarker = SwingUtil.createJButton("Marker.2", null);
        btnMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(VNAColorConfigDialog.this.getOwner(), "Color", VNAColorConfigDialog.this.config.getColorMarker(2));
                if (newColor != null) {
                    VNAColorConfigDialog.this.config.setColorMarker(2, newColor);
                }
            }
        });
        pnlMarkers.add(btnMarker);
        btnMarker = SwingUtil.createJButton("Marker.3", null);
        btnMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(VNAColorConfigDialog.this.getOwner(), "Color", VNAColorConfigDialog.this.config.getColorMarker(3));
                if (newColor != null) {
                    VNAColorConfigDialog.this.config.setColorMarker(3, newColor);
                }
            }
        });
        pnlMarkers.add(btnMarker);
        JPanel pnlDiag = new JPanel();
        pnlDiag.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), VNAMessages.getString("ColorDialog.diagram"), 4, 2, null, new Color(0, 0, 0)));
        pnlCenter.add((Component)pnlDiag, "wrap");
        JButton btnDiagramBackground = SwingUtil.createJButton("ColorDialog.Title.DiagramBackground", null);
        btnDiagramBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(VNAColorConfigDialog.this.getOwner(), "Color", VNAColorConfigDialog.this.config.getColorDiagram());
                if (newColor != null) {
                    VNAColorConfigDialog.this.config.setColorDiagram(newColor);
                }
            }
        });
        JButton btnDiagramLines = SwingUtil.createJButton("ColorDialog.Title.DiagramLines", null);
        btnDiagramLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(VNAColorConfigDialog.this.getOwner(), "Color", VNAColorConfigDialog.this.config.getColorDiagramLines());
                if (newColor != null) {
                    VNAColorConfigDialog.this.config.setColorDiagramLines(newColor);
                }
            }
        });
        JButton btnReferenceColor = SwingUtil.createJButton("ColorDialog.Title.Reference", null);
        btnReferenceColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(VNAColorConfigDialog.this.getOwner(), VNAMessages.getString("ColorDialog.select"), VNAColorConfigDialog.this.config.getColorReference());
                if (newColor != null) {
                    VNAColorConfigDialog.this.config.setColorReference(newColor);
                }
            }
        });
        JButton btnBandmapColor = SwingUtil.createJButton("ColorDialog.Title.Bandmap", null);
        btnBandmapColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(VNAColorConfigDialog.this.getOwner(), VNAMessages.getString("ColorDialog.select"), VNAColorConfigDialog.this.config.getColorBandmap());
                if (newColor != null) {
                    VNAColorConfigDialog.this.config.setColorBandmap(newColor);
                }
            }
        });
        pnlDiag.add(btnReferenceColor);
        pnlDiag.add(btnDiagramLines);
        pnlDiag.add(btnDiagramBackground);
        pnlDiag.add(btnBandmapColor);
        this.doInit();
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.setVisible(false);
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.addEscapeKey();
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    private void doResetDefaults() {
        TraceHelper.entry(this, "doResetDefaults");
        this.config.setColorDiagram(Color.BLACK);
        this.config.setColorDiagramLines(Color.LIGHT_GRAY);
        this.config.setColorMarker(0, Color.YELLOW);
        this.config.setColorMarker(1, Color.YELLOW);
        this.config.setColorMarker(2, Color.YELLOW);
        this.config.setColorMarker(3, Color.YELLOW);
        this.config.setColorScaleLeft(Color.GREEN);
        this.config.setColorScaleRight(Color.CYAN);
        this.config.setColorBandmap(Color.DARK_GRAY);
        TraceHelper.exit(this, "doResetDefaults");
    }
}

