/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.calibrate.file;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.resources.VNAMessages;

public class VNACalibrationFileTableModel
extends AbstractTableModel {
    private List<VNACalibrationBlock> data = new ArrayList<VNACalibrationBlock>();
    private String[] columnNames = new String[]{VNAMessages.getString("CalibrationFileTableModel.name"), VNAMessages.getString("CalibrationFileTableModel.date"), VNAMessages.getString("CalibrationFileTableModel.comment"), VNAMessages.getString("CalibrationFileTableModel.type"), VNAMessages.getString("CalibrationFileTableModel.mode"), VNAMessages.getString("CalibrationFileTableModel.nofSteps"), VNAMessages.getString("CalibrationFileTableModel.nofOverscans")};

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object rc = null;
        VNACalibrationBlock block = this.data.get(rowIndex);
        if (columnIndex == 0) {
            rc = block.getFile().getName();
        } else if (columnIndex == 1) {
            long zeit = block.getFile().lastModified();
            rc = VNAFormatFactory.getDateTimeFormat().format(zeit);
        } else {
            String x;
            rc = columnIndex == 2 ? block.getComment() : (columnIndex == 3 ? ("0".equals(x = block.getAnalyserType()) ? "Sample" : ("1".equals(x) ? "miniVNA" : ("2".equals(x) ? "miniVNA pro" : ("3".equals(x) ? "miniVNA pro-ext" : ("4".equals(x) ? "Max6" : ("5".equals(x) ? "Max6-500" : ("10".equals(x) ? "miniVNA LF" : ("12".equals(x) ? "miniVNA pro-LF" : ("6".equals(x) ? "miniVNA Test" : ("20".equals(x) ? "tinyVNA" : ("30".equals(x) ? "metroVNA" : ("40".equals(x) ? "VNArduino" : "?")))))))))))) : (columnIndex == 4 ? block.getScanMode().shortText() : (columnIndex == 5 ? new Integer(block.getNumberOfSteps()) : (columnIndex == 6 ? new Integer(block.getNumberOfOverscans()) : "???"))));
        }
        return rc;
    }

    public List<VNACalibrationBlock> getData() {
        return this.data;
    }

    public void addElement(VNACalibrationBlock block) {
        TraceHelper.entry(this, "addElement");
        this.data.add(block);
        this.fireTableDataChanged();
        TraceHelper.exit(this, "addElement");
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public void clear() {
        this.data.clear();
    }
}

