/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.calibrate;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import krause.common.exception.ProcessingException;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNADataPool;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.helper.VNACalibrationBlockHelper;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.gui.HelpButton;
import krause.vna.gui.OptionDialogHelper;
import krause.vna.gui.calibrate.IVNACalibrationSelectionListener;
import krause.vna.gui.calibrate.VNACalibrationBlockComparator;
import krause.vna.gui.calibrate.file.VNACalibrationFileTable;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;

public class VNACalibrationLoadDialog
extends KrauseDialog
implements IVNACalibrationSelectionListener {
    private final VNAConfig config = VNAConfig.getSingleton();
    private final VNADataPool datapool = VNADataPool.getSingleton();
    private final VNADeviceInfoBlock dib = this.datapool.getDriver().getDeviceInfoBlock();
    private VNACalibrationFileTable lstFiles;
    private JButton btCancel;
    private JButton btOK;
    private JCheckBox cbShowAll;
    private JPanel mainPanel;
    private VNACalibrationBlock selectedCalBlock = null;

    public VNACalibrationLoadDialog(Window pOwner) {
        super(pOwner, true);
        this.setResizable(true);
        TraceHelper.entry(this, "VNACalibrationLoadDialog");
        this.setConfigurationPrefix("VNACalibrationLoadDialog");
        this.setProperties(this.config);
        String tit = VNAMessages.getString("VNACalibrationLoadDialog.title");
        this.setTitle(MessageFormat.format(tit, this.datapool.getScanMode().toString()));
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(800, 200));
        this.mainPanel = new JPanel((LayoutManager)new MigLayout("", "[grow,fill][][][]", "[grow,fill][][]"));
        this.mainPanel.setBorder(new TitledBorder(null, "", 4, 2, null, null));
        this.getContentPane().add(this.mainPanel);
        this.lstFiles = new VNACalibrationFileTable(this);
        JScrollPane scrollPane = new JScrollPane(this.lstFiles);
        scrollPane.setAlignmentX(0.0f);
        scrollPane.setViewportBorder(null);
        this.mainPanel.add((Component)scrollPane, "grow, span 4,wrap");
        this.cbShowAll = new JCheckBox(VNAMessages.getString("VNACalibrationLoadDialog.cbShowAll"));
        this.mainPanel.add(this.cbShowAll);
        this.mainPanel.add((Component)new HelpButton(this, "VNACalibrationLoadDialog"), "wmin 100px");
        this.btCancel = new JButton(VNAMessages.getString("Button.Cancel"));
        this.mainPanel.add((Component)this.btCancel, "wmin 100px");
        this.btOK = new JButton(VNAMessages.getString("Button.OK"));
        this.mainPanel.add((Component)this.btOK, "wmin 100px");
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNACalibrationLoadDialog.this.doOK();
            }
        });
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNACalibrationLoadDialog.this.doCANCEL();
            }
        });
        this.cbShowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNACalibrationLoadDialog.this.loadDirectory(VNACalibrationLoadDialog.this.cbShowAll.isSelected());
            }
        });
        this.getRootPane().setDefaultButton(this.btOK);
        this.doInit();
        TraceHelper.exit(this, "VNACalibrationLoadDialog");
    }

    public VNACalibrationBlock getSelectedCalibrationBlock() {
        return this.selectedCalBlock;
    }

    protected void doOK() {
        TraceHelper.entry(this, "doOK");
        this.setVisible(false);
        TraceHelper.exit(this, "doOK");
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.setVisible(false);
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.addEscapeKey();
        this.loadDirectory(false);
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    private void loadDirectory(boolean showAllFiles) {
        TraceHelper.entry(this, "loadDirectory");
        this.lstFiles.getModel().clear();
        File file = new File(this.config.getVNACalibrationDirectory());
        FilenameFilter fnf = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".cal");
            }
        };
        File[] files = file.listFiles(fnf);
        int i = 0;
        while (i < files.length) {
            File currFile = files[i];
            try {
                VNACalibrationBlock blk = VNACalibrationBlockHelper.loadHeader(currFile);
                if (showAllFiles) {
                    blk.setFile(currFile);
                    this.lstFiles.addCalibrationBlock(blk);
                } else {
                    boolean matches = blk.blockMatches(this.dib, this.datapool.getScanMode());
                    TraceHelper.text(this, "loadDirectory", String.valueOf(currFile.getName()) + (matches ? " matches" : " not matching"));
                    if (matches) {
                        blk.setFile(currFile);
                        this.lstFiles.addCalibrationBlock(blk);
                    }
                }
            }
            catch (ProcessingException e) {
                ErrorLogHelper.exception(this, "loadDirectory", e);
            }
            ++i;
        }
        this.btOK.setEnabled(false);
        Collections.sort(this.lstFiles.getModel().getData(), new VNACalibrationBlockComparator());
        this.lstFiles.updateUI();
        TraceHelper.exit(this, "loadDirectory");
    }

    @Override
    public void valueChanged(VNACalibrationBlock blk, boolean doubleClick) {
        block5: {
            TraceHelper.entry((Object)this, "valueChanged", "dbl=" + doubleClick);
            VNADeviceInfoBlock dib = this.datapool.getDriver().getDeviceInfoBlock();
            boolean matches = blk.blockMatches(dib, this.datapool.getScanMode());
            if (matches) {
                try {
                    this.selectedCalBlock = VNACalibrationBlockHelper.load(blk.getFile(), this.datapool.getDriver());
                    if (this.selectedCalBlock == null) break block5;
                    this.btOK.setEnabled(true);
                    if (doubleClick) {
                        this.doOK();
                    }
                }
                catch (ProcessingException e) {
                    ErrorLogHelper.exception(this, "valueChanged", e);
                    OptionDialogHelper.showExceptionDialog(null, "Serializer.Error.1", "Serializer.Error.2", e);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
                this.btOK.setEnabled(false);
            }
        }
        TraceHelper.exit(this, "valueChanged");
    }
}

