/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.calibrate;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNABaseSample;
import krause.vna.data.VNASampleBlock;
import krause.vna.export.JFSeries;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class VNACalibrationDataDetailsDialog
extends KrauseDialog {
    private static final float STROKE_WIDTH = 0.5f;
    private final Font LABEL_FONT = new Font("SansSerif", 0, 10);
    private final Font TICK_FONT = new Font("SansSerif", 0, 10);
    private JFreeChart chart;
    private ChartPanel lblImage;
    private JButton btOK;
    private VNASampleBlock sampleBlock;
    private final VNAConfig config = VNAConfig.getSingleton();
    private String typeId;

    public VNACalibrationDataDetailsDialog(Window pMainFrame, VNASampleBlock samples, String headerID) {
        super(pMainFrame, true);
        TraceHelper.entry(this, "VNACalibrationDataDetailsDialog");
        this.typeId = headerID;
        this.sampleBlock = samples;
        this.chart = this.createChart();
        this.setTitle(VNAMessages.getString("VNACalibrationDataDetailsDialog.title"));
        this.setDefaultCloseOperation(0);
        this.setBounds(100, 100, 689, 602);
        this.getContentPane().setLayout(new BorderLayout());
        this.lblImage = new ChartPanel(this.chart, true);
        this.getContentPane().add((Component)this.lblImage, "Center");
        this.lblImage.setBorder((Border)new TitledBorder(null, "", 4, 2, null, null));
        this.lblImage.setIgnoreRepaint(true);
        this.lblImage.setPreferredSize(new Dimension(640, 480));
        this.lblImage.setLayout((LayoutManager)new FlowLayout(1, 5, 5));
        JPanel buttonPane = new JPanel();
        this.getContentPane().add((Component)buttonPane, "South");
        buttonPane.setLayout(new BorderLayout(0, 0));
        this.btOK = SwingUtil.createJButton("Button.OK", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNACalibrationDataDetailsDialog.this.setVisible(false);
            }
        });
        buttonPane.add((Component)this.btOK, "East");
        this.btOK = SwingUtil.createJButton("Button.EXPORT", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNACalibrationDataDetailsDialog.this.doExport();
            }
        });
        buttonPane.add((Component)this.btOK, "West");
        this.btOK.setActionCommand("Cancel");
        this.getRootPane().setDefaultButton(this.btOK);
        this.doInit();
        TraceHelper.exit(this, "VNACalibrationDataDetailsDialog");
    }

    protected void doExport() {
        TraceHelper.entry(this, "doExport");
        boolean generate4Phase = false;
        if (this.sampleBlock.getSamples().length > 0 && this.sampleBlock.getSamples()[0].hasPData) {
            generate4Phase = true;
            TraceHelper.text(this, "doExport", "Exporting in 4-phase mode");
        }
        try {
            int cell;
            int rowNum;
            HSSFWorkbook workBook = new HSSFWorkbook();
            HSSFSheet workSheet = workBook.createSheet("vnaJ");
            if (generate4Phase) {
                rowNum = 0;
                cell = 0;
                HSSFRow row = workSheet.createRow(rowNum++);
                row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString(VNAMessages.getString("Plot.frequency")));
                row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString(VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.p1")));
                row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString(VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.p2")));
                row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString(VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.p3")));
                row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString(VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.p4")));
                VNABaseSample[] vNABaseSampleArray = this.sampleBlock.getSamples();
                int n = vNABaseSampleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VNABaseSample data = vNABaseSampleArray[n2];
                    cell = 0;
                    row = workSheet.createRow(rowNum);
                    row.createCell(cell++).setCellValue((double)data.getFrequency());
                    row.createCell(cell++).setCellValue((double)data.p1);
                    row.createCell(cell++).setCellValue((double)data.p2);
                    row.createCell(cell++).setCellValue((double)data.p3);
                    row.createCell(cell++).setCellValue((double)data.p4);
                    ++rowNum;
                    ++n2;
                }
            } else {
                rowNum = 0;
                cell = 0;
                HSSFRow row = workSheet.createRow(rowNum++);
                row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString(VNAMessages.getString("Plot.frequency")));
                row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString(VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.1")));
                row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString(VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.2")));
                VNABaseSample[] vNABaseSampleArray = this.sampleBlock.getSamples();
                int n = vNABaseSampleArray.length;
                int n3 = 0;
                while (n3 < n) {
                    VNABaseSample data = vNABaseSampleArray[n3];
                    cell = 0;
                    row = workSheet.createRow(rowNum);
                    row.createCell(cell++).setCellValue((double)data.getFrequency());
                    row.createCell(cell++).setCellValue((double)data.getLoss());
                    row.createCell(cell++).setCellValue((double)data.getAngle());
                    ++rowNum;
                    ++n3;
                }
            }
            String fn = String.valueOf(this.config.getExportDirectory()) + System.getProperty("file.separator") + "CalData_" + VNAMessages.getString(this.typeId) + "." + System.currentTimeMillis() + ".xls";
            FileOutputStream fileOut = new FileOutputStream(fn);
            workBook.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (IOException e) {
            ErrorLogHelper.exception(this, "doExport", e);
        }
        TraceHelper.exit(this, "doExport");
    }

    private JFreeChart createChart() {
        TraceHelper.entry(this, "createChart");
        JFreeChart rcChart = null;
        boolean generate4Phase = false;
        if (this.sampleBlock.getSamples().length > 0 && this.sampleBlock.getSamples()[0].hasPData) {
            generate4Phase = true;
        }
        if (generate4Phase) {
            JFSeries series1 = new JFSeries();
            JFSeries series2 = new JFSeries();
            JFSeries series3 = new JFSeries();
            JFSeries series4 = new JFSeries();
            XYSeries xySeries1 = new XYSeries((Comparable)((Object)VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.p1")));
            XYSeries xySeries22 = new XYSeries((Comparable)((Object)VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.p2")));
            XYSeries xySeries3 = new XYSeries((Comparable)((Object)VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.p3")));
            XYSeries xySeries4 = new XYSeries((Comparable)((Object)VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.p4")));
            VNABaseSample[] vNABaseSampleArray = this.sampleBlock.getSamples();
            int n = vNABaseSampleArray.length;
            int n2 = 0;
            while (n2 < n) {
                VNABaseSample data = vNABaseSampleArray[n2];
                long f = data.getFrequency();
                xySeries1.add((double)f, (double)data.p1);
                xySeries22.add((double)f, (double)data.p2);
                xySeries3.add((double)f, (double)data.p3);
                xySeries4.add((double)f, (double)data.p4);
                ++n2;
            }
            series1.setSeries(xySeries1);
            series2.setSeries(xySeries22);
            series3.setSeries(xySeries3);
            series4.setSeries(xySeries4);
            rcChart = ChartFactory.createXYLineChart((String)VNAMessages.getString(this.typeId), (String)VNAMessages.getString("Plot.frequency"), null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            XYPlot plot = rcChart.getXYPlot();
            NumberAxis rangeAxis1 = new NumberAxis(series1.getDataset().getSeries(0).getKey().toString());
            rangeAxis1.setLabelFont(this.LABEL_FONT);
            rangeAxis1.setTickLabelFont(this.TICK_FONT);
            rangeAxis1.setAutoRange(false);
            rangeAxis1.setRange(xySeries1.getMinY(), xySeries1.getMaxY());
            plot.setRangeAxis(0, (ValueAxis)rangeAxis1);
            plot.setDataset(0, (XYDataset)series1.getDataset());
            plot.mapDatasetToRangeAxis(0, 0);
            plot = rcChart.getXYPlot();
            NumberAxis rangeAxis2 = new NumberAxis(series2.getDataset().getSeries(0).getKey().toString());
            rangeAxis2.setLabelFont(this.LABEL_FONT);
            rangeAxis2.setTickLabelFont(this.TICK_FONT);
            rangeAxis2.setAutoRange(false);
            rangeAxis2.setRange(xySeries22.getMinY(), xySeries22.getMaxY());
            plot.setRangeAxis(1, (ValueAxis)rangeAxis2);
            plot.setDataset(1, (XYDataset)series2.getDataset());
            plot.mapDatasetToRangeAxis(1, 1);
            plot = rcChart.getXYPlot();
            NumberAxis rangeAxis3 = new NumberAxis(series3.getDataset().getSeries(0).getKey().toString());
            rangeAxis3.setLabelFont(this.LABEL_FONT);
            rangeAxis3.setTickLabelFont(this.TICK_FONT);
            rangeAxis3.setAutoRange(false);
            rangeAxis3.setRange(xySeries3.getMinY(), xySeries3.getMaxY());
            plot.setRangeAxis(2, (ValueAxis)rangeAxis3);
            plot.setDataset(2, (XYDataset)series3.getDataset());
            plot.mapDatasetToRangeAxis(2, 2);
            plot = rcChart.getXYPlot();
            NumberAxis rangeAxis4 = new NumberAxis(series4.getDataset().getSeries(0).getKey().toString());
            rangeAxis4.setLabelFont(this.LABEL_FONT);
            rangeAxis4.setTickLabelFont(this.TICK_FONT);
            rangeAxis4.setAutoRange(false);
            rangeAxis4.setRange(xySeries4.getMinY(), xySeries4.getMaxY());
            plot.setRangeAxis(3, (ValueAxis)rangeAxis4);
            plot.setDataset(3, (XYDataset)series4.getDataset());
            plot.mapDatasetToRangeAxis(3, 3);
            rcChart.setBackgroundPaint((Paint)Color.white);
            plot = rcChart.getXYPlot();
            plot.setBackgroundPaint((Paint)Color.white);
            plot.setDomainGridlinePaint((Paint)Color.darkGray);
            plot.setRangeGridlinePaint((Paint)Color.darkGray);
            plot.setRenderer(0, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            plot.setRenderer(1, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            plot.setRenderer(2, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            plot.setRenderer(3, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            plot.getRenderer(0).setSeriesPaint(0, (Paint)Color.RED);
            plot.getRenderer(1).setSeriesPaint(0, (Paint)Color.BLUE);
            plot.getRenderer(2).setSeriesPaint(0, (Paint)Color.GREEN);
            plot.getRenderer(3).setSeriesPaint(0, (Paint)Color.BLACK);
            plot.getRenderer(0).setSeriesStroke(0, (Stroke)new BasicStroke(0.5f));
            plot.getRenderer(1).setSeriesStroke(0, (Stroke)new BasicStroke(0.5f));
            plot.getRenderer(2).setSeriesStroke(0, (Stroke)new BasicStroke(0.5f));
            plot.getRenderer(3).setSeriesStroke(0, (Stroke)new BasicStroke(0.5f));
            plot.getDomainAxis().setLabelFont(this.LABEL_FONT);
            plot.getDomainAxis().setTickLabelFont(this.TICK_FONT);
        } else {
            JFSeries series1 = new JFSeries();
            JFSeries series2 = new JFSeries();
            XYSeries xySeries1 = new XYSeries((Comparable)((Object)VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.1")));
            XYSeries xySeries2 = new XYSeries((Comparable)((Object)VNAMessages.getString("VNACalibrationDataDetailsDialog.Series.2")));
            VNABaseSample[] vNABaseSampleArray = this.sampleBlock.getSamples();
            int n = vNABaseSampleArray.length;
            int xySeries22 = 0;
            while (xySeries22 < n) {
                VNABaseSample data = vNABaseSampleArray[xySeries22];
                xySeries1.add((double)data.getFrequency(), (double)data.getLoss());
                xySeries2.add((double)data.getFrequency(), (double)data.getAngle());
                ++xySeries22;
            }
            series1.setSeries(xySeries1);
            series2.setSeries(xySeries2);
            rcChart = ChartFactory.createXYLineChart((String)VNAMessages.getString(this.typeId), (String)VNAMessages.getString("Plot.frequency"), null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            XYPlot plot = rcChart.getXYPlot();
            NumberAxis rangeAxis1 = new NumberAxis(series1.getDataset().getSeries(0).getKey().toString());
            rangeAxis1.setLabelFont(this.LABEL_FONT);
            rangeAxis1.setTickLabelFont(this.TICK_FONT);
            rangeAxis1.setAutoRange(false);
            rangeAxis1.setRange(xySeries1.getMinY(), xySeries1.getMaxY());
            plot.setRangeAxis(0, (ValueAxis)rangeAxis1);
            plot.setDataset(0, (XYDataset)series1.getDataset());
            plot.mapDatasetToRangeAxis(0, 0);
            plot = rcChart.getXYPlot();
            NumberAxis rangeAxis2 = new NumberAxis(series2.getDataset().getSeries(0).getKey().toString());
            rangeAxis2.setLabelFont(this.LABEL_FONT);
            rangeAxis2.setTickLabelFont(this.TICK_FONT);
            rangeAxis2.setAutoRange(false);
            rangeAxis2.setRange(xySeries2.getMinY(), xySeries2.getMaxY());
            plot.setRangeAxis(1, (ValueAxis)rangeAxis2);
            plot.setDataset(1, (XYDataset)series2.getDataset());
            plot.mapDatasetToRangeAxis(1, 1);
            rcChart.setBackgroundPaint((Paint)Color.white);
            plot = rcChart.getXYPlot();
            plot.setBackgroundPaint((Paint)Color.white);
            plot.setDomainGridlinePaint((Paint)Color.darkGray);
            plot.setRangeGridlinePaint((Paint)Color.darkGray);
            plot.setRenderer(0, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            plot.setRenderer(1, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            plot.getRenderer(0).setSeriesPaint(0, (Paint)Color.RED);
            plot.getRenderer(1).setSeriesPaint(0, (Paint)Color.BLUE);
            plot.getRenderer(0).setSeriesStroke(0, (Stroke)new BasicStroke(0.5f));
            plot.getRenderer(1).setSeriesStroke(0, (Stroke)new BasicStroke(0.5f));
            plot.getDomainAxis().setLabelFont(this.LABEL_FONT);
            plot.getDomainAxis().setTickLabelFont(this.TICK_FONT);
        }
        TraceHelper.exit(this, "createChart");
        return rcChart;
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doExit");
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doExit");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.lblImage.setChart(this.chart);
        this.addEscapeKey();
        this.showCentered(this.getWidth(), this.getHeight());
        TraceHelper.exit(this, "doInit");
    }
}

