/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.cable.table;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import krause.vna.gui.cable.VNACableMeasurementPoint;
import krause.vna.gui.format.VNAFormatFactory;

public class VNACableMeasurementPointTableModel
extends AbstractTableModel {
    private List<VNACableMeasurementPoint> data = new ArrayList<VNACableMeasurementPoint>();

    public void addElement(VNACableMeasurementPoint newPair) {
        boolean isNew = true;
        for (VNACableMeasurementPoint pair : this.data) {
            if (!pair.equals(newPair)) continue;
            isNew = false;
            break;
        }
        if (isNew) {
            this.data.add(newPair);
            this.fireTableDataChanged();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void clear() {
        this.data.clear();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Start";
        }
        if (column == 1) {
            return "Stop";
        }
        if (column == 2) {
            return "Length";
        }
        return "???";
    }

    public List<VNACableMeasurementPoint> getData() {
        return this.data;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String rc = null;
        VNACableMeasurementPoint pair = this.data.get(rowIndex);
        rc = columnIndex == 0 ? String.valueOf(VNAFormatFactory.getFrequencyFormat().format(pair.getStart().getFrequency())) + " - " + VNAFormatFactory.getPhaseFormat().format(pair.getStart().getReflectionPhase()) : (columnIndex == 1 ? String.valueOf(VNAFormatFactory.getFrequencyFormat().format(pair.getStop().getFrequency())) + " - " + VNAFormatFactory.getPhaseFormat().format(pair.getStop().getReflectionPhase()) : (columnIndex == 2 ? VNAFormatFactory.getLengthFormat().format(pair.getLength()) : "???"));
        return rc;
    }
}

