/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.cable;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.gui.cable.VNAVelocityFactor;
import krause.vna.gui.format.VNAFormatFactory;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;

public class VNAVelocityFactorTableModel
extends AbstractTableModel {
    private static final VNAConfig config = VNAConfig.getSingleton();
    private static final NumberFormat nfResistance = VNAFormatFactory.getResistanceFormat();
    private static final NumberFormat nfVelocity = VNAFormatFactory.getVelocityFormat();
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String CONFIG_FILE = "cables.csv";
    private static final String CONFIG_PATHNAME = String.valueOf(config.getVNAConfigDirectory()) + FILE_SEP + "cables.csv";
    private static final List<VNAVelocityFactor> cables = new ArrayList<VNAVelocityFactor>();
    private static final CellProcessor[] cellProcessors = new CellProcessor[]{new NotNull(), new ParseDouble(), new Optional(), new Optional(), new Optional(), new Optional(), new ParseDouble()};

    private void fillDefaults() {
        TraceHelper.entry(this, "filLDefaults");
        cables.add(new VNAVelocityFactor("5D-2V", 0.67));
        cables.add(new VNAVelocityFactor("8D-2V", 0.67));
        cables.add(new VNAVelocityFactor("5D-FB", 0.8));
        cables.add(new VNAVelocityFactor("8D-FB", 0.8));
        cables.add(new VNAVelocityFactor("3.5D-SFA", 0.83));
        cables.add(new VNAVelocityFactor("5D-SFA", 0.83));
        cables.add(new VNAVelocityFactor("8D-SFA", 0.83));
        cables.add(new VNAVelocityFactor("Aircell5", 50.0, 0.82, "9.40", "100.0", "31.09", "1000.0"));
        cables.add(new VNAVelocityFactor("Aircell7", 50.0, 0.83, "6.28", "100.0", "21.25", "1000.0"));
        cables.add(new VNAVelocityFactor("Aircom Plus", 50.0, 0.83, "3.80", "100.0", "13.40", "1000.0"));
        cables.add(new VNAVelocityFactor("Ecoflex10 Std.", 50.0, 0.83, "4.00", "100.0", "14.20", "1000.0"));
        cables.add(new VNAVelocityFactor("Ecoflex15 Std", 50.0, 0.83, "2.81", "100.0", "9.81", "1000.0"));
        cables.add(new VNAVelocityFactor("Belden 8240", 50.0, 0.66, "4.90", "100.0", "20.0", "1000.0"));
        cables.add(new VNAVelocityFactor("Belden 8267", 50.0, 0.66, "2.20", "100.0", "8.0", "1000.0"));
        cables.add(new VNAVelocityFactor("Belden 8208", 50.0, 0.66, "", "", "8.0", "1000.0"));
        cables.add(new VNAVelocityFactor("Belden 9258", 50.0, 0.78, "3.70", "100.0", "12.8", "1000.0"));
        cables.add(new VNAVelocityFactor("Belden 9880", 50.0, 0.82, "1.30", "100.0", "4.5", "1000.0"));
        cables.add(new VNAVelocityFactor("Belden 9913", 50.0, 0.82, "1.30", "100.0", "4.5", "1000.0"));
        cables.add(new VNAVelocityFactor("Belden 9914", 50.0, 0.66, "", "", "9.0", "1000.0"));
        cables.add(new VNAVelocityFactor("Belden H155A01", 50.0, 0.8, "", "", "9.0", "1000.0"));
        cables.add(new VNAVelocityFactor("Foam (0.100 in. nominal diameter)", 0.66));
        cables.add(new VNAVelocityFactor("Foam (0.195 in. nominal diameter)", 0.75));
        cables.add(new VNAVelocityFactor("Foam (0.240 in. nominal diameter)", 0.83));
        cables.add(new VNAVelocityFactor("Foam (0.300 in. nominal diameter)", 0.83));
        cables.add(new VNAVelocityFactor("Foam (0.400 in. nominal diameter)", 0.85));
        cables.add(new VNAVelocityFactor("Foam (0.500 in. nominal diameter)", 0.86));
        cables.add(new VNAVelocityFactor("Foam (0.600 in. nominal diameter)", 0.87));
        cables.add(new VNAVelocityFactor("H155", 50.0, 0.81));
        cables.add(new VNAVelocityFactor("H2000 Flex", 50.0, 0.83));
        cables.add(new VNAVelocityFactor("RG-5 /U", 52.5, 0.659, "0.77", "10.0", "2.90", "100"));
        cables.add(new VNAVelocityFactor("RG-5 B/U", 50.0, 0.659, "0.66", "10.0", "2.40", "100.0"));
        cables.add(new VNAVelocityFactor("RG-6 A/U", 75.0, 0.659, "0.78", "10.0", "2.90", "100.0"));
        cables.add(new VNAVelocityFactor("RG-6 Foam", 75.0, 0.78, "5.30", "50.0", "16.20", "500.0"));
        cables.add(new VNAVelocityFactor("RG-8 A/U", 50.0, 0.659, "0.55", "10.0", "2.00", "100.0"));
        cables.add(new VNAVelocityFactor("RG-8 foam", 50.0, 0.8, "1.70", "100.0", "6.0", "1000.0"));
        cables.add(new VNAVelocityFactor("RG-9 /U", 51.0, 0.659, "0.57", "10.0", "2.00", "100.0"));
        cables.add(new VNAVelocityFactor("RG-9 B/U", 50.0, 0.659, "0.61", "10.0", "2.10", "100.0"));
        cables.add(new VNAVelocityFactor("RG-10 A/U", 50.0, 0.659, "0.55", "10.0", "2.00", "100.0"));
        cables.add(new VNAVelocityFactor("RG-11 A/U", 75.0, 0.66, "0.70", "10.0", "2.30", "100.0"));
        cables.add(new VNAVelocityFactor("RG-11 foam", 75.0, 0.78, "3.30", "50.0", "12.10", "500.0"));
        cables.add(new VNAVelocityFactor("RG-12 A/U", 75.0, 0.659, "0.66", "10.0", "2.30", "100.0"));
        cables.add(new VNAVelocityFactor("RG-13 A/U", 75.0, 0.659, "0.66", "10.0", "2.30", "100.0"));
        cables.add(new VNAVelocityFactor("RG-14 A/U", 50.0, 0.659, "0.41", "10.0", "1.40", "100.0"));
        cables.add(new VNAVelocityFactor("RG-16 A/U", 52.0, 0.67, "0.40", "10.0", "1.20", "100.0"));
        cables.add(new VNAVelocityFactor("RG-17 A/U", 50.0, 0.659, "0.23", "10.0", "0.80", "100.0"));
        cables.add(new VNAVelocityFactor("RG-18 A/U", 50.0, 0.659, "0.23", "10.0", "0.80", "100.0"));
        cables.add(new VNAVelocityFactor("RG-19 A/U", 50.0, 0.659, "0.17", "10.0", "0.68", "100.0"));
        cables.add(new VNAVelocityFactor("RG-20 A/U", 50.0, 0.659, "0.17", "10.0", "0.68", "100.0"));
        cables.add(new VNAVelocityFactor("RG-21 A/U", 50.0, 0.659, "4.40", "10.0", "13.00", "100.0"));
        cables.add(new VNAVelocityFactor("RG-29 /U", 53.5, 0.659, "1.20", "10.0", "4.40", "100.0"));
        cables.add(new VNAVelocityFactor("RG-34 A/U", 75.0, 0.659, "0.29", "10.0", "1.30", "100.0"));
        cables.add(new VNAVelocityFactor("RG-34 B/U", 75.0, 0.66, "0.30", "10.0", "1.40", "100.0"));
        cables.add(new VNAVelocityFactor("RG-35 A/U", 75.0, 0.659, "0.24", "10.0", "0.85", "100.0"));
        cables.add(new VNAVelocityFactor("RG-54 A/U", 58.0, 0.659, "0.74", "10.0", "3.10", "100.0"));
        cables.add(new VNAVelocityFactor("RG-55 B/U", 53.5, 0.659, "1.30", "10.0", "4.80", "100.0"));
        cables.add(new VNAVelocityFactor("RG-55 A/U", 50.0, 0.659, "1.30", "10.0", "4.80", "100.0"));
        cables.add(new VNAVelocityFactor("RG-58 /U", 53.5, 0.66, "1.25", "10.0", "4.65", "100.0"));
        cables.add(new VNAVelocityFactor("RG-58 A/U", 53.5, 0.659, "1.25", "10.0", "4.65", "100.0"));
        cables.add(new VNAVelocityFactor("RG-58 C/U", 50.0, 0.659, "1.40", "10.0", "4.90", "100.0"));
        cables.add(new VNAVelocityFactor("RG-58 foam", 53.5, 0.79, "3.80", "100.0", "6.0", "300.0"));
        cables.add(new VNAVelocityFactor("RG-59 A/U", 75.0, 0.659, "1.10", "10.0", "3.40", "100.0"));
        cables.add(new VNAVelocityFactor("RG-59 B/U", 75.0, 0.66, "1.10", "10.0", "3.40", "100.0"));
        cables.add(new VNAVelocityFactor("RG-59 foam", 75.0, 0.79, "3.80", "100.0", "6.0", "300.0"));
        cables.add(new VNAVelocityFactor("RG-62 A/U", 93.0, 0.84, "0.85", "10.0", "2.70", "100.0"));
        cables.add(new VNAVelocityFactor("RG-74 A/U", 50.0, 0.659, "0.38", "10.0", "1.50", "100.0"));
        cables.add(new VNAVelocityFactor("RG-83/U", 35.0, 0.66, "0.80", "10.0", "2.80", "100.0"));
        cables.add(new VNAVelocityFactor("RG-142 B/U", 50.0, 0.7));
        cables.add(new VNAVelocityFactor("RG-174 A/U", 50.0, 0.66, "3.40", "10.0", "10.60", "100.0"));
        cables.add(new VNAVelocityFactor("RG-178 B/U", 50.0, 0.7));
        cables.add(new VNAVelocityFactor("RG-179 B/U", 75.0, 0.7));
        cables.add(new VNAVelocityFactor("RG-188 B/U", 50.0, 0.7));
        cables.add(new VNAVelocityFactor("RG-213/U", 50.0, 0.66, "0.60", "10.0", "1.90", "100.0"));
        cables.add(new VNAVelocityFactor("RG-218/U", 50.0, 0.66, "0.20", "10.0", "1.00", "100.0"));
        cables.add(new VNAVelocityFactor("RG-220/U", 50.0, 0.66, "0.20", "10.0", "0.70", "100.0"));
        cables.add(new VNAVelocityFactor("RG-316 B/U", 50.0, 0.7));
        cables.add(new VNAVelocityFactor("SUHNER RG-233/U-01", 50.0, 0.66, "0.20", "10.0", "0.70", "100.0"));
        cables.add(new VNAVelocityFactor("UR-43", 52.0, 0.66, "1.30", "10.0", "4.3", "100.0"));
        cables.add(new VNAVelocityFactor("UR-57", 75.0, 0.66, "0.60", "10.0", "1.9", "100.0"));
        cables.add(new VNAVelocityFactor("UR-63", 75.0, 0.96, "0.15", "10.0", "0.5", "100.0"));
        cables.add(new VNAVelocityFactor("UR-67", 50.0, 0.66, "0.60", "10.0", "2.0", "100.0"));
        cables.add(new VNAVelocityFactor("UR-70", 75.0, 0.66, "1.50", "10.0", "4.9", "100.0"));
        cables.add(new VNAVelocityFactor("UR-74", 51.0, 0.66, "0.30", "10.0", "1.0", "100.0"));
        cables.add(new VNAVelocityFactor("UR-76", 51.0, 0.66, "1.60", "10.0", "5.3", "100.0"));
        cables.add(new VNAVelocityFactor("UR-77", 75.0, 0.66, "0.30", "10.0", "1.0", "100.0"));
        cables.add(new VNAVelocityFactor("UR-79", 50.0, 0.96, "0.16", "10.0", "0.5", "100.0"));
        cables.add(new VNAVelocityFactor("UR-83", 50.0, 0.96, "0.25", "10.0", "0.8", "100.0"));
        cables.add(new VNAVelocityFactor("UR-85", 75.0, 0.96, "0.20", "10.0", "0.7", "100.0"));
        cables.add(new VNAVelocityFactor("UR-90", 75.0, 0.66, "1.10", "10.0", "3.5", "100.0"));
        cables.add(new VNAVelocityFactor("UR-95", 50.0, 0.66, "2.60", "10.0", "8.2", "100.0"));
        TraceHelper.entry(this, "filLDefaults");
    }

    public VNAVelocityFactorTableModel() {
        TraceHelper.entry(this, "VNAVelocityFactorTableModel");
        this.readCSV();
        TraceHelper.exit(this, "VNAVelocityFactorTableModel");
    }

    private void readCSV() {
        block15: {
            TraceHelper.entry(this, "readCSV");
            CsvBeanReader beanReader = null;
            try {
                try {
                    VNAVelocityFactor cable;
                    beanReader = new CsvBeanReader((Reader)new FileReader(CONFIG_PATHNAME), CsvPreference.STANDARD_PREFERENCE);
                    String[] header = beanReader.getHeader(true);
                    while ((cable = (VNAVelocityFactor)beanReader.read(VNAVelocityFactor.class, header, cellProcessors)) != null) {
                        cables.add(cable);
                    }
                }
                catch (Exception ex) {
                    ErrorLogHelper.text(this, "readCSV", ex.getMessage());
                    this.fillDefaults();
                    this.createCSV();
                    if (beanReader != null) {
                        try {
                            beanReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (beanReader != null) {
                    try {
                        beanReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (beanReader != null) {
                try {
                    beanReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        TraceHelper.exit(this, "readCSV");
    }

    private void createCSV() {
        block15: {
            TraceHelper.entry(this, "createCSV");
            CsvBeanWriter beanWriter = null;
            try {
                try {
                    beanWriter = new CsvBeanWriter((Writer)new FileWriter(CONFIG_PATHNAME), CsvPreference.STANDARD_PREFERENCE);
                    String[] header = new String[]{"name", "z0", "f1", "attenF1", "f2", "attenF2", "vf"};
                    beanWriter.writeHeader(header);
                    for (VNAVelocityFactor cable : cables) {
                        beanWriter.write((Object)cable, header, cellProcessors);
                    }
                }
                catch (Exception ex) {
                    ErrorLogHelper.exception(this, "createCSV", ex);
                    if (beanWriter != null) {
                        try {
                            beanWriter.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (beanWriter != null) {
                    try {
                        beanWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (beanWriter != null) {
                try {
                    beanWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        TraceHelper.exit(this, "createCSV");
    }

    public int getSize() {
        return cables.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return cables.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        VNAVelocityFactor item = cables.get(row);
        switch (column) {
            case 0: {
                return item.getName();
            }
            case 1: {
                return nfVelocity.format(item.getVf());
            }
            case 2: {
                return nfResistance.format(item.getZ0());
            }
            case 3: {
                return item.getF1();
            }
            case 4: {
                return item.getAttenF1();
            }
            case 5: {
                return item.getF2();
            }
            case 6: {
                return item.getAttenF2();
            }
        }
        return "???";
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Vf";
            }
            case 2: {
                return "Z0";
            }
            case 3: {
                return "f1 (MHz)";
            }
            case 4: {
                return "loss@f1 (dB/100m)";
            }
            case 5: {
                return "f2 (MHz)";
            }
            case 6: {
                return "loss@f2 (dB/100m)";
            }
        }
        return "??";
    }

    public VNAVelocityFactor getDataAtRow(int row) {
        if (row >= 0 && row < cables.size()) {
            return cables.get(row);
        }
        return null;
    }
}

