/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.cable;

import java.util.ArrayList;
import java.util.List;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.gui.cable.VNACableMeasurementPoint;

public class VNACableMeasurementHelper {
    private boolean metricMode;
    private boolean scale360;

    public VNACableMeasurementHelper(boolean scale, boolean meter) {
        TraceHelper.exit(this, "VNACableMeasurementHelper");
        this.scale360 = scale;
        this.metricMode = meter;
        TraceHelper.exit(this, "VNACableMeasurementHelper");
    }

    public VNACableMeasurementPoint calculateLength(List<VNACalibratedSample> points, double pVelocity) {
        TraceHelper.entry(this, "calculateLength");
        VNACableMeasurementPoint rc = null;
        if (points != null && points.size() == 2) {
            VNACableMeasurementPoint p1 = new VNACableMeasurementPoint(this.metricMode, this.scale360);
            p1.setStart(points.get(0));
            p1.setStop(points.get(1));
            p1.calculateLength(pVelocity);
            rc = p1;
        }
        TraceHelper.exitWithRC((Object)this, "calculateLength", rc);
        return rc;
    }

    public VNACableMeasurementPoint calculateVelocityFactor(List<VNACalibratedSample> points, double pCableLength) {
        TraceHelper.entry(this, "calculateVelocityFactor");
        VNACableMeasurementPoint rc = null;
        if (points != null && points.size() == 2) {
            VNACableMeasurementPoint p1 = new VNACableMeasurementPoint(this.metricMode, this.scale360);
            p1.setStart(points.get(0));
            p1.setStop(points.get(1));
            p1.calculateVelocityFactor(pCableLength);
            rc = p1;
        }
        TraceHelper.exitWithRC((Object)this, "calculateVelocityFactor", rc);
        return rc;
    }

    public List<VNACalibratedSample> findAllCrossingPoints(VNACalibratedSampleBlock samples) {
        List<Object> rc = new ArrayList();
        rc = this.scale360 ? this.findAllCrossingPointsWithSign(samples) : this.findAllCrossingPointsWithoutSign(samples);
        return rc;
    }

    private List<VNACalibratedSample> findAllCrossingPointsWithoutSign(VNACalibratedSampleBlock samples) {
        TraceHelper.entry(this, "findAllCrossingPointsWithoutSign");
        ArrayList<VNACalibratedSample> rc = new ArrayList<VNACalibratedSample>();
        VNACalibratedSample[] calibratedSample = samples.getCalibratedSamples();
        double lastPhase = calibratedSample[10].getReflectionPhase();
        int state = 0;
        int i = 10;
        int max = calibratedSample.length;
        while (i < max && state != 99) {
            VNACalibratedSample currentSample = calibratedSample[i];
            double phase = currentSample.getReflectionPhase();
            switch (state) {
                case 0: {
                    if (phase >= 90.0 && lastPhase < 90.0) {
                        rc.add(currentSample);
                        state = 1;
                        break;
                    }
                    if (!(phase < 90.0) || !(lastPhase >= 90.0)) break;
                    rc.add(currentSample);
                    state = 0;
                    break;
                }
                case 1: {
                    if (!(phase < 90.0) || !(lastPhase >= 90.0)) break;
                    rc.add(currentSample);
                    state = 0;
                }
            }
            lastPhase = phase;
            ++i;
        }
        TraceHelper.exitWithRC((Object)this, "findAllCrossingPointsWithoutSign", "#=" + rc.size());
        return rc;
    }

    public List<VNACalibratedSample> findAllCrossingPointsWithSign(VNACalibratedSampleBlock samples) {
        TraceHelper.entry(this, "findAllCrossingPointsWithSign");
        ArrayList<VNACalibratedSample> rc = new ArrayList<VNACalibratedSample>();
        VNACalibratedSample[] calibratedSample = samples.getCalibratedSamples();
        double lastPhase = calibratedSample[10].getReflectionPhase();
        int state = 0;
        int i = 10;
        int max = calibratedSample.length;
        while (i < max && state != 99) {
            VNACalibratedSample currentSample = calibratedSample[i];
            double phase = currentSample.getReflectionPhase();
            if (phase > 0.0 && lastPhase < 0.0) {
                rc.add(currentSample);
                TraceHelper.text(this, "findAllCrossingPointsWithSign", "state=" + state + " a f=" + currentSample.getFrequency() + " \u00b0=" + phase + " last\u00b0=" + lastPhase);
                state = 1;
            } else if (phase < 0.0 && lastPhase >= 0.0) {
                TraceHelper.text(this, "findAllCrossingPointsWithSign", "state=" + state + " b f=" + currentSample.getFrequency() + " \u00b0=" + phase + " last\u00b0=" + lastPhase);
                rc.add(currentSample);
                state = 0;
            }
            lastPhase = phase;
            ++i;
        }
        TraceHelper.exitWithRC((Object)this, "findAllCrossingPointsWithSign", "#=" + rc.size());
        return rc;
    }

    public List<VNACalibratedSample> findTwoCrossingPoints(VNACalibratedSampleBlock samples) {
        List<Object> rc = new ArrayList();
        rc = this.scale360 ? this.findTwoCrossingPointsWithSign(samples) : this.findTwoCrossingPointsWithoutSign(samples);
        return rc;
    }

    public List<VNACalibratedSample> findTwoCrossingPointsWithoutSign(VNACalibratedSampleBlock samples) {
        TraceHelper.entry(this, "findTwoCrossingPointsWithoutSign");
        ArrayList<VNACalibratedSample> rc = new ArrayList<VNACalibratedSample>();
        VNACalibratedSample firstPoint = null;
        VNACalibratedSample secondPoint = null;
        int startIndex = 10;
        VNACalibratedSample sample1 = samples.getCalibratedSamples()[10];
        VNACalibratedSample sample2 = samples.getCalibratedSamples()[11];
        boolean fromLow = sample1.getReflectionPhase() < sample2.getReflectionPhase();
        int state = 0;
        int i = 10;
        int max = samples.getCalibratedSamples().length;
        while (i < max && state != 99) {
            VNACalibratedSample currentSample = samples.getCalibratedSamples()[i];
            double phase = currentSample.getReflectionPhase();
            switch (state) {
                case 0: {
                    if (fromLow) {
                        if (!(phase > 90.0)) break;
                        firstPoint = currentSample;
                        rc.add(firstPoint);
                        state = 1;
                        i += 10;
                        break;
                    }
                    if (!(phase < 90.0)) break;
                    firstPoint = currentSample;
                    rc.add(firstPoint);
                    state = 1;
                    i += 10;
                    break;
                }
                case 1: {
                    if (fromLow) {
                        if (!(phase < 90.0)) break;
                        state = 2;
                        i += 10;
                        break;
                    }
                    if (!(phase > 90.0)) break;
                    state = 2;
                    i += 10;
                    break;
                }
                case 2: {
                    if (fromLow) {
                        if (!(phase > 90.0)) break;
                        secondPoint = currentSample;
                        rc.add(secondPoint);
                        state = 99;
                        break;
                    }
                    if (!(phase < 90.0)) break;
                    secondPoint = currentSample;
                    rc.add(secondPoint);
                    state = 99;
                }
            }
            ++i;
        }
        TraceHelper.exit(this, "findTwoCrossingPointsWithoutSign");
        return rc;
    }

    public List<VNACalibratedSample> findTwoCrossingPointsWithSign(VNACalibratedSampleBlock samples) {
        ArrayList<VNACalibratedSample> rc = new ArrayList<VNACalibratedSample>();
        VNACalibratedSample firstPoint = null;
        VNACalibratedSample secondPoint = null;
        VNACalibratedSample[] calibratedSample = samples.getCalibratedSamples();
        double lastPhase = calibratedSample[10].getReflectionPhase();
        int state = 0;
        int i = 10;
        int max = calibratedSample.length;
        while (i < max && state != 99) {
            VNACalibratedSample currentSample = calibratedSample[i];
            double phase = currentSample.getReflectionPhase();
            switch (state) {
                case 0: {
                    if (!(phase > 0.0) || !(lastPhase < 0.0)) break;
                    firstPoint = currentSample;
                    rc.add(firstPoint);
                    state = 1;
                    break;
                }
                case 1: {
                    if (!(phase > 0.0) || !(lastPhase < 0.0)) break;
                    secondPoint = currentSample;
                    rc.add(secondPoint);
                    state = 99;
                }
            }
            lastPhase = phase;
            ++i;
        }
        return rc;
    }
}

