/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.cable;

import com.l2fprod.common.swing.StatusBar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.VNABackgroundJob;
import krause.vna.background.VnaBackgroundTask;
import krause.vna.config.VNAConfig;
import krause.vna.data.IVNADataConsumer;
import krause.vna.data.VNADataPool;
import krause.vna.data.VNAFrequencyRange;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.calibrated.VNACalibrationContext;
import krause.vna.data.helper.VNACalibrationBlockHelper;
import krause.vna.device.IVNADriverMathHelper;
import krause.vna.gui.cable.VNACableMeasurementHelper;
import krause.vna.gui.cable.VNAPhaseCrossingTable;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class VNACableLossDialog
extends KrauseDialog
implements IVNADataConsumer {
    private static final Color COLOR_LEFT_SCALE = Color.BLUE;
    private static final float STROKE_WIDTH = 1.0f;
    private final Font LABEL_FONT = new Font("SansSerif", 0, 10);
    private final Font TICK_FONT = new Font("SansSerif", 0, 10);
    private JButton btMeasure;
    private JButton btOK;
    private VNAConfig config = VNAConfig.getSingleton();
    private VNADataPool datapool = VNADataPool.getSingleton();
    private ChartPanel lblImage;
    private StatusBar statusBar;
    private JCheckBox cbPeakSuppression;
    private VNAPhaseCrossingTable tblCrossings;

    public VNACableLossDialog(Frame pMainFrame) {
        super((Window)pMainFrame, true);
        TraceHelper.entry(this, "VNACableLossDialog");
        this.setConfigurationPrefix("VNACableLossDialog");
        this.setProperties(this.config);
        this.setTitle(VNAMessages.getString("VNACableLossDialog"));
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(850, 600));
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[grow,fill][][]", "[grow,fill][][]"));
        this.lblImage = new ChartPanel(null, true);
        this.lblImage.setBorder((Border)new TitledBorder(null, "", 4, 2, null, null));
        this.lblImage.setIgnoreRepaint(true);
        this.lblImage.setPreferredSize(new Dimension(400, 300));
        this.lblImage.setMinimumSize(new Dimension(400, 300));
        this.getContentPane().add((Component)this.lblImage, "span 2");
        this.tblCrossings = new VNAPhaseCrossingTable();
        JScrollPane scrollPane = new JScrollPane(this.tblCrossings);
        scrollPane.setViewportBorder(null);
        this.getContentPane().add((Component)scrollPane, "wrap");
        this.btOK = new JButton(VNAMessages.getString("Button.Close"));
        this.getContentPane().add((Component)this.btOK, "left");
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNACableLossDialog.this.doCANCEL();
            }
        });
        this.cbPeakSuppression = new JCheckBox(VNAMessages.getString("VNACableLengthDialog.cbAverage"));
        this.cbPeakSuppression.setSelected(true);
        this.getContentPane().add((Component)this.cbPeakSuppression, "center");
        this.btMeasure = new JButton(VNAMessages.getString("VNACableLengthDialog.btMeasure.text"));
        this.getContentPane().add((Component)this.btMeasure, "right,wrap");
        this.btMeasure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNACableLossDialog.this.doMeasure();
            }
        });
        this.statusBar = new StatusBar();
        this.getContentPane().add((Component)this.statusBar, "span 3,grow");
        JLabel lbl = new JLabel();
        lbl.setOpaque(true);
        this.statusBar.addZone("status", lbl, "*");
        this.doInit();
    }

    @Override
    public void consumeDataBlock(List<VNABackgroundJob> jobs) {
        TraceHelper.entry(this, "consumeDataBlock");
        if (jobs.size() == 1) {
            VNASampleBlock rawData = jobs.get(0).getResult();
            if (rawData != null) {
                IVNADriverMathHelper mathHelper = rawData.getMathHelper();
                if (mathHelper != null) {
                    VNACalibrationBlock mainCalibrationBlock = this.datapool.getMainCalibrationBlock();
                    if (mainCalibrationBlock != null) {
                        VNACalibrationBlock resizedCalibrationBlock = VNACalibrationBlockHelper.createResizedCalibrationBlock(mainCalibrationBlock, rawData.getStartFrequency(), rawData.getStopFrequency(), rawData.getNumberOfSteps());
                        VNACalibrationContext context = mathHelper.createCalibrationContextForCalibratedSamples(resizedCalibrationBlock);
                        context.setConversionTemperature(rawData.getDeviceTemperature());
                        VNACalibratedSampleBlock samples = mathHelper.createCalibratedSamples(context, rawData);
                        VNACableMeasurementHelper helper = new VNACableMeasurementHelper(mathHelper.getDriver().getDeviceInfoBlock().getMinPhase() < 0.0, false);
                        List<VNACalibratedSample> allPoints = helper.findAllCrossingPoints(samples);
                        if (allPoints.size() < 4) {
                            JOptionPane.showMessageDialog(this.getOwner(), VNAMessages.getString("VNACableLossDialog.TooShort.msg"), VNAMessages.getString("VNACableLossDialog.TooShort.title"), 2);
                        } else {
                            this.tblCrossings.getModel().clear();
                            for (VNACalibratedSample aSample : allPoints) {
                                this.tblCrossings.getModel().add(aSample);
                            }
                            this.tblCrossings.updateUI();
                            this.lblImage.setChart(this.createChart(allPoints));
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.getOwner(), VNAMessages.getString("VNACableLossDialog.InternalError.msg"), VNAMessages.getString("VNACableLossDialog.InternalError.title"), 2);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.getOwner(), VNAMessages.getString("VNACableLossDialog.InternalError.msg"), VNAMessages.getString("VNACableLossDialog.InternalError.title"), 2);
                }
            } else {
                JOptionPane.showMessageDialog(this.getOwner(), VNAMessages.getString("VNACableLossDialog.InternalError.msg"), VNAMessages.getString("VNACableLossDialog.InternalError.title"), 2);
            }
        } else {
            JOptionPane.showMessageDialog(this.getOwner(), VNAMessages.getString("VNACableLossDialog.InternalError.msg"), VNAMessages.getString("VNACableLossDialog.InternalError.title"), 2);
        }
        this.btMeasure.setEnabled(true);
        this.btOK.setEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
        TraceHelper.exit(this, "consumeDataBlock");
    }

    private JFreeChart createChart(List<VNACalibratedSample> allPoints) {
        TraceHelper.entry(this, "createChart");
        for (VNACalibratedSample data : allPoints) {
            data.setReflectionLoss(-data.getReflectionLoss() / 2.0);
        }
        if (this.cbPeakSuppression.isSelected()) {
            this.calculateMovingAverage(allPoints);
        }
        XYSeries xySeries = new XYSeries((Comparable)((Object)VNAMessages.getString("VNACableLossDialog.1")));
        for (VNACalibratedSample data : allPoints) {
            xySeries.add((double)data.getFrequency(), data.getReflectionLoss());
        }
        XYSeriesCollection xysc = new XYSeriesCollection();
        xysc.addSeries(xySeries);
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)VNAMessages.getString("VNACableLossDialog.3"), (String)VNAMessages.getString("VNACableLossDialog.1"), (XYDataset)xysc, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        NumberAxis rangeAxis = new NumberAxis(xySeries.getKey().toString());
        rangeAxis.setLabelFont(this.LABEL_FONT);
        rangeAxis.setTickLabelFont(this.TICK_FONT);
        plot.setRangeAxis(0, (ValueAxis)rangeAxis);
        plot.setDataset(0, (XYDataset)xysc);
        if (rangeAxis.getUpperBound() < 1.0) {
            rangeAxis.setAutoRange(false);
            rangeAxis.setUpperBound(1.0);
        }
        plot.mapDatasetToRangeAxis(0, 0);
        chart.setBackgroundPaint((Paint)Color.white);
        plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.darkGray);
        plot.setRangeGridlinePaint((Paint)Color.darkGray);
        plot.setRenderer(0, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
        plot.getRenderer(0).setSeriesPaint(0, (Paint)COLOR_LEFT_SCALE);
        plot.getRenderer(0).setSeriesStroke(0, (Stroke)new BasicStroke(1.0f));
        rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.getDomainAxis().setLabelFont(this.LABEL_FONT);
        plot.getDomainAxis().setTickLabelFont(this.TICK_FONT);
        TraceHelper.exit(this, "createChart");
        return chart;
    }

    private void calculateMovingAverage(List<VNACalibratedSample> pData) {
        TraceHelper.entry(this, "calculateMovingAverage");
        double[] coeff = new double[]{0.25, 0.25, 0.25, 0.25};
        int numCoeff = coeff.length;
        if (pData.size() > numCoeff) {
            double[] latches = new double[numCoeff];
            int numSamples = pData.size();
            int c = 0;
            while (c < numCoeff) {
                latches[numCoeff - c - 1] = pData.get(c).getReflectionLoss();
                ++c;
            }
            int i = numCoeff;
            while (i < numSamples) {
                int x = numCoeff - 1;
                while (x > 0) {
                    latches[x] = latches[x - 1];
                    --x;
                }
                latches[0] = pData.get(i).getReflectionLoss();
                double newSample = 0.0;
                int c2 = 0;
                while (c2 < numCoeff) {
                    newSample += coeff[c2] * latches[c2];
                    ++c2;
                }
                pData.get(i).setReflectionLoss(newSample);
                ++i;
            }
        }
        TraceHelper.exit(this, "calculateMovingAverage");
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        ((JLabel)this.statusBar.getZone("status")).setText(VNAMessages.getString("VNACableLossDialog.description"));
        this.addEscapeKey();
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    private void doMeasure() {
        TraceHelper.entry(this, "doMeasure");
        long startFreq = this.datapool.getMainCalibrationBlock().getStartFrequency();
        long stopFreq = this.datapool.getMainCalibrationBlock().getStopFrequency();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.btMeasure.setEnabled(false);
        this.btOK.setEnabled(false);
        VNABackgroundJob job = new VNABackgroundJob();
        job.setNumberOfSamples(1000);
        job.setFrequencyRange(new VNAFrequencyRange(startFreq, stopFreq));
        job.setScanMode(VNAScanMode.MODE_REFLECTION);
        job.setSpeedup(1);
        VnaBackgroundTask backgroundTask = new VnaBackgroundTask(this.datapool.getDriver());
        backgroundTask.addJob(job);
        backgroundTask.setStatusLabel((JLabel)this.statusBar.getZone("status"));
        backgroundTask.addDataConsumer(this);
        backgroundTask.execute();
        TraceHelper.exit(this, "doMeasure");
    }
}

