/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.cable;

import com.l2fprod.common.swing.StatusBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.VNABackgroundJob;
import krause.vna.background.VnaBackgroundTask;
import krause.vna.config.VNAConfig;
import krause.vna.data.IVNADataConsumer;
import krause.vna.data.VNADataPool;
import krause.vna.data.VNAFrequencyRange;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.calibrated.VNACalibrationContext;
import krause.vna.data.helper.VNACalibrationBlockHelper;
import krause.vna.device.IVNADriverMathHelper;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.cable.VNACableMeasurementHelper;
import krause.vna.gui.cable.VNACableMeasurementPoint;
import krause.vna.gui.cable.VNAVelocityFactorTable;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;

public class VNACableLengthDialog
extends KrauseDialog
implements IVNADataConsumer {
    private JButton btMeasure;
    private JButton btOK;
    private VNAVelocityFactorTable tblVelocity;
    private JLabel lblVelocityFactor1;
    private JTextField txtLength1;
    private VNAMainFrame mainFrame;
    private JTextField txtLength2;
    private JTextField txtVelocityFactor2;
    private JPanel pnlVariableVelocity;
    private JLabel lblVelocityFactor3;
    private JTextField txtVelocityFactor3;
    private JLabel lblLength3;
    private JTextField txtLength3;
    private JPanel pnlKnownCableLength;
    private JPanel pnlKnownVelocity;
    private VNADeviceInfoBlock dib;
    private VNAConfig config = VNAConfig.getSingleton();
    private VNADataPool datapool = VNADataPool.getSingleton();
    private JRadioButton rdbtnM;
    private JRadioButton rdbtnFeet;
    private JLabel lblUnit;
    private VNACalibratedSampleBlock samples;
    private long startFreq;
    private long stopFreq;
    private int numIterations;
    private JPanel pnlButtons;
    private StatusBar statusBar;

    public VNACableLengthDialog(VNAMainFrame pMainFrame) {
        super((Window)pMainFrame.getJFrame(), true);
        this.mainFrame = pMainFrame;
        this.dib = this.datapool.getDriver().getDeviceInfoBlock();
        this.setConfigurationPrefix("CableLength");
        this.setProperties(this.config);
        this.setTitle(VNAMessages.getString("VNACableLengthDialog.title"));
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(850, 600));
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[grow,fill]", "[][][][grow,fill]"));
        this.pnlKnownVelocity = new JPanel();
        this.getContentPane().add((Component)this.pnlKnownVelocity, "wrap");
        this.pnlKnownVelocity.setBorder(new TitledBorder(null, VNAMessages.getString("VNACableLengthDialog.rdbtnKnowVelocityFactor.text"), 4, 2, null, null));
        this.pnlKnownVelocity.setLayout((LayoutManager)new MigLayout("", "[][grow,fill]", "[]"));
        this.lblVelocityFactor1 = new JLabel(VNAMessages.getString("VNACableLengthDialog.lblVelocityFactor.text"));
        this.pnlKnownVelocity.add((Component)this.lblVelocityFactor1, "");
        this.tblVelocity = new VNAVelocityFactorTable(null);
        JScrollPane scrollPane = new JScrollPane(this.tblVelocity);
        scrollPane.setViewportBorder(null);
        this.pnlKnownVelocity.add((Component)scrollPane, "wrap");
        JLabel lblLength1 = new JLabel(VNAMessages.getString("VNACableLengthDialog.lblLength.text"));
        this.pnlKnownVelocity.add((Component)lblLength1, "");
        this.txtLength1 = new JTextField();
        this.txtLength1.setFocusable(false);
        this.txtLength1.setFocusTraversalKeysEnabled(false);
        this.pnlKnownVelocity.add((Component)this.txtLength1, "");
        this.txtLength1.setHorizontalAlignment(4);
        this.txtLength1.setEditable(false);
        this.txtLength1.setColumns(6);
        this.pnlKnownCableLength = new JPanel();
        this.getContentPane().add((Component)this.pnlKnownCableLength, "wrap");
        this.pnlKnownCableLength.setBorder(new TitledBorder(null, VNAMessages.getString("VNACableLengthDialog.rdbtnKnownCableLength.text"), 4, 2, null, null));
        this.pnlKnownCableLength.setLayout((LayoutManager)new MigLayout("", "[][][][grow,fill]", "[]"));
        JLabel lblLength2 = new JLabel(VNAMessages.getString("VNACableLengthDialog.lblKnownLength.text"));
        this.pnlKnownCableLength.add((Component)lblLength2, "");
        this.txtLength2 = new JTextField();
        this.txtLength2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String t = VNACableLengthDialog.this.txtLength2.getText();
                    if (t != null && t.length() > 0) {
                        double clen = VNAFormatFactory.getLengthFormat().parse(VNACableLengthDialog.this.txtLength2.getText()).doubleValue();
                        VNACableLengthDialog.this.txtLength2.setText(VNAFormatFactory.getLengthFormat().format(clen));
                    }
                }
                catch (ParseException e1) {
                    String m = MessageFormat.format(VNAMessages.getString("VNACableLengthDialog.Err.1"), VNACableLengthDialog.this.txtLength2.getText());
                    JOptionPane.showMessageDialog(VNACableLengthDialog.this.mainFrame.getJFrame(), m, VNAMessages.getString("VNACableLengthDialog.Err.2"), 0);
                }
            }
        });
        this.txtLength2.setHorizontalAlignment(4);
        this.pnlKnownCableLength.add((Component)this.txtLength2, "");
        this.txtLength2.setColumns(6);
        JLabel lblVelocityFactor2 = new JLabel(VNAMessages.getString("VNACableLengthDialog.lblVelocityFactor.text"));
        this.pnlKnownCableLength.add((Component)lblVelocityFactor2, "");
        this.txtVelocityFactor2 = new JTextField();
        this.txtVelocityFactor2.setFocusable(false);
        this.txtVelocityFactor2.setFocusTraversalKeysEnabled(false);
        this.txtVelocityFactor2.setHorizontalAlignment(4);
        this.txtVelocityFactor2.setEditable(false);
        this.txtVelocityFactor2.setColumns(6);
        this.pnlKnownCableLength.add((Component)this.txtVelocityFactor2, "");
        this.pnlVariableVelocity = new JPanel();
        this.getContentPane().add((Component)this.pnlVariableVelocity, "wrap");
        this.pnlVariableVelocity.setLayout((LayoutManager)new MigLayout("", "[][][][grow,fill]", "[]"));
        this.pnlVariableVelocity.setBorder(new TitledBorder(null, VNAMessages.getString("VNACableLengthDialog.rdbtnVariableVelocityFactor.text"), 4, 2, null, null));
        this.lblVelocityFactor3 = new JLabel(VNAMessages.getString("VNACableLengthDialog.lblVelocityFactor.text"));
        this.pnlVariableVelocity.add((Component)this.lblVelocityFactor3, "");
        this.txtVelocityFactor3 = new JTextField();
        this.txtVelocityFactor3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String t = VNACableLengthDialog.this.txtVelocityFactor3.getText();
                    if (t != null && t.length() > 0) {
                        double clen = VNAFormatFactory.getVelocityFormat().parse(VNACableLengthDialog.this.txtVelocityFactor3.getText()).doubleValue();
                        VNACableLengthDialog.this.txtVelocityFactor3.setText(VNAFormatFactory.getVelocityFormat().format(clen));
                    }
                }
                catch (ParseException e1) {
                    String m = MessageFormat.format(VNAMessages.getString("VNACableLengthDialog.Err.1"), VNACableLengthDialog.this.txtVelocityFactor3.getText());
                    JOptionPane.showMessageDialog(VNACableLengthDialog.this.mainFrame.getJFrame(), m, VNAMessages.getString("VNACableLengthDialog.Err.2"), 0);
                }
            }
        });
        this.txtVelocityFactor3.setHorizontalAlignment(4);
        this.txtVelocityFactor3.setColumns(6);
        this.pnlVariableVelocity.add((Component)this.txtVelocityFactor3, "");
        this.lblLength3 = new JLabel(VNAMessages.getString("VNACableLengthDialog.lblLength.text"));
        this.pnlVariableVelocity.add((Component)this.lblLength3, "");
        this.txtLength3 = new JTextField();
        this.txtLength3.setFocusTraversalKeysEnabled(false);
        this.txtLength3.setFocusable(false);
        this.txtLength3.setHorizontalAlignment(4);
        this.txtLength3.setEditable(false);
        this.txtLength3.setColumns(6);
        this.pnlVariableVelocity.add((Component)this.txtLength3, "");
        ButtonGroup bg = new ButtonGroup();
        this.pnlButtons = new JPanel();
        this.getContentPane().add((Component)this.pnlButtons, "wrap");
        this.pnlButtons.setLayout((LayoutManager)new MigLayout("", "[grow,fill][grow][grow][grow][grow,fill]", "[]"));
        this.btMeasure = new JButton(VNAMessages.getString("VNACableLengthDialog.btMeasure.text"));
        this.pnlButtons.add((Component)this.btMeasure, "cell 0 0,alignx left,aligny center");
        this.btMeasure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNACableLengthDialog.this.doMeasure();
            }
        });
        this.lblUnit = new JLabel(VNAMessages.getString("VNACableLengthDialog.lblUnit.text"));
        this.pnlButtons.add((Component)this.lblUnit, "");
        this.rdbtnM = new JRadioButton(VNAMessages.getString("VNACableLengthDialog.rdbtnM.text"));
        this.rdbtnM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        this.pnlButtons.add((Component)this.rdbtnM, "");
        bg.add(this.rdbtnM);
        this.rdbtnFeet = new JRadioButton(VNAMessages.getString("VNACableLengthDialog.rdbtnFeet.text"));
        this.rdbtnFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        this.pnlButtons.add((Component)this.rdbtnFeet, "");
        bg.add(this.rdbtnFeet);
        this.btOK = new JButton(VNAMessages.getString("Button.Close"));
        this.pnlButtons.add((Component)this.btOK, "");
        this.btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNACableLengthDialog.this.doCANCEL();
            }
        });
        this.statusBar = new StatusBar();
        this.getContentPane().add((Component)this.statusBar, "wrap");
        JLabel lbl = new JLabel(VNAMessages.getString("Message.Ready"));
        lbl.setOpaque(true);
        this.statusBar.addZone("status", lbl, "*");
        this.doInit();
    }

    private void initiateScan() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        VNABackgroundJob job = new VNABackgroundJob();
        job.setNumberOfSamples(1000);
        job.setFrequencyRange(new VNAFrequencyRange(this.startFreq, this.stopFreq));
        job.setScanMode(VNAScanMode.MODE_REFLECTION);
        job.setSpeedup(1);
        VnaBackgroundTask backgroundTask = new VnaBackgroundTask(this.datapool.getDriver());
        backgroundTask.addJob(job);
        backgroundTask.setStatusLabel((JLabel)this.statusBar.getZone("status"));
        backgroundTask.addDataConsumer(this);
        backgroundTask.execute();
    }

    protected void doMeasure() {
        this.btMeasure.setEnabled(false);
        this.btOK.setEnabled(false);
        this.startFreq = this.datapool.getMainCalibrationBlock().getStartFrequency();
        this.stopFreq = this.datapool.getMainCalibrationBlock().getStopFrequency();
        this.numIterations = 1;
        this.initiateScan();
    }

    @Override
    public void consumeDataBlock(List<VNABackgroundJob> jobs) {
        TraceHelper.entry(this, "consumeDataBlock");
        boolean enableButtons = true;
        if (jobs.size() == 1) {
            VNASampleBlock rawData = jobs.get(0).getResult();
            if (rawData != null) {
                IVNADriverMathHelper mathHelper = rawData.getMathHelper();
                if (mathHelper != null) {
                    VNACalibrationBlock mainCalibrationBlock = this.datapool.getMainCalibrationBlock();
                    if (mainCalibrationBlock != null) {
                        VNACalibrationBlock resizedCalibrationBlock = VNACalibrationBlockHelper.createResizedCalibrationBlock(mainCalibrationBlock, this.startFreq, this.stopFreq, rawData.getNumberOfSteps());
                        if (rawData.getScanMode().isReflectionMode()) {
                            VNACalibrationContext context = mathHelper.createCalibrationContextForCalibratedSamples(resizedCalibrationBlock);
                            context.setConversionTemperature(rawData.getDeviceTemperature());
                            this.samples = mathHelper.createCalibratedSamples(context, rawData);
                            VNACableMeasurementHelper helper = new VNACableMeasurementHelper(this.dib.getMinPhase() < 0.0, this.rdbtnM.isSelected());
                            List<VNACalibratedSample> allPoints = helper.findAllCrossingPoints(this.samples);
                            for (VNACalibratedSample aSample : allPoints) {
                                TraceHelper.text(this, "consumeDataBlock", "crossingPoint f=" + aSample.getFrequency() + " rl=" + aSample.getReflectionLoss());
                            }
                            List<VNACalibratedSample> points = helper.findTwoCrossingPoints(this.samples);
                            if (points.size() == 2) {
                                TraceHelper.text(this, "consumeDataBlock", "Point1=" + points.get(0).getFrequency());
                                TraceHelper.text(this, "consumeDataBlock", "Point2=" + points.get(1).getFrequency());
                                if (this.numIterations > 0) {
                                    this.startFreq = (long)((double)points.get(0).getFrequency() * 0.9);
                                    this.startFreq = Math.max(this.startFreq, this.dib.getMinFrequency());
                                    this.stopFreq = (long)((double)points.get(1).getFrequency() * 1.1);
                                    this.stopFreq = Math.min(this.stopFreq, this.dib.getMaxFrequency());
                                    --this.numIterations;
                                    this.initiateScan();
                                    enableButtons = false;
                                } else {
                                    this.updateFields(points, helper);
                                }
                            } else {
                                this.clearFields();
                            }
                        } else {
                            this.clearFields();
                        }
                    } else {
                        this.clearFields();
                    }
                } else {
                    this.clearFields();
                }
            } else {
                this.clearFields();
            }
        } else {
            this.clearFields();
        }
        if (enableButtons) {
            this.btMeasure.setEnabled(true);
            this.btOK.setEnabled(true);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        TraceHelper.exit(this, "consumeDataBlock");
    }

    private void clearFields() {
        this.txtLength1.setText("???");
        this.txtVelocityFactor2.setText("???");
        this.txtLength3.setText("???");
    }

    private void updateFields(List<VNACalibratedSample> points, VNACableMeasurementHelper helper) {
        TraceHelper.entry(this, "updateFields");
        double velocityEntered = this.tblVelocity.getSelectedItem().getVf();
        VNACableMeasurementPoint result = helper.calculateLength(points, velocityEntered);
        this.txtLength1.setBackground(Color.BLACK);
        this.txtLength1.setForeground(Color.YELLOW);
        this.txtLength1.setText(String.valueOf(VNAFormatFactory.getLengthFormat().format(result.getLength())) + (this.rdbtnM.isSelected() ? " m" : " ft"));
        try {
            double clen = VNAFormatFactory.getLengthFormat().parse(this.txtLength2.getText()).doubleValue();
            result = helper.calculateVelocityFactor(points, clen);
            this.txtVelocityFactor2.setBackground(Color.BLACK);
            this.txtVelocityFactor2.setForeground(Color.YELLOW);
            this.txtVelocityFactor2.setText(VNAFormatFactory.getVelocityFormat().format(result.getVelocityFactor()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            velocityEntered = VNAFormatFactory.getVelocityFormat().parse(this.txtVelocityFactor3.getText()).doubleValue();
            result = helper.calculateLength(points, velocityEntered);
            this.txtLength3.setBackground(Color.BLACK);
            this.txtLength3.setForeground(Color.YELLOW);
            this.txtLength3.setText(String.valueOf(VNAFormatFactory.getLengthFormat().format(result.getLength())) + (this.rdbtnM.isSelected() ? " m" : " ft"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        TraceHelper.exit(this, "updateFields");
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.config.putInteger(String.valueOf(this.getConfigurationPrefix()) + ".selIdx", this.tblVelocity.getSelectedRow());
        this.config.put(String.valueOf(this.getConfigurationPrefix()) + ".userLength", this.txtLength2.getText());
        this.config.put(String.valueOf(this.getConfigurationPrefix()) + ".userVelFactor", this.txtVelocityFactor3.getText());
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        int selIdx = this.config.getInteger(String.valueOf(this.getConfigurationPrefix()) + ".selIdx", 0);
        this.tblVelocity.selectRow(selIdx);
        this.txtLength2.setText(this.config.getProperty(String.valueOf(this.getConfigurationPrefix()) + ".userLength", ""));
        this.txtVelocityFactor3.setText(this.config.getProperty(String.valueOf(this.getConfigurationPrefix()) + ".userVelFactor", ""));
        this.rdbtnM.setSelected(true);
        this.addEscapeKey();
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }
}

