/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.beacon;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.device.IVNADriver;
import krause.vna.firmware.IVNABackgroundFlashBurnerConsumer;
import krause.vna.firmware.SimpleStringListbox;
import krause.vna.firmware.StringMessenger;
import krause.vna.gui.format.VNAFormatFactory;
import org.jdesktop.swingworker.SwingWorker;

public class VnaBackgroundBeacon
extends SwingWorker<Integer, String>
implements StringMessenger {
    private IVNABackgroundFlashBurnerConsumer consumer = null;
    private SimpleStringListbox listbox = null;
    private IVNADriver driver = null;
    private long frequency = 10000000L;
    private int pause = 1;
    private int bpm = 60;
    private String message;
    private HashMap<Character, String> morseCodes = new HashMap();

    public VnaBackgroundBeacon() {
        this.morseCodes.put(Character.valueOf('A'), "01");
        this.morseCodes.put(Character.valueOf('B'), "1000");
        this.morseCodes.put(Character.valueOf('C'), "1010");
        this.morseCodes.put(Character.valueOf('D'), "100");
        this.morseCodes.put(Character.valueOf('E'), "0");
        this.morseCodes.put(Character.valueOf('F'), "0010");
        this.morseCodes.put(Character.valueOf('G'), "110");
        this.morseCodes.put(Character.valueOf('H'), "0000");
        this.morseCodes.put(Character.valueOf('I'), "00");
        this.morseCodes.put(Character.valueOf('J'), "0111");
        this.morseCodes.put(Character.valueOf('K'), "101");
        this.morseCodes.put(Character.valueOf('L'), "0100");
        this.morseCodes.put(Character.valueOf('M'), "11");
        this.morseCodes.put(Character.valueOf('N'), "10");
        this.morseCodes.put(Character.valueOf('O'), "111");
        this.morseCodes.put(Character.valueOf('P'), "0110");
        this.morseCodes.put(Character.valueOf('Q'), "1101");
        this.morseCodes.put(Character.valueOf('R'), "010");
        this.morseCodes.put(Character.valueOf('S'), "000");
        this.morseCodes.put(Character.valueOf('T'), "1");
        this.morseCodes.put(Character.valueOf('U'), "001");
        this.morseCodes.put(Character.valueOf('V'), "0001");
        this.morseCodes.put(Character.valueOf('W'), "011");
        this.morseCodes.put(Character.valueOf('X'), "1001");
        this.morseCodes.put(Character.valueOf('Y'), "1011");
        this.morseCodes.put(Character.valueOf('Z'), "1100");
        this.morseCodes.put(Character.valueOf('1'), "01111");
        this.morseCodes.put(Character.valueOf('2'), "00111");
        this.morseCodes.put(Character.valueOf('3'), "00011");
        this.morseCodes.put(Character.valueOf('4'), "00001");
        this.morseCodes.put(Character.valueOf('5'), "00000");
        this.morseCodes.put(Character.valueOf('6'), "10000");
        this.morseCodes.put(Character.valueOf('7'), "11000");
        this.morseCodes.put(Character.valueOf('8'), "11100");
        this.morseCodes.put(Character.valueOf('9'), "11110");
        this.morseCodes.put(Character.valueOf('0'), "11111");
        this.morseCodes.put(Character.valueOf('/'), "10010");
        this.morseCodes.put(Character.valueOf('#'), "000101");
        this.morseCodes.put(Character.valueOf('+'), "01010");
        this.morseCodes.put(Character.valueOf('.'), "010101");
        this.morseCodes.put(Character.valueOf(','), "110011");
        this.morseCodes.put(Character.valueOf('-'), "100001");
        this.morseCodes.put(Character.valueOf('?'), "001100");
        this.morseCodes.put(Character.valueOf('!'), "101011");
        this.morseCodes.put(Character.valueOf('='), "10001");
        this.morseCodes.put(Character.valueOf(':'), "111000");
    }

    public void setDataConsumer(IVNABackgroundFlashBurnerConsumer pConsumer) {
        TraceHelper.entry(this, "setDataConsumer");
        this.consumer = pConsumer;
        TraceHelper.exit(this, "setDataConsumer");
    }

    @Override
    public void publishMessage(String message) {
        this.publish(message);
    }

    @Override
    public Integer doInBackground() {
        int rc = 0;
        TraceHelper.entry(this, "doInBackground");
        try {
            this.publish("Starting beacon mode ...");
            while (!this.isCancelled()) {
                this.sendMorse();
                Thread.sleep(this.pause * 1000);
            }
        }
        catch (Exception e) {
            ErrorLogHelper.exception(this, "doInBackground", e);
            this.publish(e.getMessage());
            rc = 1;
        }
        TraceHelper.exit(this, "doInBackground");
        return rc;
    }

    private void sendMorse() {
        TraceHelper.entry(this, "sendMorse");
        this.publish(String.valueOf(VNAFormatFactory.getDateTimeFormat().format(new Date())) + "-" + this.message);
        int i = 0;
        while (i < this.message.length()) {
            if (this.isCancelled()) break;
            char c = this.message.charAt(i);
            this.sendChar(c);
            ++i;
        }
        TraceHelper.exit(this, "sendMorse");
    }

    private void sendChar(char c) {
        int dit = (int)(50.0 / (double)this.bpm * 100.0);
        TraceHelper.text(this, "sendChar", "" + dit);
        try {
            if (c == ' ') {
                Thread.sleep(4 * dit);
            } else {
                String code = this.morseCodes.get(Character.valueOf(Character.toUpperCase(c)));
                if (code != null) {
                    int i = 0;
                    while (i < code.length()) {
                        this.driver.startGenerator(this.frequency, this.frequency, 0, 0, 0, 0);
                        if (code.charAt(i) == '1') {
                            Thread.sleep(4 * dit);
                        } else {
                            Thread.sleep(dit);
                        }
                        this.driver.stopGenerator();
                        Thread.sleep(dit);
                        ++i;
                    }
                }
            }
            Thread.sleep(3 * dit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void process(List<String> messages) {
        TraceHelper.entry(this, "process");
        if (this.listbox != null) {
            for (String message : messages) {
                this.listbox.addMessage(message);
            }
        }
        TraceHelper.exit(this, "process");
    }

    @Override
    protected void done() {
        TraceHelper.entry(this, "done");
        this.consumer.consumeReturnCode(0);
        TraceHelper.exit(this, "done");
    }

    public void setListbox(SimpleStringListbox listbox) {
        this.listbox = listbox;
    }

    public void setDriver(IVNADriver driver) {
        this.driver = driver;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    public void setPause(int pause) {
        this.pause = pause;
    }

    public void setBpm(int bpm) {
        this.bpm = bpm;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

