/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.TraceHelper;
import krause.vna.export.JFSeries;
import krause.vna.gui.util.SwingUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class VNATemperatureDetailsDialog
extends KrauseDialog {
    private static final float STROKE_WIDTH = 1.0f;
    private final Font LABEL_FONT = new Font("SansSerif", 0, 10);
    private final Font TICK_FONT = new Font("SansSerif", 0, 10);
    private JFreeChart chart;
    private ChartPanel lblImage;
    private JButton btCancel;

    public VNATemperatureDetailsDialog(Window pMainFrame, double[] tempList) {
        super(pMainFrame, true);
        TraceHelper.entry(this, "VNATemperatureDetailsDialog.java");
        this.chart = this.createChart(tempList);
        this.setTitle("Device temperature history");
        this.setDefaultCloseOperation(0);
        this.setBounds(100, 100, 689, 602);
        this.getContentPane().setLayout(new BorderLayout());
        this.lblImage = new ChartPanel(this.chart, true);
        this.getContentPane().add((Component)this.lblImage, "Center");
        this.lblImage.setBorder((Border)new TitledBorder(null, "", 4, 2, null, null));
        this.lblImage.setIgnoreRepaint(true);
        this.lblImage.setPreferredSize(new Dimension(640, 480));
        this.lblImage.setLayout((LayoutManager)new FlowLayout(1, 5, 5));
        JPanel buttonPane = new JPanel();
        this.getContentPane().add((Component)buttonPane, "South");
        buttonPane.setLayout(new BorderLayout(0, 0));
        this.btCancel = SwingUtil.createJButton("Button.OK", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNATemperatureDetailsDialog.this.setVisible(false);
            }
        });
        buttonPane.add((Component)this.btCancel, "East");
        this.btCancel.setActionCommand("Cancel");
        this.getRootPane().setDefaultButton(this.btCancel);
        this.doInit();
        TraceHelper.exit(this, "VNATemperatureDetailsDialog.java");
    }

    private JFreeChart createChart(double[] tempList) {
        TraceHelper.entry(this, "createChart");
        JFreeChart rcChart = null;
        JFSeries series1 = new JFSeries();
        XYSeries xySeries1 = new XYSeries((Comparable)((Object)"Temperature \u00b0C"));
        int i = 0;
        double[] dArray = tempList;
        int n = tempList.length;
        int n2 = 0;
        while (n2 < n) {
            double data = dArray[n2];
            xySeries1.add((double)i++, data);
            ++n2;
        }
        series1.setSeries(xySeries1);
        rcChart = ChartFactory.createXYLineChart((String)"Temperature", (String)"Samples", null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = rcChart.getXYPlot();
        NumberAxis rangeAxis1 = new NumberAxis(series1.getDataset().getSeries(0).getKey().toString());
        rangeAxis1.setLabelFont(this.LABEL_FONT);
        rangeAxis1.setTickLabelFont(this.TICK_FONT);
        rangeAxis1.setAutoRange(false);
        rangeAxis1.setRange(xySeries1.getMinY() - 5.0, xySeries1.getMaxY() + 5.0);
        plot.setRangeAxis(0, (ValueAxis)rangeAxis1);
        plot.setDataset(0, (XYDataset)series1.getDataset());
        plot.mapDatasetToRangeAxis(0, 0);
        rcChart.setBackgroundPaint((Paint)Color.white);
        plot = rcChart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.darkGray);
        plot.setRangeGridlinePaint((Paint)Color.darkGray);
        plot.setRenderer(0, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
        plot.getRenderer(0).setSeriesPaint(0, (Paint)Color.RED);
        plot.getRenderer(0).setSeriesStroke(0, (Stroke)new BasicStroke(1.0f));
        plot.getDomainAxis().setLabelFont(this.LABEL_FONT);
        plot.getDomainAxis().setTickLabelFont(this.TICK_FONT);
        TraceHelper.exit(this, "createChart");
        return rcChart;
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doExit");
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doExit");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.lblImage.setChart(this.chart);
        this.addEscapeKey();
        this.showCentered(this.getWidth(), this.getHeight());
        TraceHelper.exit(this, "doInit");
    }
}

