/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import krause.util.ResourceLoader;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.VNATemperatureDetailsDialog;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;

public class VNATemperatureButton
extends JButton
implements ActionListener {
    private ImageIcon iconEmpty;
    private ImageIcon iconRed;
    private ImageIcon iconBlue;
    private ImageIcon iconGreen;
    private double marginBlueGreen;
    private double marginGreenRed;
    private VNAMainFrame mainFrame;
    private static final int MAX_LIST = 1000;
    private double[] tempList = new double[1000];
    private boolean firstTemp = true;

    private ImageIcon readIconFromResource(String resName, String altText) {
        try {
            byte[] iconBytes = ResourceLoader.getResourceAsByteArray(resName);
            return new ImageIcon(iconBytes, altText);
        }
        catch (IOException ex) {
            ErrorLogHelper.exception(SwingUtil.class, "readIconFromResource", ex);
            return new ImageIcon();
        }
        catch (NullPointerException ex) {
            ErrorLogHelper.exception(SwingUtil.class, "readIconFromResource", ex);
            return new ImageIcon();
        }
    }

    public VNATemperatureButton(VNAMainFrame pMainFrame, String pResPrefix, ActionListener pListener, double pMarginBlueGreen, double pMarginGreenRed) {
        this.mainFrame = pMainFrame;
        this.marginBlueGreen = pMarginBlueGreen;
        this.marginGreenRed = pMarginGreenRed;
        String command = VNAMessages.getString(String.valueOf(pResPrefix) + ".Command");
        String tooltip = VNAMessages.getString(String.valueOf(pResPrefix) + ".Tooltip");
        this.setActionCommand(command);
        this.setToolTipText(tooltip);
        if (pListener != null) {
            this.addActionListener(pListener);
        }
        this.addActionListener(this);
        this.iconEmpty = this.readIconFromResource(VNAMessages.getString(String.valueOf(pResPrefix) + ".Image.Empty"), "Empty");
        this.iconRed = this.readIconFromResource(VNAMessages.getString(String.valueOf(pResPrefix) + ".Image.Red"), "Red");
        this.iconGreen = this.readIconFromResource(VNAMessages.getString(String.valueOf(pResPrefix) + ".Image.Green"), "Green");
        this.iconBlue = this.readIconFromResource(VNAMessages.getString(String.valueOf(pResPrefix) + ".Image.Blue"), "Blue");
        int i = 0;
        while (i < 1000) {
            this.tempList[i] = 0.0;
            ++i;
        }
        this.setTemperature(null);
    }

    public void setTemperature(Double temp) {
        TraceHelper.entry(this, "setTemperature");
        if (temp != null) {
            this.setToolTipText(String.valueOf(VNAFormatFactory.getTemperatureFormat().format(temp)) + "\u00b0C");
            if (temp > this.marginGreenRed) {
                this.setIcon(this.iconRed);
            } else if (temp > this.marginBlueGreen) {
                this.setIcon(this.iconGreen);
            } else {
                this.setIcon(this.iconBlue);
            }
            if (this.firstTemp) {
                int i = 0;
                while (i < 1000) {
                    this.tempList[i] = temp;
                    ++i;
                }
                this.firstTemp = false;
            } else {
                int i = 1;
                while (i < 1000) {
                    this.tempList[i - 1] = this.tempList[i];
                    ++i;
                }
                this.tempList[999] = temp;
            }
        } else {
            this.setIcon(this.iconEmpty);
            this.setToolTipText("");
        }
        TraceHelper.exit(this, "setTemperature");
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        new VNATemperatureDetailsDialog((Window)this.mainFrame.getJFrame(), this.tempList);
    }
}

