/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui;

import com.apple.eawt.AppEventListener;
import com.apple.eawt.Application;
import com.l2fprod.common.swing.StatusBar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import krause.common.exception.ProcessingException;
import krause.util.PropertiesHelper;
import krause.util.ResourceLoader;
import krause.util.ras.logging.ApplicationLogHelper;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNAApplicationState;
import krause.vna.data.VNADataPool;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.helper.VNACalibrationBlockHelper;
import krause.vna.device.IVNADriver;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.device.VNADriverFactory;
import krause.vna.gui.OptionDialogHelper;
import krause.vna.gui.StatusBarLabel;
import krause.vna.gui.VNAMenuAndToolbarHandler;
import krause.vna.gui.mac.MacApplicationHandler;
import krause.vna.gui.menu.VNAMenuBar;
import krause.vna.gui.panels.VNADiagramPanel;
import krause.vna.gui.panels.data.VNADataPanel;
import krause.vna.gui.panels.marker.VNAMarkerPanel;
import krause.vna.gui.toolbar.VNAToolbar;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;

public class VNAMainFrame
implements ClipboardOwner,
AppEventListener {
    private VNAConfig config = VNAConfig.getSingleton();
    private VNADataPool datapool = VNADataPool.getSingleton();
    private VNAApplicationState applicationState = new VNAApplicationState(this);
    private VNADataPanel dataPanel = null;
    private JFrame mainFrame = null;
    private VNAMenuAndToolbarHandler menuAndToolbarHandler = null;
    private VNADiagramPanel diagramPanel = null;
    private VNAMarkerPanel markerPanel = null;
    private StatusBar statusBar = null;
    private VNAToolbar toolbar;
    private VNAMenuBar menubar;
    private MacApplicationHandler macAppHandler;
    static final int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    protected VNAMainFrame() throws ProcessingException {
        ApplicationLogHelper.text(this, "VNAMainFrame", "Setting up instance...");
        this.createAndShowGUI();
        this.applicationState.evtGUIInitialzed();
        ApplicationLogHelper.text(this, "VNAMainFrame", "Instance setup done!");
    }

    private void addHotKey(String key, Action action) {
        JRootPane rp = this.getJFrame().getRootPane();
        InputMap inputMap = rp.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(key), key);
        rp.getActionMap().put(key, action);
    }

    private void addHotKeys() {
        TraceHelper.entry(this, "addHotKeys");
        this.addHotKey("F2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAMainFrame.this.getDataPanel().getTxtStartFreq().requestFocus();
            }
        });
        this.addHotKey("F3", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAMainFrame.this.getDataPanel().getTxtStopFreq().requestFocus();
            }
        });
        this.addHotKey("F4", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAMainFrame.this.getDataPanel().getCbMode().requestFocus();
            }
        });
        TraceHelper.exit(this, "addHotKeys");
    }

    public void changedMode() {
        TraceHelper.entry(this, "changedMode");
        if (this.datapool.getScanMode() != null) {
            this.datapool.setMainCalibrationBlock(this.datapool.getMainCalibrationBlockForMode(this.datapool.getScanMode()));
            if (this.datapool.getMainCalibrationBlock() == null) {
                JOptionPane.showMessageDialog(this.getJFrame(), VNAMessages.getString("Message.ModeChange.1"), VNAMessages.getString("Message.ModeChange.2"), 1);
                this.applicationState.evtCalibrationUnloaded();
            } else {
                this.datapool.clearResizedCalibrationBlock();
                this.applicationState.evtCalibrationLoaded();
            }
        }
        TraceHelper.exit(this, "changedMode");
    }

    private void createAndShowGUI() throws ProcessingException {
        this.menuAndToolbarHandler = new VNAMenuAndToolbarHandler(this);
        this.createGUIComponents();
        this.addHotKeys();
        this.getJFrame().pack();
        this.config.restoreWindowPosition("MainWindow", this.getJFrame(), new Point(10, 10));
        this.config.restoreWindowSize("MainWindow", this.getJFrame(), new Dimension(1000, 600));
        this.getJFrame().setVisible(true);
        this.getStatusBarStatus().setText(MessageFormat.format(VNAMessages.getString("Application.welcome"), VNAMessages.getString("Application.version"), VNAMessages.getString("Application.date"), VNAMessages.getString("Application.copyright")));
    }

    private VNADataPanel createDataPanel() {
        TraceHelper.entry(this, "createDataPanel");
        VNADataPanel rc = new VNADataPanel(this);
        rc.load();
        this.applicationState.addStateListener(rc);
        TraceHelper.exit(this, "createDataPanel");
        return rc;
    }

    private VNADiagramPanel createDiagramPanel() {
        TraceHelper.entry(this, "createDiagramPanel");
        VNADiagramPanel rc = new VNADiagramPanel(this);
        this.applicationState.addStateListener(rc);
        TraceHelper.exit(this, "createDiagramPanel");
        return rc;
    }

    private void createGUIComponents() {
        TraceHelper.entry(this, "createGUIComponents");
        String title = MessageFormat.format(VNAMessages.getString("Application.header"), VNAMessages.getString("Application.version"));
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VNAMainFrame.this.doShutdown();
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }
        });
        if (this.config.isMac()) {
            this.macAppHandler = new MacApplicationHandler(this);
            try {
                Class<?> util = Class.forName("com.apple.eawt.FullScreenUtilities");
                Class[] params = new Class[]{Window.class, Boolean.TYPE};
                Method method = util.getMethod("setWindowCanFullScreen", params);
                method.invoke(util, frame, true);
            }
            catch (ClassNotFoundException util) {
            }
            catch (Exception e) {
                ErrorLogHelper.exception(this, "createGUIComponents", e);
            }
        }
        frame.setResizable(true);
        try {
            byte[] iconBytes = ResourceLoader.getResourceAsByteArray("images/logo.gif");
            Image img = Toolkit.getDefaultToolkit().createImage(iconBytes);
            frame.setIconImage(img);
            if (this.config.isMac()) {
                Application.getApplication().setDockIconImage(img);
            }
        }
        catch (Exception ex) {
            ErrorLogHelper.exception(SwingUtil.class, "createAndShowGUI", ex);
        }
        this.setJFrame(frame);
        if (this.config.isMac()) {
            frame.setLayout((LayoutManager)new MigLayout("", "[grow,fill][300px]", "[][grow,fill][][]"));
        } else {
            frame.setLayout((LayoutManager)new MigLayout("", "[grow,fill][250px]", "[][grow,fill][][]"));
        }
        this.toolbar = new VNAToolbar(this.menuAndToolbarHandler);
        this.applicationState.addStateListener(this.toolbar);
        frame.add((Component)this.toolbar, "span 2,wrap,grow");
        this.diagramPanel = this.createDiagramPanel();
        this.dataPanel = this.createDataPanel();
        this.markerPanel = this.createMarkerPanel();
        this.statusBar = this.createStatusPanel();
        this.menubar = new VNAMenuBar(this.menuAndToolbarHandler, this.getStatusBarStatus());
        frame.setJMenuBar(this.menubar);
        this.applicationState.addStateListener(this.menubar);
        frame.add((Component)this.diagramPanel, "");
        frame.add((Component)this.dataPanel, "span 1 2,top,wrap,growy");
        frame.add((Component)this.markerPanel, "wrap");
        frame.add((Component)this.statusBar, "span 2,grow");
        TraceHelper.exit(this, "createGUIComponents");
    }

    private VNAMarkerPanel createMarkerPanel() {
        TraceHelper.entry(this, "createMarkerPanel");
        VNAMarkerPanel rc = new VNAMarkerPanel(this);
        this.applicationState.addStateListener(rc);
        rc.setVisible(true);
        TraceHelper.exit(this, "createMarkerPanel");
        return rc;
    }

    private StatusBar createStatusPanel() {
        StatusBar rc = new StatusBar();
        rc.addZone("status", new StatusBarLabel(VNAMessages.getString("Message.Ready"), 50), "40%");
        rc.addZone("driver", new StatusBarLabel("???", 20), "15%");
        rc.addZone("calibStatus", new StatusBarLabel("???", 20), "8%");
        rc.addZone("calibFile", new StatusBarLabel("???", 40), "*");
        return rc;
    }

    public void doShutdown() {
        TraceHelper.entry(this, "doShutdown");
        this.config.storeWindowPosition("MainWindow", this.getJFrame());
        this.config.storeWindowSize("MainWindow", this.getJFrame());
        if (this.config.isAskOnExit()) {
            Object[] options = new Object[]{VNAMessages.getString("Button.Terminate"), VNAMessages.getString("Button.Cancel")};
            int n = JOptionPane.showOptionDialog(this.getJFrame(), VNAMessages.getString("Message.Exit.1"), VNAMessages.getString("Message.Exit.2"), 0, 3, null, options, options[0]);
            if (n != 0) {
                return;
            }
        }
        this.getDataPanel().save();
        this.datapool.save(this.config);
        this.config.save();
        if (this.datapool.getDriver() != null) {
            this.datapool.getDriver().destroy();
        }
        TraceHelper.exit(this, "doShutdown");
        System.exit(0);
    }

    public VNAApplicationState getApplicationState() {
        return this.applicationState;
    }

    public VNADataPanel getDataPanel() {
        return this.dataPanel;
    }

    public VNADiagramPanel getDiagramPanel() {
        return this.diagramPanel;
    }

    public JFrame getJFrame() {
        return this.mainFrame;
    }

    public VNAMarkerPanel getMarkerPanel() {
        return this.markerPanel;
    }

    public VNAMenuAndToolbarHandler getMenuAndToolbarHandler() {
        return this.menuAndToolbarHandler;
    }

    public VNAMenuBar getMenubar() {
        return this.menubar;
    }

    public JLabel getStatusBarCalibrationFilename() {
        return (JLabel)this.statusBar.getZone("calibFile");
    }

    public JLabel getStatusBarCalibrationStatus() {
        return (JLabel)this.statusBar.getZone("calibStatus");
    }

    public JLabel getStatusBarDriverType() {
        return (JLabel)this.statusBar.getZone("driver");
    }

    public JLabel getStatusBarStatus() {
        return (JLabel)this.statusBar.getZone("status");
    }

    public VNAToolbar getToolbar() {
        return this.toolbar;
    }

    public boolean loadDriver() {
        TraceHelper.entry(this, "loadDriver");
        boolean rc = false;
        try {
            IVNADriver drv = VNADriverFactory.getSingleton().getDriverForType(this.datapool.getDeviceType());
            this.datapool.setDriver(drv);
            this.datapool.setScanMode(drv.getDefaultMode());
            drv.init();
            this.applicationState.evtDriverLoaded();
            rc = true;
        }
        catch (ProcessingException e) {
            ErrorLogHelper.exception(this, "setDeviceType", e);
            OptionDialogHelper.showExceptionDialog(this.getJFrame(), "VNAMainFrame.Error.loadDriver.1", "VNAMainFrame.Error.loadDriver.2", e);
        }
        TraceHelper.exit(this, "loadDriver");
        return rc;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void preloadCalibrationBlocks() {
        String methodName = "preloadCalibrationBlocks";
        TraceHelper.entry(this, "preloadCalibrationBlocks");
        try {
            VNADeviceInfoBlock dib = this.datapool.getDriver().getDeviceInfoBlock();
            String configPath = "CalibrationBlocks." + this.datapool.getDriver().getDeviceInfoBlock().getShortName() + ".";
            Properties props = PropertiesHelper.createProperties(this.config, configPath, true);
            Enumeration<Object> enu = props.keys();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                String filename = props.getProperty(key);
                String pathname = String.valueOf(this.config.getVNACalibrationDirectory()) + "/" + filename;
                TraceHelper.text(this, "preloadCalibrationBlocks", "Try to load[" + pathname + "]");
                File file = new File(pathname);
                VNACalibrationBlock block = VNACalibrationBlockHelper.load(file, this.datapool.getDriver());
                if (!block.blockMatches(dib)) continue;
                if (dib.isPeakSuppression()) {
                    VNACalibrationBlockHelper.removeSwitchPoints(block.getCalibrationPoints(), dib.getSwitchPoints());
                }
                this.datapool.setMainCalibrationBlockForMode(block);
            }
        }
        catch (ProcessingException e) {
            ErrorLogHelper.exception(this, "preloadCalibrationBlocks", e);
        }
        TraceHelper.exit(this, "preloadCalibrationBlocks");
    }

    public void setJFrame(JFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setMainCalibrationBlock(VNACalibrationBlock pMainCalibrationBlock) {
        TraceHelper.entry(this, "setMainCalibrationBlock");
        if (this.datapool.getMainCalibrationBlock() != null) {
            this.datapool.clearResizedCalibrationBlock();
            this.applicationState.evtCalibrationUnloaded();
        }
        this.datapool.setMainCalibrationBlock(pMainCalibrationBlock);
        if (this.datapool.getMainCalibrationBlock() != null) {
            this.datapool.setMainCalibrationBlockForMode(pMainCalibrationBlock);
            this.datapool.clearResizedCalibrationBlock();
            this.storePreloadCalibrationBlocks();
            this.applicationState.evtCalibrationLoaded();
        }
        TraceHelper.exit(this, "setMainCalibrationBlock");
    }

    private void storePreloadCalibrationBlocks() {
        TraceHelper.entry(this, "storePreloadCalibrationBlocks");
        Map<String, VNACalibrationBlock> calBlocks = this.datapool.getMainCalibrationBlocks();
        String configPath = "CalibrationBlocks." + this.datapool.getDriver().getDeviceInfoBlock().getShortName() + ".";
        for (String key : calBlocks.keySet()) {
            VNACalibrationBlock block = calBlocks.get(key);
            String configKey = String.valueOf(configPath) + block.getScanMode().key();
            if (block.getFile() != null) {
                this.config.put(configKey, block.getFile().getName());
                continue;
            }
            this.config.remove(configKey);
        }
        TraceHelper.exit(this, "storePreloadCalibrationBlocks");
    }

    public void unloadDriver() {
        TraceHelper.entry(this, "unloadDriver");
        if (this.datapool.getMainCalibrationBlock() != null) {
            this.datapool.clearCalibrationBlocks();
        }
        if (this.datapool.getDriver() != null) {
            this.datapool.getDriver().destroy();
            this.datapool.setDriver(null);
        }
        this.applicationState.evtDriverUnloaded();
        TraceHelper.exit(this, "unloadDriver");
    }
}

