/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import javax.swing.JLabel;
import krause.util.ras.logging.TraceHelper;
import krause.vna.gui.HistorizedLabelDialog;
import krause.vna.gui.HistorizedLabelEntry;

public class HistorizedLabel
extends JLabel
implements MouseListener {
    private int maxHistorySize = 100;
    private LinkedList<HistorizedLabelEntry> history = null;

    public HistorizedLabel(String string) {
        super(string);
        TraceHelper.entry(this, "VNAHistorizedStatusLabel");
        this.addMouseListener(this);
        TraceHelper.exit(this, "VNAHistorizedStatusLabel");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TraceHelper.entry(this, "mouseClicked");
        new HistorizedLabelDialog(null, this.history);
        TraceHelper.exit(this, "mouseClicked");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        TraceHelper.entry(this, "mouseEntered");
        TraceHelper.exit(this, "mouseEntered");
    }

    @Override
    public void mouseExited(MouseEvent e) {
        TraceHelper.entry(this, "mouseExited");
        TraceHelper.exit(this, "mouseExited");
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TraceHelper.entry(this, "mousePressed");
        TraceHelper.exit(this, "mousePressed");
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        TraceHelper.entry(this, "mouseReleased");
        TraceHelper.exit(this, "mouseReleased");
    }

    @Override
    public void setText(String text) {
        if (text != null && (text = text.trim()).length() > 0) {
            super.setText(text);
            HistorizedLabelEntry newEntry = new HistorizedLabelEntry(text, System.currentTimeMillis());
            if (this.history == null) {
                this.history = new LinkedList();
            }
            this.history.addFirst(newEntry);
            if (this.history.size() > this.maxHistorySize) {
                this.history.removeLast();
            }
        }
    }
}

