/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui;

import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import krause.util.ResourceLoader;
import krause.util.ras.logging.ErrorLogHelper;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;

public class BatteryButton
extends JButton {
    private ImageIcon iconEmpty;
    private ImageIcon iconRed;
    private ImageIcon iconYellow;
    private ImageIcon iconGreen;

    private ImageIcon readIconFromResource(String resName, String altText) {
        try {
            byte[] iconBytes = ResourceLoader.getResourceAsByteArray(resName);
            return new ImageIcon(iconBytes, altText);
        }
        catch (IOException ex) {
            ErrorLogHelper.exception(SwingUtil.class, "readIconFromResource", ex);
            return new ImageIcon();
        }
        catch (NullPointerException ex) {
            ErrorLogHelper.exception(SwingUtil.class, "readIconFromResource", ex);
            return new ImageIcon();
        }
    }

    public BatteryButton(String pResPrefix, ActionListener pListener) {
        String command = VNAMessages.getString(String.valueOf(pResPrefix) + ".Command");
        String tooltip = VNAMessages.getString(String.valueOf(pResPrefix) + ".Tooltip");
        this.setActionCommand(command);
        this.setToolTipText(tooltip);
        if (pListener != null) {
            this.addActionListener(pListener);
        }
        this.iconEmpty = this.readIconFromResource(VNAMessages.getString(String.valueOf(pResPrefix) + ".Image.Empty"), "Empty");
        this.iconRed = this.readIconFromResource(VNAMessages.getString(String.valueOf(pResPrefix) + ".Image.Red"), "Red");
        this.iconGreen = this.readIconFromResource(VNAMessages.getString(String.valueOf(pResPrefix) + ".Image.Green"), "Green");
        this.iconYellow = this.readIconFromResource(VNAMessages.getString(String.valueOf(pResPrefix) + ".Image.Yellow"), "Yellow");
        this.setState(0);
    }

    public void setState(int pState) {
        if (pState == 1) {
            this.setIcon(this.iconGreen);
        } else if (pState == 2) {
            this.setIcon(this.iconYellow);
        } else if (pState == 3) {
            this.setIcon(this.iconRed);
        } else {
            this.setIcon(this.iconEmpty);
        }
    }
}

