/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.firmware;

import java.util.List;
import java.util.concurrent.ExecutionException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.device.IVNADriver;
import krause.vna.device.IVNAFlashableDevice;
import krause.vna.firmware.HexFileParser;
import krause.vna.firmware.IVNABackgroundFlashBurnerConsumer;
import krause.vna.firmware.IVNAFirmwareFlasher;
import krause.vna.firmware.SimpleStringListbox;
import krause.vna.firmware.StringMessenger;
import org.jdesktop.swingworker.SwingWorker;

public class VnaBackgroundFlashBurner
extends SwingWorker<Integer, String>
implements StringMessenger {
    private boolean autoReset = false;
    private IVNABackgroundFlashBurnerConsumer consumer = null;
    private IVNADriver driver = null;
    private HexFileParser hexFile = null;
    private SimpleStringListbox listbox = null;

    @Override
    public Integer doInBackground() {
        int rc = 0;
        TraceHelper.entry(this, "doInBackground");
        try {
            this.publish("Checking for matching firmware loader ... ");
            String flasherClassName = ((IVNAFlashableDevice)((Object)this.getDriver())).getFirmwareLoaderClassName();
            if (flasherClassName != null) {
                this.publish("Starting firmware download ... ");
                IVNAFirmwareFlasher burner = (IVNAFirmwareFlasher)Class.forName(flasherClassName.trim()).newInstance();
                burner.setMessenger(this);
                burner.setAutoReset(this.autoReset);
                burner.burnBuffer(this.getHexFile(), this.getDriver());
            } else {
                this.publish("Firmware flashing not supported in this configuration");
            }
        }
        catch (Exception e) {
            ErrorLogHelper.exception(this, "doInBackground", e);
            this.publish(e.getMessage());
            rc = 1;
        }
        TraceHelper.exit(this, "doInBackground");
        return rc;
    }

    @Override
    protected void done() {
        TraceHelper.entry(this, "done");
        try {
            Integer rc = (Integer)this.get();
            this.consumer.consumeReturnCode(rc);
        }
        catch (InterruptedException e) {
            ErrorLogHelper.exception(this, "done", e);
        }
        catch (ExecutionException e) {
            ErrorLogHelper.exception(this, "done", e);
        }
        TraceHelper.exit(this, "done");
    }

    public IVNADriver getDriver() {
        return this.driver;
    }

    public HexFileParser getHexFile() {
        return this.hexFile;
    }

    public SimpleStringListbox getListbox() {
        return this.listbox;
    }

    @Override
    protected void process(List<String> messages) {
        if (this.listbox != null) {
            for (String message : messages) {
                this.listbox.addMessage(message);
            }
        }
    }

    @Override
    public void publishMessage(String message) {
        this.publish(message);
    }

    public void setAutoReset(boolean selected) {
        this.autoReset = selected;
    }

    public void setDataConsumer(IVNABackgroundFlashBurnerConsumer pConsumer) {
        TraceHelper.entry(this, "setDataConsumer");
        this.consumer = pConsumer;
        TraceHelper.exit(this, "setDataConsumer");
    }

    public void setDriver(IVNADriver driver) {
        this.driver = driver;
    }

    public void setHexFile(HexFileParser hexFile) {
        this.hexFile = hexFile;
    }

    public void setListbox(SimpleStringListbox listbox) {
        this.listbox = listbox;
    }
}

