/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.firmware;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import krause.common.exception.ProcessingException;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNADataPool;
import krause.vna.device.IVNAFlashableDevice;
import krause.vna.firmware.HexFileParser;
import krause.vna.firmware.IVNABackgroundFlashBurnerConsumer;
import krause.vna.firmware.SimpleStringListbox;
import krause.vna.firmware.VnaBackgroundFlashBurner;
import krause.vna.gui.HelpButton;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;

public class VNAFirmwareUpdateDialog
extends KrauseDialog
implements ActionListener,
IVNABackgroundFlashBurnerConsumer {
    private VNAConfig config = VNAConfig.getSingleton();
    private JTextField txtFilename;
    private JButton btFlash;
    private JButton btClose;
    private JButton btSearch;
    private HexFileParser hexFileParser = null;
    private SimpleStringListbox messageList;
    private VnaBackgroundFlashBurner backgroundBurner;
    private JCheckBox cbAutoReset;
    private final IVNAFlashableDevice currentDriver = (IVNAFlashableDevice)((Object)VNADataPool.getSingleton().getDriver());
    private long startTime;

    public VNAFirmwareUpdateDialog(Frame owner) {
        super((Window)owner, true);
        TraceHelper.exit(this, "VNAFirmwareUpdateDialog");
        this.setResizable(true);
        this.setPreferredSize(new Dimension(600, 400));
        this.setDefaultCloseOperation(0);
        this.setConfigurationPrefix("VNAFirmwareUpdateDialog");
        this.setProperties(this.config);
        this.setTitle(VNAMessages.getString("VNAFirmwareUpdateDialog.title"));
        this.setLayout((LayoutManager)new MigLayout("", "[grow][][][]", ""));
        this.add((Component)new JLabel(VNAMessages.getString("VNAFirmwareUpdateDialog.filename")), "left, span 4, wrap");
        this.txtFilename = new JTextField(128);
        this.add((Component)this.txtFilename, "span 3");
        this.txtFilename.setEditable(false);
        this.btSearch = SwingUtil.createJButton("Button.Search", this);
        this.add((Component)this.btSearch, "right, wrap");
        this.messageList = new SimpleStringListbox(VNAMessages.getString("VNAFirmwareUpdateDialog.messages"));
        JScrollPane listScroller = new JScrollPane(this.messageList);
        listScroller.setPreferredSize(new Dimension(600, 800));
        this.add((Component)listScroller, "span 4, wrap");
        this.btClose = SwingUtil.createJButton("Button.Close", this);
        this.add((Component)this.btClose, "");
        this.cbAutoReset = SwingUtil.createJCheckbox("AutoReset", this);
        this.add((Component)this.cbAutoReset, "left");
        this.add((Component)new HelpButton(this, "VNAFirmwareUpdateDialog"), "");
        this.btFlash = SwingUtil.createJButton("Button.Install", this);
        this.add((Component)this.btFlash, "right,wrap");
        this.doInit();
        TraceHelper.exit(this, "VNAFirmwareUpdateDialog");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.btFlash.setEnabled(false);
        this.cbAutoReset.setEnabled(this.currentDriver.supportsAutoReset());
        this.cbAutoReset.setSelected(this.currentDriver.supportsAutoReset());
        this.addEscapeKey();
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TraceHelper.entry(this, "actionPerformed");
        String cmd = e.getActionCommand();
        if (VNAMessages.getString("Button.Close.Command").equals(cmd)) {
            this.doCANCEL();
        } else if (VNAMessages.getString("Button.Install.Command").equals(cmd)) {
            this.doFlash();
        } else if (VNAMessages.getString("Button.Search.Command").equals(cmd)) {
            this.doSearch();
        }
        TraceHelper.exit(this, "actionPerformed");
    }

    private void doFlash() {
        TraceHelper.entry(this, "doFlash");
        int rc = 0;
        rc = this.cbAutoReset.isSelected() ? JOptionPane.showConfirmDialog(this, VNAMessages.getString("VNAFirmwareUpdateDialog.warningNoReset"), VNAMessages.getString("VNAFirmwareUpdateDialog.title"), 2, 2) : (this.currentDriver.hasResetButton() ? JOptionPane.showConfirmDialog(this, VNAMessages.getString("VNAFirmwareUpdateDialog.warning"), VNAMessages.getString("VNAFirmwareUpdateDialog.title"), 2, 2) : JOptionPane.showConfirmDialog(this, VNAMessages.getString("VNAFirmwareUpdateDialog.warningNoReset"), VNAMessages.getString("VNAFirmwareUpdateDialog.title"), 2, 2));
        if (rc == 0) {
            this.btClose.setEnabled(false);
            this.btFlash.setEnabled(false);
            this.btSearch.setEnabled(false);
            this.startTime = System.currentTimeMillis();
            this.backgroundBurner = new VnaBackgroundFlashBurner();
            this.backgroundBurner.setDataConsumer(this);
            this.backgroundBurner.setListbox(this.messageList);
            this.backgroundBurner.setHexFile(this.hexFileParser);
            this.backgroundBurner.setAutoReset(this.cbAutoReset.isSelected());
            this.backgroundBurner.setDriver(VNADataPool.getSingleton().getDriver());
            this.backgroundBurner.execute();
        } else {
            this.messageList.addMessage(VNAMessages.getString("VNAFirmwareUpdateDialog.UploadCanceled"));
        }
        TraceHelper.exit(this, "doFlash");
    }

    private void doSearch() {
        TraceHelper.entry(this, "doSearch");
        FileDialog fd = new FileDialog(null, VNAMessages.getString("VNAFirmwareUpdateDialog.TitleLoad"), 0);
        File f = new File(this.config.getFlashFilename());
        fd.setFile(f.getName());
        fd.setDirectory(f.getPath());
        fd.setVisible(true);
        if (fd.getFile() != null) {
            this.messageList.clear();
            File selectedFile = new File(fd.getDirectory(), fd.getFile());
            this.config.setFlashFilename(selectedFile.getAbsolutePath());
            this.txtFilename.setText(selectedFile.getAbsolutePath());
            this.messageList.addMessage(VNAMessages.getString("VNAFirmwareUpdateDialog.TryToLoad"));
            try {
                this.hexFileParser = new HexFileParser(selectedFile);
                this.hexFileParser.parseFile();
                this.messageList.addMessage(VNAMessages.getString("VNAFirmwareUpdateDialog.FileLoaded"));
                this.messageList.addMessage("Flash start address 0x" + Integer.toHexString(this.hexFileParser.getFlashMin()));
                this.messageList.addMessage("Flash end   address 0x" + Integer.toHexString(this.hexFileParser.getFlashMax()));
                this.messageList.addMessage("Flash memory offset 0x" + Integer.toHexString(this.hexFileParser.getMemOffset()));
                this.messageList.addMessage("Flash memory size   0x" + Integer.toHexString(this.hexFileParser.getMemUsage()));
                this.btFlash.setEnabled(true);
            }
            catch (ProcessingException e) {
                this.messageList.addMessage(e.getMessage());
                this.btFlash.setEnabled(false);
            }
        }
        TraceHelper.exit(this, "doSearch");
    }

    @Override
    public void consumeReturnCode(Integer rc) {
        TraceHelper.entry(this, "consumeReturnCode");
        this.btClose.setEnabled(true);
        this.btFlash.setEnabled(true);
        this.btSearch.setEnabled(true);
        if (rc == 0) {
            long duration = (System.currentTimeMillis() - this.startTime) / 1000L;
            this.messageList.addMessage(String.valueOf(VNAMessages.getString("VNAFirmwareUpdateDialog.UploadOK")) + duration + "s");
        } else {
            this.messageList.addMessage(VNAMessages.getString("VNAFirmwareUpdateDialog.UploadFailed"));
        }
        TraceHelper.exit(this, "consumeReturnCode");
    }
}

