/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.firmware;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.device.IVNADriver;
import krause.vna.device.serial.VNADriverSerialBase;
import krause.vna.firmware.HexFileParser;
import krause.vna.firmware.VNABaseFirmwareFlasher;
import purejavacomm.SerialPort;

public class MegaLoadLoader
extends VNABaseFirmwareFlasher {
    private int readChar(SerialPort port, long timeout) throws ProcessingException {
        int rc = -1;
        long endTime = System.currentTimeMillis() + timeout;
        try {
            InputStream stream = port.getInputStream();
            while (stream.available() == 0) {
                Thread.sleep(10L);
                if (System.currentTimeMillis() <= endTime) continue;
                throw new ProcessingException("No chars");
            }
            rc = stream.read();
        }
        catch (Exception e) {
            ErrorLogHelper.exception(this, "readChar", e);
            throw new ProcessingException(e);
        }
        return rc;
    }

    @Override
    public void burnBuffer(HexFileParser hfp, IVNADriver driver) throws ProcessingException {
        TraceHelper.entry(this, "burnBuffer");
        VNADriverSerialBase serialDriver = (VNADriverSerialBase)driver;
        SerialPort port = serialDriver.getPort();
        serialDriver.flushInputStream();
        OutputStream oStream = null;
        InputStream iStream = null;
        try {
            try {
                oStream = port.getOutputStream();
                iStream = port.getInputStream();
                if (this.isAutoReset()) {
                    TraceHelper.text(this, "burnBuffer", "sending reset command");
                    oStream.write(57);
                    oStream.write(57);
                    oStream.write(13);
                    oStream.flush();
                }
                MemoryType memoryType = null;
                while (true) {
                    int lastChar = this.readChar(port, 5000L);
                    TraceHelper.text(this, "burnBuffer", "read [" + (char)lastChar + "] - " + lastChar);
                    if (lastChar == 62) {
                        oStream.write(60);
                        oStream.flush();
                        memoryType = MemoryType.FLASH;
                        this.setPagePtr(0);
                        this.setRetryCount(0);
                        continue;
                    }
                    if (lastChar == 41) {
                        memoryType = MemoryType.EEPROM;
                        throw new ProcessingException("EEPROM not supported");
                    }
                    if (lastChar == 33) {
                        if (memoryType == MemoryType.FLASH) {
                            if (this.sendFlashBlock(oStream, hfp.getFlashMax(), hfp.getFlash())) {
                                break;
                            }
                            this.setPagePtr(this.getPagePtr() + 1);
                            continue;
                        }
                        if (memoryType != MemoryType.EEPROM) continue;
                        throw new ProcessingException("EEPROM not supported");
                    }
                    if (lastChar == 64) {
                        if (memoryType == MemoryType.FLASH) {
                            --this.pagePtr;
                            this.sendFlashBlock(oStream, hfp.getFlashMax(), hfp.getFlash());
                            ++this.pagePtr;
                            ++this.retryCount;
                            if (this.retryCount <= 3) continue;
                            oStream.write(255);
                            oStream.write(255);
                            throw new ProcessingException("Retry count exceeded");
                        }
                        if (memoryType != MemoryType.EEPROM) continue;
                        throw new ProcessingException("EEPROM not supported");
                    }
                    if (lastChar == 37) {
                        throw new ProcessingException("LockBits not supported");
                    }
                    if (lastChar == 65) {
                        this.deviceType = "Mega 8";
                        continue;
                    }
                    if (lastChar == 66) {
                        this.deviceType = "Mega 16";
                        continue;
                    }
                    if (lastChar == 67) {
                        this.deviceType = "Mega 64";
                        continue;
                    }
                    if (lastChar == 68) {
                        this.deviceType = "Mega 128";
                        continue;
                    }
                    if (lastChar == 69) {
                        this.deviceType = "Mega 32";
                        continue;
                    }
                    if (lastChar == 70) {
                        this.deviceType = "Mega 162";
                        continue;
                    }
                    if (lastChar == 71) {
                        this.deviceType = "Mega 169";
                        continue;
                    }
                    if (lastChar == 72) {
                        this.deviceType = "Mega8515";
                        continue;
                    }
                    if (lastChar == 73) {
                        this.deviceType = "Mega8535";
                        continue;
                    }
                    if (lastChar == 74) {
                        this.deviceType = "Mega163";
                        continue;
                    }
                    if (lastChar == 75) {
                        this.deviceType = "Mega323";
                        continue;
                    }
                    if (lastChar == 76) {
                        this.deviceType = "Mega48";
                        continue;
                    }
                    if (lastChar == 77) {
                        this.deviceType = "Mega88";
                        continue;
                    }
                    if (lastChar == 78) {
                        this.deviceType = "Mega168";
                        continue;
                    }
                    if (lastChar == 128) {
                        this.deviceType = "Mega165";
                        continue;
                    }
                    if (lastChar == 129) {
                        this.deviceType = "Mega3250";
                        continue;
                    }
                    if (lastChar == 130) {
                        this.deviceType = "Mega6450";
                        continue;
                    }
                    if (lastChar == 131) {
                        this.deviceType = "Mega3290";
                        continue;
                    }
                    if (lastChar == 132) {
                        this.deviceType = "Mega6490";
                        continue;
                    }
                    if (lastChar == 133) {
                        this.deviceType = "Mega406";
                        continue;
                    }
                    if (lastChar == 134) {
                        this.deviceType = "Mega640";
                        continue;
                    }
                    if (lastChar == 135) {
                        this.deviceType = "Mega1280";
                        continue;
                    }
                    if (lastChar == 136) {
                        this.deviceType = "Mega2560";
                        continue;
                    }
                    if (lastChar == 137) {
                        this.deviceType = "MCAN128";
                        continue;
                    }
                    if (lastChar == 138) {
                        this.deviceType = "Mega164";
                        continue;
                    }
                    if (lastChar == 139) {
                        this.deviceType = "Mega328";
                        continue;
                    }
                    if (lastChar == 140) {
                        this.deviceType = "Mega324";
                        continue;
                    }
                    if (lastChar == 141) {
                        this.deviceType = "Mega325";
                        continue;
                    }
                    if (lastChar == 142) {
                        this.deviceType = "Mega644";
                        continue;
                    }
                    if (lastChar == 143) {
                        this.deviceType = "Mega645";
                        continue;
                    }
                    if (lastChar == 144) {
                        this.deviceType = "Mega1281";
                        continue;
                    }
                    if (lastChar == 145) {
                        this.deviceType = "Mega2561";
                        continue;
                    }
                    if (lastChar == 146) {
                        this.deviceType = "Mega2560";
                        continue;
                    }
                    if (lastChar == 147) {
                        this.deviceType = "Mega404";
                        continue;
                    }
                    if (lastChar == 148) {
                        this.deviceType = "MUSB1286";
                        continue;
                    }
                    if (lastChar == 149) {
                        this.deviceType = "MUSB1287";
                        continue;
                    }
                    if (lastChar == 150) {
                        this.deviceType = "MUSB162";
                        continue;
                    }
                    if (lastChar == 151) {
                        this.deviceType = "MUSB646";
                        continue;
                    }
                    if (lastChar == 152) {
                        this.deviceType = "MUSB647";
                        continue;
                    }
                    if (lastChar == 153) {
                        this.deviceType = "MUSB82";
                        continue;
                    }
                    if (lastChar == 154) {
                        this.deviceType = "MCAN32";
                        continue;
                    }
                    if (lastChar == 155) {
                        this.deviceType = "MCAN64";
                        continue;
                    }
                    if (lastChar == 156) {
                        this.deviceType = "Mega329";
                        continue;
                    }
                    if (lastChar == 157) {
                        this.deviceType = "Mega649";
                        continue;
                    }
                    if (lastChar == 158) {
                        this.deviceType = "Mega256";
                        continue;
                    }
                    if (lastChar == 81) {
                        this.pageSize = 32;
                        continue;
                    }
                    if (lastChar == 82) {
                        this.pageSize = 64;
                        continue;
                    }
                    if (lastChar == 83) {
                        this.pageSize = 128;
                        continue;
                    }
                    if (lastChar == 84) {
                        this.pageSize = 256;
                        continue;
                    }
                    if (lastChar == 86) {
                        this.pageSize = 512;
                        continue;
                    }
                    if (lastChar == 97) {
                        this.bootSize = 128;
                        continue;
                    }
                    if (lastChar == 98) {
                        this.bootSize = 256;
                        continue;
                    }
                    if (lastChar == 99) {
                        this.bootSize = 512;
                        continue;
                    }
                    if (lastChar == 100) {
                        this.bootSize = 1024;
                        continue;
                    }
                    if (lastChar == 101) {
                        this.bootSize = 2048;
                        continue;
                    }
                    if (lastChar == 102) {
                        this.bootSize = 4096;
                        continue;
                    }
                    if (lastChar == 103) {
                        this.flashSize = 1024;
                        continue;
                    }
                    if (lastChar == 104) {
                        this.flashSize = 2048;
                        continue;
                    }
                    if (lastChar == 105) {
                        this.flashSize = 4096;
                        continue;
                    }
                    if (lastChar == 108) {
                        this.flashSize = 8192;
                        continue;
                    }
                    if (lastChar == 109) {
                        this.flashSize = 16384;
                        continue;
                    }
                    if (lastChar == 110) {
                        this.flashSize = 32768;
                        continue;
                    }
                    if (lastChar == 111) {
                        this.flashSize = 65536;
                        continue;
                    }
                    if (lastChar == 112) {
                        this.flashSize = 131072;
                        continue;
                    }
                    if (lastChar == 113) {
                        this.flashSize = 262144;
                        continue;
                    }
                    if (lastChar == 114) {
                        this.flashSize = 40960;
                        continue;
                    }
                    if (lastChar == 46) {
                        this.eEpromSize = 512;
                        continue;
                    }
                    if (lastChar == 47) {
                        this.eEpromSize = 512;
                        continue;
                    }
                    if (lastChar == 48) {
                        this.eEpromSize = 512;
                        continue;
                    }
                    if (lastChar == 49) {
                        this.eEpromSize = 512;
                        continue;
                    }
                    if (lastChar == 50) {
                        this.eEpromSize = 1024;
                        continue;
                    }
                    if (lastChar == 51) {
                        this.eEpromSize = 2048;
                        continue;
                    }
                    if (lastChar != 52) continue;
                    this.eEpromSize = 4096;
                }
            }
            catch (IOException e) {
                ErrorLogHelper.exception(this, "burnBuffer", e);
                throw new ProcessingException(e);
            }
        }
        finally {
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "burnBuffer", e);
                }
            }
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "burnBuffer", e);
                }
            }
        }
        TraceHelper.text(this, "burnBuffer", "PageSize:   " + this.pageSize + " bytes");
        TraceHelper.text(this, "burnBuffer", "bootSize:   " + this.bootSize + " words");
        TraceHelper.text(this, "burnBuffer", "flashSize:  " + this.flashSize + " bytes");
        TraceHelper.text(this, "burnBuffer", "EEpromSize: " + this.eEpromSize + " bytes");
        TraceHelper.text(this, "burnBuffer", "retryCount: " + this.retryCount);
        TraceHelper.exit(this, "burnBuffer");
    }

    private boolean sendFlashBlock(OutputStream oStream, int flashMax, byte[] flash) throws IOException {
        boolean rc = false;
        TraceHelper.entry(this, "sendFlashBlock");
        TraceHelper.text(this, "sendFlashBlock", "pagePtr:" + this.pagePtr);
        if (this.pagePtr * this.pageSize > flashMax) {
            oStream.write(255);
            oStream.write(255);
            TraceHelper.text(this, "sendFlashBlock", "Last page send");
            rc = true;
        } else {
            this.getMessenger().publishMessage("Sending page " + this.pagePtr + " to device");
            TraceHelper.text(this, "sendFlashBlock", "sending page:" + this.pagePtr);
            oStream.write((byte)(this.pagePtr >> 8 & 0xFF));
            oStream.write((byte)(this.pagePtr & 0xFF));
            int CheckSum = 0;
            int bytesSend = 0;
            TraceHelper.text(this, "sendFlashBlock", "sending data");
            oStream.write(flash, this.pagePtr * this.pageSize, this.pageSize);
            while (bytesSend < this.pageSize) {
                CheckSum = (byte)(CheckSum + flash[this.pagePtr * this.pageSize + bytesSend]);
                ++bytesSend;
            }
            TraceHelper.text(this, "sendFlashBlock", "sending checksum");
            oStream.write(CheckSum);
        }
        TraceHelper.exit(this, "sendFlashBlock");
        return rc;
    }

    static enum MemoryType {
        FLASH,
        EEPROM;

    }
}

