/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.firmware;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.TraceHelper;

public class HexFileParser {
    private static final int RADIX = 16;
    private static final byte DATA_RECORD = 0;
    private static final byte EOF_RECORD = 1;
    private static final byte EXTENDED_ADDRESS_RECORD = 2;
    private static final byte EXTENDED_LINEAR_ADDRESS_RECORD = 4;
    private int flashMin;
    private int flashMax;
    private int memOffset;
    private int memUsage;
    private byte[] flash = new byte[262144];
    private File file = null;

    public HexFileParser(File file) {
        this.file = file;
    }

    public void parseFile() throws ProcessingException {
        TraceHelper.entry(this, "parseFile");
        String record = "";
        int recordNum = 0;
        BufferedReader br = null;
        FileReader fileReader = null;
        this.flashMin = Integer.MAX_VALUE;
        this.flashMax = 0;
        this.memOffset = 0;
        this.memUsage = 0;
        try {
            try {
                fileReader = new FileReader(this.file);
                br = new BufferedReader(fileReader);
                while ((record = br.readLine()) != null) {
                    byte computedChecksum = 0;
                    if (!record.startsWith(":")) {
                        throw new ProcessingException("No Intel Hex file");
                    }
                    ++recordNum;
                    int dataLength = Integer.parseInt(record.substring(1, 3), 16);
                    computedChecksum = (byte)(computedChecksum + dataLength);
                    byte addressHi = (byte)Integer.parseInt(record.substring(3, 5), 16);
                    computedChecksum = (byte)(computedChecksum + addressHi);
                    byte addressLo = (byte)Integer.parseInt(record.substring(5, 7), 16);
                    computedChecksum = (byte)(computedChecksum + addressLo);
                    int address = Integer.parseInt(record.substring(3, 7), 16);
                    byte recordType = (byte)Integer.parseInt(record.substring(7, 9), 16);
                    computedChecksum = (byte)(computedChecksum + recordType);
                    if (recordType == 0) {
                        if (this.flashMin > this.memOffset + address) {
                            this.flashMin = this.memOffset + address;
                        }
                        int i = 0;
                        while (i < dataLength) {
                            int x = 9 + 2 * i;
                            this.flash[this.memOffset + address + i] = (byte)Integer.parseInt(record.substring(x, x + 2), 16);
                            computedChecksum = (byte)(computedChecksum + this.flash[this.memOffset + address + i]);
                            if (this.flashMax < this.memOffset + address + i) {
                                this.flashMax = this.memOffset + address + i;
                            }
                            ++i;
                        }
                    } else {
                        if (recordType == 1) {
                            this.memUsage = this.flashMax - this.flashMin + 1;
                            break;
                        }
                        if (recordType == 2) {
                            addressHi = (byte)Integer.parseInt(record.substring(9, 11), 16);
                            computedChecksum = (byte)(computedChecksum + addressHi);
                            addressLo = (byte)Integer.parseInt(record.substring(11, 13), 16);
                            computedChecksum = (byte)(computedChecksum + addressLo);
                            this.memOffset = Integer.parseInt(record.substring(9, 13), 16);
                            this.memOffset <<= 4;
                        } else if (recordType == 4) {
                            addressHi = (byte)Integer.parseInt(record.substring(9, 11), 16);
                            computedChecksum = (byte)(computedChecksum + addressHi);
                            addressLo = (byte)Integer.parseInt(record.substring(11, 13), 16);
                            computedChecksum = (byte)(computedChecksum + addressLo);
                            this.memOffset = Integer.parseInt(record.substring(9, 13), 16);
                            this.memOffset <<= 16;
                        } else {
                            throw new ProcessingException("No valid record identifier [" + recordType + "]");
                        }
                    }
                    byte fileChecksum = (byte)Integer.parseInt(record.substring(record.length() - 2, record.length()), 16);
                    computedChecksum = (byte)(256 - computedChecksum);
                    this.memUsage = this.flashMax - this.flashMin + 1;
                    if (computedChecksum == fileChecksum) continue;
                    throw new IllegalArgumentException("invalid checksum in record=" + recordNum + " read=" + fileChecksum + " calc=" + computedChecksum);
                }
            }
            catch (Exception ex) {
                throw new ProcessingException(ex);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        TraceHelper.exit(this, "parseFile");
    }

    public int getFlashMin() {
        return this.flashMin;
    }

    public int getFlashMax() {
        return this.flashMax;
    }

    public int getMemOffset() {
        return this.memOffset;
    }

    public int getMemUsage() {
        return this.memUsage;
    }

    public byte[] getFlash() {
        return this.flash;
    }

    public String getFlashAsHexFileLine(int address, int length) {
        String rc = ":";
        byte cs = 0;
        rc = String.valueOf(rc) + String.format("%02X", length);
        cs = (byte)(cs + length);
        rc = String.valueOf(rc) + String.format("%04X", address);
        cs = (byte)(cs + address / 256);
        cs = (byte)(cs + address % 256);
        rc = String.valueOf(rc) + String.format("%02X", (byte)0);
        cs = (byte)(cs + 0);
        int i = 0;
        while (i < length) {
            byte b = this.flash[address + i];
            rc = String.valueOf(rc) + String.format("%02X", b);
            cs = (byte)(cs + b);
            ++i;
        }
        cs = (byte)(256 - cs);
        rc = String.valueOf(rc) + String.format("%02X", cs);
        return rc;
    }

    public String getLastHexFileLine() {
        return ":00000001FF";
    }
}

