/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.export;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.export.VNAExporter;
import krause.vna.gui.VNAMainFrame;

public class ZPlotsExporter
extends VNAExporter {
    public ZPlotsExporter(VNAMainFrame mainFrame) {
        super(mainFrame);
    }

    @Override
    public String export(String fnp, boolean overwrite) throws ProcessingException {
        TraceHelper.entry(this, "export");
        String currFilename = "not saved";
        VNACalibratedSampleBlock blk = this.datapool.getCalibratedData();
        VNACalibratedSample[] samples = blk.getCalibratedSamples();
        currFilename = this.check4FileToDelete(fnp, overwrite);
        boolean transmissionMode = this.datapool.getScanMode().isTransmissionMode();
        if (currFilename != null) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.ENGLISH);
            DecimalFormat df = new DecimalFormat("0.000", dfs);
            int valSep = 44;
            VNADeviceInfoBlock dib = this.datapool.getDriver().getDeviceInfoBlock();
            String phaseText = "???";
            phaseText = dib.getMinPhase() < 0.0 ? "\u00b1Phase(deg)" : "Phase(deg)";
            try {
                FileOutputStream fos = new FileOutputStream(currFilename);
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "ISO-8859-1"));
                if (transmissionMode) {
                    w.write("\"Frequency(Hz)\",\"Transmission Loss(dB)\",\"" + phaseText + "\"");
                } else {
                    w.write("\"Frequency(Hz)\",\"Return Loss(dB)\",\"" + phaseText + "\"");
                }
                w.write(System.getProperty("line.separator"));
                int i = 0;
                while (i < samples.length) {
                    VNACalibratedSample data = samples[i];
                    w.write(df.format(data.getFrequency()));
                    ((Writer)w).write(valSep);
                    if (transmissionMode) {
                        w.write(df.format(-data.getTransmissionLoss()));
                    } else {
                        w.write(df.format(-data.getReflectionLoss()));
                    }
                    ((Writer)w).write(valSep);
                    if (transmissionMode) {
                        w.write(df.format(data.getTransmissionPhase()));
                    } else {
                        w.write(df.format(data.getReflectionPhase()));
                    }
                    w.write(System.getProperty("line.separator"));
                    ++i;
                }
                ((Writer)w).flush();
                ((Writer)w).close();
                fos.close();
            }
            catch (IOException e) {
                ErrorLogHelper.exception(ZPlotsExporter.class, "export", e);
                throw new ProcessingException(e);
            }
        }
        TraceHelper.exit(ZPlotsExporter.class, "export");
        return currFilename;
    }

    @Override
    public String getExtension() {
        return ".zplot.csv";
    }
}

