/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.export;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNABaseSample;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibrationPoint;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;

public class XLSRawExporter {
    private static final XLSRawExporter instance = new XLSRawExporter();

    public static void export(VNABaseSample[] pSamples, String pFilename) {
        TraceHelper.entry(instance, "export");
        String currFilename = String.valueOf(VNAConfig.getSingleton().getExportDirectory()) + "/" + pFilename + ".xls";
        TraceHelper.text(instance, "export", "filename=" + currFilename);
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet("raw");
            int rowNum = 0;
            int cell = 0;
            HSSFRow row = sheet.createRow(rowNum++);
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Frequency (Hz)"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Img"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Real"));
            int i = 0;
            while (i < pSamples.length) {
                VNABaseSample data = pSamples[i];
                cell = 0;
                row = sheet.createRow(rowNum);
                row.createCell(cell++).setCellValue((double)data.getFrequency());
                row.createCell(cell++).setCellValue((double)data.getLoss());
                row.createCell(cell++).setCellValue((double)data.getAngle());
                ++rowNum;
                ++i;
            }
            sheet.autoSizeColumn(0);
            FileOutputStream fileOut = new FileOutputStream(currFilename);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (IOException e) {
            ErrorLogHelper.exception(instance, "export", e);
        }
        TraceHelper.exit(instance, "export");
    }

    public static void export(VNACalibrationPoint[] pSamples, String pFilename) {
        TraceHelper.entry(instance, "export");
        String currFilename = String.valueOf(VNAConfig.getSingleton().getExportDirectory()) + "/" + pFilename + ".xls";
        TraceHelper.text(instance, "export", "filename=" + currFilename);
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet("CalPoints");
            int rowNum = 0;
            int cell = 0;
            HSSFRow row = sheet.createRow(rowNum++);
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Frequency (Hz)"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Loss"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("real(DeltaE)"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("imag(DeltaE)"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("real(E00)"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("imag(E00)"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("real(E01)"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("imag(E01)"));
            int i = 0;
            while (i < pSamples.length) {
                VNACalibrationPoint data = pSamples[i];
                cell = 0;
                row = sheet.createRow(rowNum);
                row.createCell(cell++).setCellValue((double)data.getFrequency());
                row.createCell(cell++).setCellValue(data.getLoss());
                row.createCell(cell++).setCellValue(data.getDeltaE().getReal());
                row.createCell(cell++).setCellValue(data.getDeltaE().getImaginary());
                row.createCell(cell++).setCellValue(data.getE00().getReal());
                row.createCell(cell++).setCellValue(data.getE00().getImaginary());
                row.createCell(cell++).setCellValue(data.getE11().getReal());
                row.createCell(cell++).setCellValue(data.getE11().getImaginary());
                ++rowNum;
                ++i;
            }
            sheet.autoSizeColumn(0);
            FileOutputStream fileOut = new FileOutputStream(currFilename);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (IOException e) {
            ErrorLogHelper.exception(instance, "export", e);
        }
        TraceHelper.exit(instance, "export");
    }

    public static void export(VNACalibratedSample[] pSamples, String pFilename) {
        TraceHelper.entry(instance, "export");
        String currFilename = String.valueOf(VNAConfig.getSingleton().getExportDirectory()) + "/" + pFilename + ".xls";
        TraceHelper.text(instance, "export", "filename=" + currFilename);
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet("CalPoints");
            int rowNum = 0;
            int cell = 0;
            HSSFRow row = sheet.createRow(rowNum++);
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Frequency (Hz)"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Magnitude"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("ReflLoss"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("ReflPhase"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("SWR"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Theta"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("TransLoss"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("TransPhase"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Rs"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Xs"));
            row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("|Z|"));
            int i = 0;
            while (i < pSamples.length) {
                VNACalibratedSample data = pSamples[i];
                cell = 0;
                row = sheet.createRow(rowNum);
                row.createCell(cell++).setCellValue((double)data.getFrequency());
                row.createCell(cell++).setCellValue(data.getMag());
                row.createCell(cell++).setCellValue(data.getReflectionLoss());
                row.createCell(cell++).setCellValue(data.getReflectionPhase());
                row.createCell(cell++).setCellValue(data.getSWR());
                row.createCell(cell++).setCellValue(data.getTheta());
                row.createCell(cell++).setCellValue(data.getTransmissionLoss());
                row.createCell(cell++).setCellValue(data.getTransmissionPhase());
                row.createCell(cell++).setCellValue(data.getR());
                row.createCell(cell++).setCellValue(data.getX());
                row.createCell(cell++).setCellValue(data.getZ());
                ++rowNum;
                ++i;
            }
            sheet.autoSizeColumn(0);
            FileOutputStream fileOut = new FileOutputStream(currFilename);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (IOException e) {
            ErrorLogHelper.exception(instance, "export", e);
        }
        TraceHelper.exit(instance, "export");
    }
}

