/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.export;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.export.VNAExporter;
import krause.vna.gui.VNAMainFrame;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;

public class XLSExporter
extends VNAExporter {
    public XLSExporter(VNAMainFrame mainFrame) {
        super(mainFrame);
    }

    private void dumpData(VNACalibratedSample[] dataList, HSSFWorkbook wb) throws IOException {
        int idx = wb.getSheetIndex("vnaJ");
        if (idx >= 0) {
            wb.removeSheetAt(idx);
        }
        HSSFSheet sheet = wb.createSheet("vnaJ");
        int rowNum = 1;
        int cell = 0;
        HSSFRow row = sheet.createRow(rowNum++);
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Frequency (Hz)"));
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Returnloss (dB)"));
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Returnphase (\u00b0)"));
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Transmissionloss (dB)"));
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Transmissionphase (\u00b0)"));
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Rs (Ohm)"));
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Xs (Ohm)"));
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("|Z| (Ohm)"));
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Magnitude"));
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("SWR"));
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("Theta"));
        row.createCell(cell++).setCellValue((RichTextString)new HSSFRichTextString("GroupDelay (nS)"));
        int i = 0;
        while (i < dataList.length) {
            VNACalibratedSample data = dataList[i];
            cell = 0;
            row = sheet.createRow(rowNum);
            row.createCell(cell++).setCellValue((double)data.getFrequency());
            row.createCell(cell++).setCellValue(data.getReflectionLoss());
            row.createCell(cell++).setCellValue(data.getReflectionPhase());
            row.createCell(cell++).setCellValue(data.getTransmissionLoss());
            row.createCell(cell++).setCellValue(data.getTransmissionPhase());
            row.createCell(cell++).setCellValue(data.getR());
            row.createCell(cell++).setCellValue(data.getX());
            row.createCell(cell++).setCellValue(data.getZ());
            row.createCell(cell++).setCellValue(data.getMag());
            row.createCell(cell++).setCellValue(data.getSWR());
            row.createCell(cell++).setCellValue(data.getTheta());
            row.createCell(cell++).setCellValue(data.getGroupDelay());
            ++rowNum;
            ++i;
        }
        sheet.autoSizeColumn(0);
        sheet.autoSizeColumn(1);
        sheet.autoSizeColumn(2);
    }

    @Override
    public String export(String fnp, boolean overwrite) throws ProcessingException {
        TraceHelper.entry(XLSExporter.class, "export");
        String currFilename = null;
        VNACalibratedSampleBlock blk = this.datapool.getCalibratedData();
        VNACalibratedSample[] pDataList = blk.getCalibratedSamples();
        try {
            currFilename = this.check4FileToDelete(fnp, overwrite);
            if (currFilename != null) {
                HSSFWorkbook wb = new HSSFWorkbook();
                this.dumpData(pDataList, wb);
                FileOutputStream fileOut = new FileOutputStream(currFilename);
                wb.write((OutputStream)fileOut);
                fileOut.close();
            }
        }
        catch (IOException e) {
            ErrorLogHelper.exception(XLSExporter.class, "export", e);
            throw new ProcessingException(e);
        }
        TraceHelper.exit(XLSExporter.class, "export");
        return currFilename;
    }

    @Override
    public String getExtension() {
        return ".xls";
    }
}

