/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.export;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNADataPool;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.export.JFSeries;
import krause.vna.export.SWRLogarithmicAxis;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.gui.panels.marker.VNAMarker;
import krause.vna.gui.panels.marker.VNAMarkerPanel;
import krause.vna.gui.scale.VNAGenericScale;
import krause.vna.gui.scale.VNAMeasurementScale;
import krause.vna.gui.scale.VNAScaleSymbols;
import krause.vna.resources.VNAMessages;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYPolygonAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.RangeType;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;

public abstract class VNAExporter {
    protected VNAConfig config = VNAConfig.getSingleton();
    protected VNADataPool datapool = VNADataPool.getSingleton();
    protected final Color COLOR_LEFT_SCALE = Color.BLUE;
    protected final Color COLOR_RIGHT_SCALE = Color.RED;
    protected VNAMainFrame mainFrame;
    protected final Font LABEL_FONT = new Font("SansSerif", 0, 30);
    protected final Font TICK_FONT = new Font("SansSerif", 0, 25);
    protected final Font MARKER_FONT = new Font("Courier", 1, 15);
    private JFSeries series1;
    private JFSeries series2;
    private VNAMeasurementScale scale1;
    private VNAMeasurementScale scale2;
    private VNAScaleSymbols.SCALE_TYPE scaleType1;
    private VNAScaleSymbols.SCALE_TYPE scaleType2;
    private NumberAxis rangeAxis1;
    private NumberAxis rangeAxis2;

    protected JFSeries generateSeriesBasedOnScale(VNAMeasurementScale scale, VNACalibratedSample[] dataList) {
        TraceHelper.entry(this, "generateSeriesBasedOnScale");
        JFSeries series = new JFSeries(scale);
        VNAScaleSymbols.SCALE_TYPE scaleTypeNo = scale.getScale().getType();
        if (scaleTypeNo != VNAScaleSymbols.SCALE_TYPE.SCALE_NONE) {
            XYSeries xySeries = new XYSeries((Comparable)((Object)scale.getScale().toString()));
            int i = 0;
            while (i < dataList.length) {
                VNACalibratedSample data = dataList[i];
                xySeries.add((double)data.getFrequency(), data.getDataByScaleType(scaleTypeNo));
                ++i;
            }
            series.setSeries(xySeries);
        }
        TraceHelper.exit(this, "generateSeriesBasedOnScale");
        return series;
    }

    public String replaceParameters(String in) {
        String rc = null;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(0);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(10);
        nf.setGroupingUsed(false);
        nf.setParseIntegerOnly(true);
        String pexVf = "<not set>";
        String pexLen = "<not set>";
        if (this.config.containsKey("PortExtension.cableVelocityFactor")) {
            double vf = this.config.getDouble("PortExtension.cableVelocityFactor", 0.0);
            pexVf = VNAFormatFactory.getVelocityFormat().format(vf);
        }
        if (this.config.containsKey("PortExtension.cableLength")) {
            double len = this.config.getDouble("PortExtension.cableLength", 0.0);
            pexLen = VNAFormatFactory.getVelocityFormat().format(len);
        }
        Object[] parms = new Object[]{new Time(System.currentTimeMillis()), this.datapool.getScanMode().toString(), this.datapool.getDriver().getDeviceInfoBlock().getShortName(), this.datapool.getDriver().getDeviceInfoBlock().getLongName(), nf.format(this.datapool.getFrequencyRange().getStart()), nf.format(this.datapool.getFrequencyRange().getStop()), VNAFormatFactory.getFrequencyFormat().format(this.datapool.getFrequencyRange().getStart()), VNAFormatFactory.getFrequencyFormat().format(this.datapool.getFrequencyRange().getStop()), nf.format(this.datapool.getCalibratedData().getCalibratedSamples().length), this.mainFrame != null ? nf.format(this.mainFrame.getDataPanel().getAverage()) : "?", nf.format(this.datapool.getMainCalibrationBlock().getNumberOfSteps()), nf.format(this.datapool.getMainCalibrationBlock().getNumberOfOverscans()), this.datapool.getMainCalibrationBlock().getFile() != null ? this.datapool.getMainCalibrationBlock().getFile().getName() : "---", System.getProperty("user.name"), this.config.getExportTitle(), pexLen, pexVf};
        rc = MessageFormat.format(in, parms);
        return rc;
    }

    protected String check4FileToDelete(String filenamePattern, boolean overwrite) {
        String currFilename = this.replaceParameters(String.valueOf(filenamePattern) + this.getExtension());
        File fi = new File(currFilename);
        currFilename = fi.getAbsolutePath();
        if (fi.exists()) {
            if (overwrite) {
                fi.delete();
            } else {
                String msg = MessageFormat.format(VNAMessages.getString("Message.Export.1"), currFilename);
                int n = JOptionPane.showOptionDialog(this.mainFrame.getJFrame(), msg, VNAMessages.getString("Message.Export.2"), 0, 3, null, null, null);
                if (n == 0) {
                    fi.delete();
                } else {
                    currFilename = null;
                }
            }
        }
        return currFilename;
    }

    protected void createChartMarkers(XYPlot plot) {
        VNAMarker[] markers;
        VNAMarkerPanel mp = this.mainFrame.getMarkerPanel();
        VNAMarker[] vNAMarkerArray = markers = mp.getMarkers();
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            VNAMarker marker = vNAMarkerArray[n2];
            if (marker.isVisible()) {
                this.createChartMarker(marker, plot, Color.BLACK);
            }
            ++n2;
        }
    }

    private void createChartMarker(VNAMarker marker, XYPlot plot, Color col) {
        double ub;
        double y_w;
        double y;
        XYItemRenderer rend;
        int xFactor = 120 - 20 * this.config.getMarkerSize();
        int yFactor = 70 - 10 * this.config.getMarkerSize();
        ValueAxis da = plot.getDomainAxis(0);
        double x_w = da.getRange().getLength() / (double)xFactor;
        double x = marker.getFrequency();
        if (this.series1 != null) {
            rend = plot.getRenderer(0);
            y = marker.getSample().getDataByScaleType(this.scaleType1);
            y_w = this.rangeAxis1.getRange().getLength() / (double)yFactor;
            ub = this.rangeAxis1.getRange().getUpperBound();
            if (ub > 0.0) {
                if (y + y_w > ub) {
                    this.createMarkerUp(rend, col, x, y, x_w, y_w, marker.getName());
                } else {
                    this.createMarkerDown(rend, col, x, y, x_w, y_w, marker.getName());
                }
            } else if (ub - y_w < y) {
                this.createMarkerUp(rend, col, x, y, x_w, y_w, marker.getName());
            } else {
                this.createMarkerDown(rend, col, x, y, x_w, y_w, marker.getName());
            }
        }
        if (this.series2 != null) {
            rend = plot.getRenderer(1);
            y = marker.getSample().getDataByScaleType(this.scaleType2);
            y_w = this.rangeAxis2.getRange().getLength() / (double)yFactor;
            ub = this.rangeAxis2.getRange().getUpperBound();
            if (ub > 0.0) {
                if (y + y_w > ub) {
                    this.createMarkerUp(rend, col, x, y, x_w, y_w, marker.getName());
                } else {
                    this.createMarkerDown(rend, col, x, y, x_w, y_w, marker.getName());
                }
            } else if (ub - y_w < y) {
                this.createMarkerUp(rend, col, x, y, x_w, y_w, marker.getName());
            } else {
                this.createMarkerDown(rend, col, x, y, x_w, y_w, marker.getName());
            }
        }
    }

    void createMarkerUp(XYItemRenderer rend, Color col, double x, double y, double wx, double wy, String name) {
        TraceHelper.entry((Object)this, "createMarkerUp", x + " " + y);
        XYPolygonAnnotation annShape = new XYPolygonAnnotation(new double[]{x, y, x + wx, y - wy, x - wx, y - wy, x, y}, (Stroke)new BasicStroke(2.0f), (Paint)col, null);
        rend.addAnnotation((XYAnnotation)annShape);
        XYTextAnnotation annText = new XYTextAnnotation(name, x, y - 2.0 * wy);
        annText.setFont(this.LABEL_FONT);
        rend.addAnnotation((XYAnnotation)annText);
    }

    void createMarkerDown(XYItemRenderer rend, Color col, double x, double y, double wx, double wy, String name) {
        TraceHelper.entry((Object)this, "createMarkerDown", x + " " + y);
        XYPolygonAnnotation annShape = new XYPolygonAnnotation(new double[]{x, y, x + wx, y + wy, x - wx, y + wy, x, y}, (Stroke)new BasicStroke(2.0f), (Paint)col, null);
        rend.addAnnotation((XYAnnotation)annShape);
        XYTextAnnotation annText = new XYTextAnnotation(name, x, y + 2.0 * wy);
        annText.setFont(this.LABEL_FONT);
        rend.addAnnotation((XYAnnotation)annText);
    }

    public JFreeChart createChart(VNACalibratedSample[] dataList) {
        XYPlot plot;
        TraceHelper.entry(this, "createChart");
        this.scale1 = this.mainFrame.getDiagramPanel().getScaleLeft();
        this.scaleType1 = this.scale1.getScale().getType();
        if (this.scaleType1 != VNAScaleSymbols.SCALE_TYPE.SCALE_NONE) {
            this.series1 = this.generateSeriesBasedOnScale(this.scale1, dataList);
        }
        this.scale2 = this.mainFrame.getDiagramPanel().getScaleRight();
        this.scaleType2 = this.scale2.getScale().getType();
        if (this.scaleType2 != VNAScaleSymbols.SCALE_TYPE.SCALE_NONE) {
            if (this.series1 == null) {
                this.series1 = this.generateSeriesBasedOnScale(this.scale2, dataList);
                this.scaleType1 = this.scale2.getScale().getType();
            } else {
                this.series2 = this.generateSeriesBasedOnScale(this.scale2, dataList);
            }
        }
        String title = this.config.isPrintMainLegend() ? this.replaceParameters(this.config.getExportTitle()) : null;
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)VNAMessages.getString("Plot.frequency"), null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.config.isPrintFooter(), (boolean)true, (boolean)false);
        if (this.config.isPrintFooter()) {
            chart.getLegend().setItemFont(this.LABEL_FONT);
        }
        if (this.config.isPrintMainLegend()) {
            chart.getTitle().setFont(this.LABEL_FONT);
        }
        if (this.config.isPrintSubLegend()) {
            TextTitle source = new TextTitle(this.generateLegend(this.scale1, this.scale2));
            source.setFont(this.LABEL_FONT);
            source.setPosition(RectangleEdge.TOP);
            source.setHorizontalAlignment(HorizontalAlignment.CENTER);
            chart.addSubtitle((Title)source);
        }
        if (this.series1 != null) {
            plot = chart.getXYPlot();
            this.rangeAxis1 = this.generateRangeAxisBasedOnScale(this.series1);
            plot.setRangeAxis(0, (ValueAxis)this.rangeAxis1);
            plot.setDataset(0, (XYDataset)this.series1.getDataset());
            plot.mapDatasetToRangeAxis(0, 0);
            this.rangeAxis1.setLabelPaint((Paint)this.COLOR_LEFT_SCALE);
        }
        if (this.series2 != null) {
            plot = chart.getXYPlot();
            this.rangeAxis2 = this.generateRangeAxisBasedOnScale(this.series2);
            plot.setRangeAxis(1, (ValueAxis)this.rangeAxis2);
            plot.setDataset(1, (XYDataset)this.series2.getDataset());
            plot.mapDatasetToRangeAxis(1, 1);
            this.rangeAxis2.setLabelPaint((Paint)this.COLOR_RIGHT_SCALE);
        }
        chart.setBackgroundPaint((Paint)Color.white);
        plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.darkGray);
        plot.setRangeGridlinePaint((Paint)Color.darkGray);
        plot.setRenderer(0, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
        plot.setRenderer(1, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
        plot.getRenderer(0).setSeriesPaint(0, (Paint)this.COLOR_LEFT_SCALE);
        plot.getRenderer(1).setSeriesPaint(0, (Paint)this.COLOR_RIGHT_SCALE);
        plot.getRenderer(0).setSeriesStroke(0, (Stroke)new BasicStroke(1.0f));
        plot.getRenderer(1).setSeriesStroke(0, (Stroke)new BasicStroke(1.0f));
        this.createChartMarkers(plot);
        plot.getDomainAxis().setLabelFont(this.LABEL_FONT);
        plot.getDomainAxis().setTickLabelFont(this.TICK_FONT);
        if (this.config.isPrintMarkerDataInDiagramm()) {
            this.createTextMarkers(chart);
        }
        TraceHelper.exit(this, "createChart");
        return chart;
    }

    private String generateLegend(VNAMeasurementScale scale11, VNAMeasurementScale scale22) {
        String rc = "";
        if (scale11.getScale().getType() != VNAScaleSymbols.SCALE_TYPE.SCALE_NONE) {
            rc = String.valueOf(rc) + scale11.getScale().getName() + "=" + scale11.getScale().getDescription() + "    ";
        }
        if (scale22.getScale().getType() != VNAScaleSymbols.SCALE_TYPE.SCALE_NONE) {
            rc = String.valueOf(rc) + scale22.getScale().getName() + "=" + scale22.getScale().getDescription();
        }
        return rc;
    }

    private NumberAxis generateRangeAxisBasedOnScale(JFSeries series) {
        Object rangeAxis = null;
        VNAScaleSymbols.SCALE_TYPE scaleTypeNo = series.getScale().getScale().getType();
        if (scaleTypeNo != VNAScaleSymbols.SCALE_TYPE.SCALE_NONE) {
            if (scaleTypeNo == VNAScaleSymbols.SCALE_TYPE.SCALE_SWR) {
                SWRLogarithmicAxis logAxis = new SWRLogarithmicAxis(series.getDataset().getSeries(0).getKey().toString());
                logAxis.setLog10TickLabelsFlag(false);
                logAxis.setExpTickLabelsFlag(false);
                rangeAxis = logAxis;
                DecimalFormat nf = new DecimalFormat("0:1");
                rangeAxis.setNumberFormatOverride((NumberFormat)nf);
                rangeAxis.setAutoRange(false);
                this.setRange((NumberAxis)rangeAxis, series.getScale().getScale());
                rangeAxis.setRangeType(RangeType.FULL);
                rangeAxis.setAutoTickUnitSelection(true);
                rangeAxis.setTickMarksVisible(true);
                rangeAxis.setTickLabelsVisible(true);
            } else {
                rangeAxis = new NumberAxis(series.getDataset().getSeries(0).getKey().toString());
                rangeAxis.setAutoRange(false);
                this.setRange((NumberAxis)rangeAxis, series.getScale().getScale());
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                rangeAxis.setAutoRangeIncludesZero(false);
                rangeAxis.setInverted(false);
            }
            rangeAxis.setLabelFont(this.LABEL_FONT);
            rangeAxis.setTickLabelFont(this.TICK_FONT);
        }
        return rangeAxis;
    }

    private void setRange(NumberAxis pAxis, VNAGenericScale pScale) {
        double lower = pScale.getCurrentMinValue();
        double upper = pScale.getCurrentMaxValue();
        pAxis.setRange(Math.floor(lower), Math.ceil(upper));
    }

    public abstract String export(String var1, boolean var2) throws ProcessingException;

    public VNAExporter(VNAMainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public abstract String getExtension();

    private void createTextMarkers(JFreeChart chart) {
        TraceHelper.entry(this, "createTextMarkers");
        XYPlot plot = chart.getXYPlot();
        VNAMarkerPanel mp = this.mainFrame.getMarkerPanel();
        VNAMarker[] markers = mp.getMarkers();
        String txtFormat = "";
        txtFormat = String.valueOf(txtFormat) + "Marker {7}\n";
        txtFormat = String.valueOf(txtFormat) + "  " + VNAMessages.getString("Marker.Frequency") + " {0}\n";
        if (this.datapool.getScanMode().isReflectionMode()) {
            txtFormat = String.valueOf(txtFormat) + "  " + VNAMessages.getString("Marker.RL") + "    {1}\n";
            txtFormat = String.valueOf(txtFormat) + "  " + VNAMessages.getString("Marker.PhaseRL") + "     {2}\n";
            txtFormat = String.valueOf(txtFormat) + "  " + VNAMessages.getString("Marker.SWR") + "        {3}\n";
            txtFormat = String.valueOf(txtFormat) + "  " + VNAMessages.getString("Marker.Z") + "    {4}\n";
            txtFormat = String.valueOf(txtFormat) + "  " + VNAMessages.getString("Marker.R") + "     {5}\n";
            txtFormat = String.valueOf(txtFormat) + "  " + VNAMessages.getString("Marker.X") + "     {6}\n";
        } else {
            txtFormat = String.valueOf(txtFormat) + "  " + VNAMessages.getString("Marker.TL") + "    {1}\n";
            txtFormat = String.valueOf(txtFormat) + "  " + VNAMessages.getString("Marker.PhaseTL") + "     {2}\n";
            txtFormat = String.valueOf(txtFormat) + "  " + VNAMessages.getString("Marker.GrpDelay") + "        {3}\n";
        }
        String legend = "";
        if (this.config.isPrintMarkerDataHorizontal()) {
            VNAMarker[] vNAMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                VNAMarker marker = vNAMarkerArray[n2];
                if (marker.isVisible()) {
                    Object[] parms = new Object[]{marker.getFrequency(), marker.getTxtLoss().getText(), marker.getTxtPhase().getText(), marker.getTxtSwrGrpDelay().getText(), marker.getTxtZAbsolute().getText(), marker.getTxtRs().getText(), marker.getTxtXsAbsolute().getText(), marker.getName()};
                    String msg = MessageFormat.format(txtFormat, parms);
                    legend = String.valueOf(legend) + msg + "  \n";
                }
                ++n2;
            }
            Font lf = this.MARKER_FONT.deriveFont((float)this.config.getFontSizeTextMarker());
            TextTitle tt = new TextTitle(legend, lf);
            tt.setTextAlignment(HorizontalAlignment.LEFT);
            XYTitleAnnotation annotation = new XYTitleAnnotation(0.99, 1.0, (Title)tt, RectangleAnchor.TOP_RIGHT);
            plot.addAnnotation((XYAnnotation)annotation);
        } else {
            VNAMarker[] vNAMarkerArray = markers;
            int n = markers.length;
            int tt = 0;
            while (tt < n) {
                VNAMarker marker = vNAMarkerArray[tt];
                if (marker.isVisible()) {
                    Object[] parms = new Object[]{marker.getFrequency(), marker.getTxtLoss().getText(), marker.getTxtPhase().getText(), marker.getTxtSwrGrpDelay().getText(), marker.getTxtZAbsolute().getText(), marker.getTxtRs().getText(), marker.getTxtXsAbsolute().getText(), marker.getName()};
                    String msg = MessageFormat.format(txtFormat, parms);
                    legend = String.valueOf(legend) + msg + "  \n";
                }
                ++tt;
            }
            TextTitle tt2 = new TextTitle(legend, this.MARKER_FONT);
            tt2.setTextAlignment(HorizontalAlignment.LEFT);
            XYTitleAnnotation annotation = new XYTitleAnnotation(0.01, 1.0, (Title)tt2, RectangleAnchor.TOP_LEFT);
            plot.addAnnotation((XYAnnotation)annotation);
        }
        TraceHelper.exit(this, "createTextMarkers");
    }
}

