/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.export;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Locale;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.export.VNAExporter;
import krause.vna.gui.VNAMainFrame;
import krause.vna.resources.VNAMessages;

public class SnPExporter
extends VNAExporter {
    public SnPExporter(VNAMainFrame mainFrame) {
        super(mainFrame);
    }

    @Override
    public String export(String fnp, boolean overwrite) throws ProcessingException {
        TraceHelper.entry((Object)this, "export", fnp);
        String currFilename = "not saved";
        if (this.datapool.getScanMode().isTransmissionMode()) {
            currFilename = this.exportS2P(fnp, overwrite);
        } else if (this.datapool.getScanMode().isReflectionMode()) {
            currFilename = this.exportS1P(fnp, overwrite);
        } else if (this.datapool.getScanMode().isRss1Mode()) {
            currFilename = this.exportS2P(fnp, overwrite);
        }
        TraceHelper.exit(this, "export");
        return currFilename;
    }

    private String exportS1P(String fnp, boolean overwrite) throws ProcessingException {
        TraceHelper.entry(this, "exportS1P");
        String currFilename = "not saved";
        VNACalibratedSampleBlock blk = this.datapool.getCalibratedData();
        VNACalibratedSample[] samples = blk.getCalibratedSamples();
        currFilename = this.check4FileToDelete(fnp, overwrite);
        if (currFilename != null) {
            DecimalFormatSymbols dfs = this.getDecimalFormatSymbols();
            DecimalFormat fmtFrequency = new DecimalFormat("000000000", dfs);
            DecimalFormat fmtLoss = new DecimalFormat("0.00000000", dfs);
            DecimalFormat fmtPhase = new DecimalFormat("0.00000000", dfs);
            try {
                FileOutputStream fos = new FileOutputStream(currFilename);
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "ISO-8859-1"));
                w.write("! created by ");
                w.write(System.getProperty("user.name"));
                w.write(" at ");
                w.write(new Date().toString());
                w.write(System.getProperty("line.separator"));
                w.write("! generated using vna/J Version ");
                w.write(VNAMessages.getString("Application.version"));
                w.write(System.getProperty("line.separator"));
                String resistance = "" + (int)this.datapool.getDriver().getDeviceInfoBlock().getReferenceResistance().getReal();
                w.write("# Hz S DB R " + resistance);
                w.write(System.getProperty("line.separator"));
                int i = 0;
                while (i < samples.length) {
                    VNACalibratedSample data = samples[i];
                    w.write(fmtFrequency.format(data.getFrequency()));
                    w.write(" ");
                    w.write(fmtLoss.format(data.getReflectionLoss()));
                    w.write(" ");
                    w.write(fmtPhase.format(data.getReflectionPhase()));
                    w.write(System.getProperty("line.separator"));
                    ++i;
                }
                ((Writer)w).flush();
                ((Writer)w).close();
                fos.close();
            }
            catch (IOException e) {
                ErrorLogHelper.exception(this, "exportS1P", e);
                throw new ProcessingException(e);
            }
        }
        TraceHelper.exitWithRC((Object)this, "exportS1P", currFilename);
        return currFilename;
    }

    private DecimalFormatSymbols getDecimalFormatSymbols() {
        if (".".equals(this.config.getExportDecimalSeparator())) {
            return new DecimalFormatSymbols(Locale.ENGLISH);
        }
        return new DecimalFormatSymbols(Locale.GERMAN);
    }

    private String exportS2P(String fnp, boolean overwrite) throws ProcessingException {
        TraceHelper.entry(this, "exportS2P");
        String currFilename = "not saved";
        VNACalibratedSampleBlock blk = this.datapool.getCalibratedData();
        VNACalibratedSample[] samples = blk.getCalibratedSamples();
        currFilename = this.check4FileToDelete(fnp, overwrite);
        if (currFilename != null) {
            DecimalFormatSymbols dfs = this.getDecimalFormatSymbols();
            DecimalFormat fmtFrequency = new DecimalFormat("000000000", dfs);
            DecimalFormat fmtLoss = new DecimalFormat("0.00000000", dfs);
            DecimalFormat fmtPhase = new DecimalFormat("0.00000000", dfs);
            try {
                FileOutputStream fos = new FileOutputStream(currFilename);
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "ISO-8859-1"));
                w.write("! created by ");
                w.write(System.getProperty("user.name"));
                w.write(" at ");
                w.write(new Date().toString());
                w.write(System.getProperty("line.separator"));
                w.write("! generated using vna/J Version ");
                w.write(VNAMessages.getString("Application.version"));
                w.write(System.getProperty("line.separator"));
                w.write("# Hz S DB R 50");
                w.write(System.getProperty("line.separator"));
                int i = 0;
                while (i < samples.length) {
                    VNACalibratedSample data = samples[i];
                    w.write(fmtFrequency.format(data.getFrequency()));
                    w.write(" ");
                    w.write(fmtLoss.format(data.getReflectionLoss()));
                    w.write(" ");
                    w.write(fmtPhase.format(data.getReflectionPhase()));
                    w.write(" ");
                    w.write(fmtLoss.format(data.getTransmissionLoss()));
                    w.write(" ");
                    w.write(fmtPhase.format(data.getTransmissionPhase()));
                    w.write(" ");
                    w.write(fmtLoss.format(0L));
                    w.write(" ");
                    w.write(fmtPhase.format(0L));
                    w.write(" ");
                    w.write(fmtLoss.format(0L));
                    w.write(" ");
                    w.write(fmtPhase.format(0L));
                    w.write(" ");
                    w.write(System.getProperty("line.separator"));
                    ++i;
                }
                ((Writer)w).flush();
                ((Writer)w).close();
                fos.close();
            }
            catch (IOException e) {
                ErrorLogHelper.exception(this, "exportS2P", e);
                throw new ProcessingException(e);
            }
        }
        TraceHelper.exitWithRC((Object)this, "exportS2P", currFilename);
        return currFilename;
    }

    @Override
    public String getExtension() {
        if (this.datapool.getScanMode().isTransmissionMode()) {
            return ".s2p";
        }
        if (this.datapool.getScanMode().isReflectionMode()) {
            return ".s1p";
        }
        if (this.datapool.getScanMode().isRss1Mode()) {
            return ".s2p";
        }
        return ".xxx";
    }
}

