/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.export;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class SWRLogarithmicAxis
extends LogarithmicAxis {
    public SWRLogarithmicAxis(String string) {
        super(string);
    }

    protected List<NumberTick> refreshTicksVertical(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        int iEndCount;
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        double lowerBoundVal = this.getRange().getLowerBound();
        if (this.smallLogFlag && lowerBoundVal < 1.0E-100) {
            lowerBoundVal = 1.0E-100;
        }
        double upperBoundVal = this.getRange().getUpperBound();
        int iBegCount = (int)Math.rint(this.switchedLog10(lowerBoundVal));
        if (iBegCount == (iEndCount = (int)Math.ceil(this.switchedLog10(upperBoundVal))) && iBegCount > 0 && Math.pow(10.0, iBegCount) > lowerBoundVal) {
            --iBegCount;
        }
        boolean zeroTickFlag = false;
        int i = iBegCount;
        while (i <= iEndCount) {
            int jEndCount = 10;
            if (i == iEndCount) {
                jEndCount = 1;
            }
            int j = 0;
            while (j < jEndCount) {
                NumberFormat format;
                String tickLabel;
                double tickVal;
                if (this.smallLogFlag) {
                    tickVal = Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j;
                    if (j == 0) {
                        if (this.log10TickLabelsFlag) {
                            tickLabel = "10^" + i;
                        } else if (this.expTickLabelsFlag) {
                            tickLabel = "1e" + i;
                        } else if (i >= 0) {
                            format = this.getNumberFormatOverride();
                            tickLabel = format != null ? format.format(tickVal) : Long.toString((long)Math.rint(tickVal));
                        } else {
                            this.numberFormatterObj.setMaximumFractionDigits(-i);
                            tickLabel = this.numberFormatterObj.format(tickVal);
                        }
                    } else {
                        format = this.getNumberFormatOverride();
                        tickLabel = format != null ? format.format(tickVal) : Long.toString((long)Math.rint(tickVal));
                    }
                } else {
                    if (zeroTickFlag) {
                        --j;
                    }
                    double d = tickVal = i >= 0 ? Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j : -(Math.pow(10.0, -i) - Math.pow(10.0, -i - 1) * (double)j);
                    if (j == 0) {
                        if (!zeroTickFlag) {
                            if (i > iBegCount && i < iEndCount && Math.abs(tickVal - 1.0) < 1.0E-4) {
                                tickVal = 0.0;
                                zeroTickFlag = true;
                                tickLabel = "0";
                            } else {
                                tickLabel = this.log10TickLabelsFlag ? String.valueOf(i < 0 ? "-" : "") + "10^" + Math.abs(i) : (this.expTickLabelsFlag ? String.valueOf(i < 0 ? "-" : "") + "1e" + Math.abs(i) : ((format = this.getNumberFormatOverride()) != null ? format.format(tickVal) : Long.toString((long)Math.rint(tickVal))));
                            }
                        } else {
                            tickLabel = "";
                            zeroTickFlag = false;
                        }
                    } else {
                        tickLabel = "";
                        zeroTickFlag = false;
                    }
                }
                if (tickVal > upperBoundVal) {
                    return ticks;
                }
                if (tickVal >= lowerBoundVal - 1.0E-100) {
                    TextAnchor anchor = null;
                    TextAnchor rotationAnchor = null;
                    double angle = 0.0;
                    if (this.isVerticalTickLabels()) {
                        if (edge == RectangleEdge.LEFT) {
                            anchor = TextAnchor.BOTTOM_CENTER;
                            rotationAnchor = TextAnchor.BOTTOM_CENTER;
                            angle = -1.5707963267948966;
                        } else {
                            anchor = TextAnchor.BOTTOM_CENTER;
                            rotationAnchor = TextAnchor.BOTTOM_CENTER;
                            angle = 1.5707963267948966;
                        }
                    } else if (edge == RectangleEdge.LEFT) {
                        anchor = TextAnchor.CENTER_RIGHT;
                        rotationAnchor = TextAnchor.CENTER_RIGHT;
                    } else {
                        anchor = TextAnchor.CENTER_LEFT;
                        rotationAnchor = TextAnchor.CENTER_LEFT;
                    }
                    ticks.add(new NumberTick((Number)new Double(tickVal), tickLabel, anchor, rotationAnchor, angle));
                }
                ++j;
            }
            ++i;
        }
        return ticks;
    }
}

