/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.export;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.export.VNAExporter;
import krause.vna.gui.VNAMainFrame;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class JpegExporter
extends VNAExporter {
    public JpegExporter(VNAMainFrame mainFrame) {
        super(mainFrame);
    }

    private void writeChart2JPEG(JFreeChart aChart, String aFileName, int aWidth, int aHeight) throws FileNotFoundException, IOException {
        TraceHelper.entry(this, "createChart");
        FileOutputStream fos = new FileOutputStream(aFileName);
        ChartUtilities.writeChartAsJPEG((OutputStream)fos, (JFreeChart)aChart, (int)aWidth, (int)aHeight);
        fos.close();
        TraceHelper.exit(this, "createChart");
    }

    @Override
    public String export(String fnp, boolean overwrite) throws ProcessingException {
        TraceHelper.entry((Object)this, "export", fnp);
        String currFilename = "not saved";
        VNACalibratedSampleBlock blk = this.datapool.getCalibratedData();
        VNACalibratedSample[] samples = blk.getCalibratedSamples();
        try {
            currFilename = this.check4FileToDelete(fnp, overwrite);
            if (currFilename != null) {
                JFreeChart chart = this.createChart(samples);
                this.writeChart2JPEG(chart, currFilename, this.config.getExportDiagramWidth(), this.config.getExportDiagramHeight());
            }
        }
        catch (IOException e) {
            ErrorLogHelper.exception(this, "export", e);
            throw new ProcessingException(e);
        }
        TraceHelper.exit(this, "export");
        return currFilename;
    }

    @Override
    public String getExtension() {
        return ".jpg";
    }
}

