/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.export;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.export.VNAExporter;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.format.VNAFormatFactory;

public class CSVExporter
extends VNAExporter {
    public CSVExporter(VNAMainFrame mainFrame) {
        super(mainFrame);
    }

    @Override
    public String export(String fnp, boolean overwrite) throws ProcessingException {
        TraceHelper.entry((Object)this, "export", fnp);
        String currFilename = "not saved";
        VNACalibratedSampleBlock blk = this.datapool.getCalibratedData();
        VNACalibratedSample[] samples = blk.getCalibratedSamples();
        currFilename = this.check4FileToDelete(fnp, overwrite);
        if (currFilename != null) {
            DecimalFormat df = new DecimalFormat();
            char decSep = df.getDecimalFormatSymbols().getDecimalSeparator();
            int valSep = 44;
            if (decSep == ',') {
                valSep = 59;
            } else if (decSep == ';') {
                valSep = 44;
            }
            try {
                FileOutputStream fos = new FileOutputStream(currFilename);
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "Cp850"));
                w.write("Frequency(Hz)");
                ((Writer)w).write(valSep);
                boolean isTransmissionMode = this.datapool.getScanMode().isTransmissionMode();
                if (isTransmissionMode) {
                    w.write("Transmission Loss(dB)");
                } else {
                    w.write("Return Loss(dB)");
                }
                ((Writer)w).write(valSep);
                w.write("Phase(deg)");
                ((Writer)w).write(valSep);
                w.write("Rs");
                ((Writer)w).write(valSep);
                w.write("SWR");
                ((Writer)w).write(valSep);
                w.write("Xs");
                ((Writer)w).write(valSep);
                w.write("|Z|");
                ((Writer)w).write(valSep);
                w.write("Theta");
                w.write(System.getProperty("line.separator"));
                int i = 0;
                while (i < samples.length) {
                    VNACalibratedSample data = samples[i];
                    w.write(VNAFormatFactory.getFrequencyFormat4Export().format(data.getFrequency()));
                    ((Writer)w).write(valSep);
                    if (isTransmissionMode) {
                        w.write(VNAFormatFactory.getReflectionLossFormat().format(data.getTransmissionLoss()));
                        ((Writer)w).write(valSep);
                        w.write(VNAFormatFactory.getPhaseFormat().format(data.getTransmissionPhase()));
                        ((Writer)w).write(valSep);
                    } else {
                        w.write(VNAFormatFactory.getReflectionLossFormat().format(data.getReflectionLoss()));
                        ((Writer)w).write(valSep);
                        w.write(VNAFormatFactory.getPhaseFormat().format(data.getReflectionPhase()));
                        ((Writer)w).write(valSep);
                    }
                    w.write(VNAFormatFactory.getRsFormat().format(data.getR()));
                    ((Writer)w).write(valSep);
                    w.write(VNAFormatFactory.getSwrFormat().format(data.getSWR()));
                    ((Writer)w).write(valSep);
                    w.write(VNAFormatFactory.getXsFormat().format(data.getX()));
                    ((Writer)w).write(valSep);
                    w.write(VNAFormatFactory.getZFormat().format(data.getZ()));
                    ((Writer)w).write(valSep);
                    w.write(VNAFormatFactory.getZFormat().format(data.getTheta()));
                    w.write(System.getProperty("line.separator"));
                    ++i;
                }
                ((Writer)w).flush();
                ((Writer)w).close();
                fos.close();
            }
            catch (IOException e) {
                ErrorLogHelper.exception(CSVExporter.class, "doExportCSV", e);
                throw new ProcessingException(e);
            }
        }
        TraceHelper.exit(CSVExporter.class, "doExportCSV");
        return currFilename;
    }

    @Override
    public String getExtension() {
        return ".csv";
    }
}

