/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.tiny.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import krause.common.validation.DoubleValidator;
import krause.common.validation.IntegerValidator;
import krause.common.validation.LongValidator;
import krause.common.validation.ValidationResults;
import krause.common.validation.ValidationResultsDialog;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.VNABackgroundJob;
import krause.vna.background.VnaBackgroundTask;
import krause.vna.config.VNAConfig;
import krause.vna.data.IVNADataConsumer;
import krause.vna.data.VNADataPool;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.calibrated.VNACalibrationContext;
import krause.vna.data.helper.VNACalibrationBlockHelper;
import krause.vna.data.helper.VNASampleBlockHelper;
import krause.vna.device.IVNADriver;
import krause.vna.device.IVNADriverMathHelper;
import krause.vna.device.VNADriverDialog;
import krause.vna.device.VNAScanRange;
import krause.vna.device.serial.tiny.VNADriverSerialTiny;
import krause.vna.device.serial.tiny.VNADriverSerialTinyDIB;
import krause.vna.device.serial.tiny.VNADriverSerialTinyMessages;
import krause.vna.device.serial.tiny.gui.Tuple;
import krause.vna.gui.HelpButton;
import krause.vna.gui.StatusBarLabel;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.gui.input.ComplexInputField;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.math.complex.Complex;

public class VNADriverSerialTinyDialog
extends VNADriverDialog
implements IVNADataConsumer {
    private static final int AUTOCAL_NUM_SAMPLES = 800;
    private static final long AUTOCAL_START_FREQ = 100000000L;
    private static final long AUTOCAL_STOP_FREQ = 200000000L;
    private static final int AUTOCAL_NUM_OVERSAMPLES = 4;
    private static final int MAX_BOOTBAUD = 921600;
    private static final int MIN_BOOTBAUD = 19200;
    private static final double MAX_CORR_GAIN = 1.15;
    private static final double MAX_CORR_IF_PHASE = 10.0;
    private static final double MAX_CORR_PHASE = 10.0;
    private static final double MAX_CORR_TEMP = 0.1;
    private static final double MIN_CORR_GAIN = 0.85;
    private static final double MIN_CORR_IF_PHASE = -10.0;
    private static final double MIN_CORR_PHASE = -10.0;
    private static final double MIN_CORR_TEMP = -0.1;
    private static final double STEP_GAIN = 0.005999999999999998;
    private static final double STEP_PHASE = 0.1;
    private final VNAConfig config = VNAConfig.getSingleton();
    private final VNADataPool datapool = VNADataPool.getSingleton();
    private final VNADriverSerialTinyDIB dib;
    private final VNADriverSerialTiny driver;
    private JButton btCal;
    private JButton btCancel;
    private JButton btOK;
    private JButton btDefault;
    private JLabel lblPhaseMax;
    private JLabel lblPhaseMin;
    private JLabel lblReference;
    private StatusBarLabel lblStatusbar;
    private JPanel panel;
    private ComplexInputField referenceValue;
    private JTextField txtBootloaderBaudRate;
    private JTextField txtFirmware;
    private JTextField txtFreqMax;
    private JTextField txtFreqMin;
    private JTextField txtGainCorrection;
    private JTextField txtIFPhaseCorrection;
    private JTextField txtLossMax;
    private JTextField txtLossMin;
    private JTextField txtPhaseCorrection;
    private JTextField txtPhaseMax;
    private JTextField txtPhaseMin;
    private JTextField txtPower;
    private JTextField txtSteps;
    private JTextField txtTempCorrection;
    private JTextField txtTemperature;
    private JCheckBox cbPeakSuppression;

    public VNADriverSerialTinyDialog(VNAMainFrame pMainFrame, IVNADriver pDriver) {
        super(pMainFrame.getJFrame(), pMainFrame);
        TraceHelper.entry(this, "VNADriverSerialTinyDialog");
        this.driver = (VNADriverSerialTiny)pDriver;
        this.dib = (VNADriverSerialTinyDIB)this.driver.getDeviceInfoBlock();
        this.setTitle(VNADriverSerialTinyMessages.getString("drvTitle"));
        this.setDefaultCloseOperation(0);
        this.setProperties(this.config);
        this.setConfigurationPrefix("VNADriverSerialTinyDialog");
        this.setPreferredSize(new Dimension(540, 540));
        this.panel = new JPanel();
        this.getContentPane().add((Component)this.panel, "Center");
        this.panel.setLayout((LayoutManager)new MigLayout("", "[grow][][]", ""));
        this.panel.add((Component)new JLabel(), "");
        this.lblPhaseMax = new JLabel(VNADriverSerialTinyMessages.getString("lblMin"));
        this.panel.add((Component)this.lblPhaseMax, "");
        JLabel lblLossMax = new JLabel(VNADriverSerialTinyMessages.getString("lblMax"));
        this.panel.add((Component)lblLossMax, "wrap");
        JLabel lblLossMin = new JLabel(VNADriverSerialTinyMessages.getString("lblLoss"));
        this.panel.add((Component)lblLossMin, "");
        this.txtLossMin = new JTextField();
        this.txtLossMin.setEditable(false);
        this.txtLossMin.setHorizontalAlignment(4);
        this.txtLossMin.setColumns(10);
        this.panel.add((Component)this.txtLossMin, "");
        this.txtLossMax = new JTextField();
        this.txtLossMax.setEditable(false);
        this.txtLossMax.setHorizontalAlignment(4);
        this.txtLossMax.setColumns(10);
        this.panel.add((Component)this.txtLossMax, "wrap");
        lblLossMin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VNADriverSerialTinyDialog.this.txtLossMin.setEditable(true);
                VNADriverSerialTinyDialog.this.txtLossMax.setEditable(true);
            }
        });
        this.lblPhaseMin = new JLabel(VNADriverSerialTinyMessages.getString("lblPhase"));
        this.panel.add((Component)this.lblPhaseMin, "");
        this.txtPhaseMin = new JTextField();
        this.txtPhaseMin.setEditable(false);
        this.txtPhaseMin.setHorizontalAlignment(4);
        this.txtPhaseMin.setColumns(10);
        this.panel.add((Component)this.txtPhaseMin, "");
        this.txtPhaseMax = new JTextField();
        this.txtPhaseMax.setEditable(false);
        this.txtPhaseMax.setHorizontalAlignment(4);
        this.txtPhaseMax.setColumns(10);
        this.panel.add((Component)this.txtPhaseMax, "wrap");
        JLabel lblFreqMin = new JLabel(VNADriverSerialTinyMessages.getString("lblFreq"));
        lblFreqMin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VNADriverSerialTinyDialog.this.txtFreqMin.setEditable(true);
                VNADriverSerialTinyDialog.this.txtFreqMax.setEditable(true);
            }
        });
        this.panel.add((Component)lblFreqMin, "");
        this.txtFreqMin = new JTextField();
        this.txtFreqMin.setEditable(false);
        this.txtFreqMin.setHorizontalAlignment(4);
        this.txtFreqMin.setColumns(10);
        this.panel.add((Component)this.txtFreqMin, "");
        this.txtFreqMax = new JTextField();
        this.txtFreqMax.setEditable(false);
        this.txtFreqMax.setHorizontalAlignment(4);
        this.txtFreqMax.setColumns(10);
        this.panel.add((Component)this.txtFreqMax, "wrap");
        JLabel lblNoOfSteps = new JLabel(VNADriverSerialTinyMessages.getString("lblNoOfSteps"));
        this.panel.add((Component)lblNoOfSteps, "");
        this.txtSteps = new JTextField();
        this.txtSteps.setHorizontalAlignment(4);
        this.txtSteps.setColumns(10);
        this.panel.add((Component)this.txtSteps, "wrap");
        JLabel lblFirmware = new JLabel(VNADriverSerialTinyMessages.getString("lblFirmware"));
        this.panel.add((Component)lblFirmware, "");
        this.txtFirmware = new JTextField();
        this.txtFirmware.setEditable(false);
        this.panel.add((Component)this.txtFirmware, "grow,span 3,wrap");
        JLabel lblPower = new JLabel(VNADriverSerialTinyMessages.getString("lblPower"));
        this.panel.add((Component)lblPower, "");
        this.txtPower = new JTextField();
        this.txtPower.setEditable(false);
        this.panel.add((Component)this.txtPower, "grow,span 3,wrap");
        JLabel lblTemp = new JLabel(VNADriverSerialTinyMessages.getString("lblTemperature"));
        this.panel.add((Component)lblTemp, "");
        this.txtTemperature = new JTextField();
        this.txtTemperature.setEditable(false);
        this.panel.add((Component)this.txtTemperature, "grow,span 3,wrap");
        this.lblReference = new JLabel(VNADriverSerialTinyMessages.getString("lblReference"));
        this.lblReference.setBounds(10, 330, 141, 30);
        this.panel.add((Component)this.lblReference, "");
        this.referenceValue = new ComplexInputField(null);
        this.referenceValue.setMaximum(new Complex(5000.0, 5000.0));
        this.referenceValue.setMinimum(new Complex(-5000.0, -5000.0));
        FlowLayout flowLayout = (FlowLayout)this.referenceValue.getLayout();
        flowLayout.setAlignment(0);
        this.panel.add((Component)this.referenceValue, "grow,span 3,wrap");
        this.panel.add(new JLabel(MessageFormat.format(VNADriverSerialTinyMessages.getString("lblPhaseCorr"), -10.0, 10.0)));
        this.txtPhaseCorrection = new JTextField();
        this.txtPhaseCorrection.setText("0");
        this.txtPhaseCorrection.setHorizontalAlignment(4);
        this.txtPhaseCorrection.setColumns(10);
        this.panel.add((Component)this.txtPhaseCorrection, "wrap");
        this.panel.add(new JLabel(MessageFormat.format(VNADriverSerialTinyMessages.getString("lblIFPhaseCorr"), -10.0, 10.0)));
        this.txtIFPhaseCorrection = new JTextField();
        this.txtIFPhaseCorrection.setText("0");
        this.txtIFPhaseCorrection.setHorizontalAlignment(4);
        this.txtIFPhaseCorrection.setColumns(10);
        this.panel.add((Component)this.txtIFPhaseCorrection, "wrap");
        this.panel.add(new JLabel(MessageFormat.format(VNADriverSerialTinyMessages.getString("lblGainCorr"), 0.85, 1.15)));
        this.txtGainCorrection = new JTextField();
        this.txtGainCorrection.setText("0");
        this.txtGainCorrection.setHorizontalAlignment(4);
        this.txtGainCorrection.setColumns(10);
        this.panel.add((Component)this.txtGainCorrection, "wrap");
        this.panel.add(new JLabel(MessageFormat.format(VNADriverSerialTinyMessages.getString("lblTempCorr"), -0.1, 0.1)));
        this.txtTempCorrection = new JTextField();
        this.txtTempCorrection.setText("0");
        this.txtTempCorrection.setHorizontalAlignment(4);
        this.txtTempCorrection.setColumns(10);
        this.panel.add((Component)this.txtTempCorrection, "wrap");
        this.panel.add(new JLabel(MessageFormat.format(VNADriverSerialTinyMessages.getString("lblBootloaderBaudRate"), 19200, 921600)));
        this.txtBootloaderBaudRate = new JTextField();
        this.txtBootloaderBaudRate.setText("0");
        this.txtBootloaderBaudRate.setHorizontalAlignment(4);
        this.txtBootloaderBaudRate.setColumns(10);
        this.panel.add((Component)this.txtBootloaderBaudRate, "wrap");
        this.panel.add(new JLabel(""));
        this.cbPeakSuppression = new JCheckBox(VNADriverSerialTinyMessages.getString("lblPeakSuppression"));
        this.panel.add((Component)this.cbPeakSuppression, "grow, span2, wrap");
        this.btCancel = SwingUtil.createJButton("Button.Cancel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNADriverSerialTinyDialog.this.doCANCEL();
            }
        });
        this.btCal = SwingUtil.createJButton("Button.AutoCalibrate", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNADriverSerialTinyDialog.this.doCalibrate();
            }
        });
        this.btDefault = SwingUtil.createJButton("Button.Default", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNADriverSerialTinyDialog.this.doReset();
            }
        });
        this.btOK = SwingUtil.createJButton("Button.OK", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNADriverSerialTinyDialog.this.doOK();
            }
        });
        this.panel.add((Component)this.btCal, "wmin 100px");
        this.panel.add((Component)this.btDefault, "wmin 100px, wrap");
        this.panel.add((Component)new HelpButton(this, "VNADriverSerialTinyDialog"), "wmin 100px");
        this.panel.add((Component)this.btCancel, "wmin 100px");
        this.panel.add((Component)this.btOK, "wmin 100px,wrap");
        this.lblStatusbar = new StatusBarLabel("Ready", 1000);
        this.lblStatusbar.setBackground(Color.GREEN);
        this.panel.add((Component)this.lblStatusbar, "span 3,grow,wrap");
        this.getRootPane().setDefaultButton(this.btOK);
        this.doInit();
        TraceHelper.exit(this, "VNADriverSerialTinyDialog");
    }

    protected void autoCalOnMagnitude(VNASampleBlock rawData) {
        TraceHelper.entry(this, "autoCalOnMagnitude");
        double minMagnitudeGain = Double.MAX_VALUE;
        double minMagnitudePhase = Double.MAX_VALUE;
        double minDiffMagnitude = Double.MAX_VALUE;
        double curPhase = -10.0;
        while (curPhase < 10.0) {
            double curGain = 0.85;
            while (curGain < 1.15) {
                TraceHelper.text(this, "autoCalOnMagnitude", "p=" + curPhase + " g=" + curGain);
                this.dib.setGainCorrection(curGain);
                this.dib.setPhaseCorrection(curPhase);
                Tuple[] transformedData = this.transformData(rawData);
                double minMagnitude = Double.MAX_VALUE;
                double maxMagnitude = Double.MIN_VALUE;
                Tuple[] tupleArray = transformedData;
                int n = transformedData.length;
                int n2 = 0;
                while (n2 < n) {
                    Tuple data = tupleArray[n2];
                    double mag = data.getVal();
                    if (mag < minMagnitude) {
                        minMagnitude = mag;
                    }
                    if (mag > maxMagnitude) {
                        maxMagnitude = mag;
                    }
                    ++n2;
                }
                double diffMagnitude = maxMagnitude - minMagnitude;
                if (diffMagnitude < minDiffMagnitude) {
                    minDiffMagnitude = diffMagnitude;
                    minMagnitudeGain = curGain;
                    minMagnitudePhase = curPhase;
                }
                curGain += 0.005999999999999998;
            }
            curPhase += 0.1;
        }
        TraceHelper.text(this, "doAutoCal", "minMagnitude     =" + minDiffMagnitude);
        TraceHelper.text(this, "doAutoCal", "minMagnitudeGain =" + minMagnitudeGain);
        TraceHelper.text(this, "doAutoCal", "minMagnitudePhase=" + minMagnitudePhase);
        this.dib.setGainCorrection(minMagnitudeGain);
        this.dib.setPhaseCorrection(minMagnitudePhase);
        TraceHelper.exit(this, "autoCalOnMagnitude");
    }

    @Override
    public void consumeDataBlock(List<VNABackgroundJob> jobs) {
        TraceHelper.entry(this, "consumeDataBlock");
        Object[] options = new Object[]{VNAMessages.getString("Button.Continue"), VNAMessages.getString("Button.Cancel")};
        this.lblStatusbar.setText(VNADriverSerialTinyMessages.getString("msgExecAutocal"));
        int n = JOptionPane.showOptionDialog(this, VNADriverSerialTinyMessages.getString("msgCalculate"), VNADriverSerialTinyMessages.getString("calTitle"), 0, 3, null, options, options[0]);
        if (n == 0) {
            VNASampleBlock rawScanData = null;
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (jobs.size() > 1) {
                ArrayList<VNASampleBlock> blocks = new ArrayList<VNASampleBlock>();
                for (VNABackgroundJob job : jobs) {
                    blocks.add(job.getResult());
                }
                rawScanData = VNASampleBlockHelper.calculateAverageSampleBlock(blocks);
            } else if (jobs.size() == 1) {
                rawScanData = jobs.get(0).getResult();
            }
            try {
                this.lblStatusbar.setText(VNADriverSerialTinyMessages.getString("msgCalcDone"));
                this.autoCalOnMagnitude(rawScanData);
            }
            catch (Exception e) {
                ErrorLogHelper.exception(this, "consumeDataBlock", e);
            }
            JOptionPane.showMessageDialog(this, VNADriverSerialTinyMessages.getString("msgFinish"), VNADriverSerialTinyMessages.getString("calTitle"), 1, null);
            this.txtPhaseCorrection.setText(VNAFormatFactory.getGainFormat().format(this.dib.getPhaseCorrection()));
            this.txtGainCorrection.setText(VNAFormatFactory.getGainFormat().format(this.dib.getGainCorrection()));
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.btCancel.setEnabled(true);
        this.btDefault.setEnabled(true);
        this.btCal.setEnabled(true);
        this.btOK.setEnabled(true);
        TraceHelper.exit(this, "consumeDataBlock");
    }

    protected void doCalibrate() {
        Object[] options = new Object[]{VNAMessages.getString("Button.Continue"), VNAMessages.getString("Button.Cancel")};
        int n = JOptionPane.showOptionDialog(this, VNADriverSerialTinyMessages.getString("msgExit"), VNADriverSerialTinyMessages.getString("calTitle"), 0, 3, null, options, options[0]);
        if (n == 0) {
            this.btCancel.setEnabled(false);
            this.btDefault.setEnabled(false);
            this.btOK.setEnabled(false);
            this.btCal.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            VNAScanRange range = new VNAScanRange(100000000L, 200000000L, 800);
            VnaBackgroundTask backgroundTask = new VnaBackgroundTask(this.datapool.getDriver());
            backgroundTask.addDataConsumer(this);
            backgroundTask.setStatusLabel(this.lblStatusbar);
            int i = 0;
            while (i < 4) {
                VNABackgroundJob job = new VNABackgroundJob();
                job.setSpeedup(1);
                job.setNumberOfSamples(800);
                job.setFrequencyRange(range);
                job.setScanMode(VNAScanMode.MODE_REFLECTION);
                backgroundTask.addJob(job);
                ++i;
            }
            backgroundTask.execute();
        }
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.setVisible(false);
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.updateFieldsFromDIB();
        this.txtTemperature.setText(VNAFormatFactory.getResistanceBaseFormat().format(this.driver.getDeviceTemperature()));
        this.txtFirmware.setText(this.driver.getDeviceFirmwareInfo());
        this.txtPower.setText(VNAFormatFactory.getResistanceBaseFormat().format(this.driver.getDeviceSupply()));
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    protected void doOK() {
        TraceHelper.entry(this, "doOK");
        ValidationResults results = new ValidationResults();
        int steps = IntegerValidator.parse(this.txtSteps.getText(), 200, 25000, VNADriverSerialTinyMessages.getString("lblNoOfSteps"), results);
        long minFreq = LongValidator.parse(this.txtFreqMin.getText(), 1L, 999999999999L, VNADriverSerialTinyMessages.getString("lblFreq"), results);
        long maxFreq = LongValidator.parse(this.txtFreqMax.getText(), 1L, 999999999999L, VNADriverSerialTinyMessages.getString("lblFreq"), results);
        double minLoss = DoubleValidator.parse(this.txtLossMin.getText(), -200.0, 200.0, VNADriverSerialTinyMessages.getString("lblLoss"), results);
        double maxLoss = DoubleValidator.parse(this.txtLossMax.getText(), -200.0, 200.0, VNADriverSerialTinyMessages.getString("lblLoss"), results);
        double phaseCorrection = DoubleValidator.parse(this.txtPhaseCorrection.getText(), -10.0, 10.0, VNADriverSerialTinyMessages.getString("lblPhaseCorr"), results);
        double ifPhaseCorrection = DoubleValidator.parse(this.txtIFPhaseCorrection.getText(), -10.0, 10.0, VNADriverSerialTinyMessages.getString("lblIFPhaseCorr"), results);
        double gainCorrection = DoubleValidator.parse(this.txtGainCorrection.getText(), 0.85, 1.15, VNADriverSerialTinyMessages.getString("lblGainCorr"), results);
        double tempCorrection = DoubleValidator.parse(this.txtTempCorrection.getText(), -0.1, 0.1, VNADriverSerialTinyMessages.getString("lblTempCorr"), results);
        int blBaud = IntegerValidator.parse(this.txtBootloaderBaudRate.getText(), 19200, 921600, VNADriverSerialTinyMessages.getString("lblBootloaderBaudRate"), results);
        boolean peakSupp = this.cbPeakSuppression.isSelected();
        if (results.isEmpty()) {
            steps = steps / 100 * 100;
            this.dib.setNumberOfSamples(steps);
            this.dib.setReferenceResistance(this.referenceValue.getComplexValue());
            this.dib.setMinFrequency(minFreq);
            this.dib.setMaxFrequency(maxFreq);
            this.dib.setPhaseCorrection(phaseCorrection);
            this.dib.setIfPhaseCorrection(ifPhaseCorrection);
            this.dib.setGainCorrection(gainCorrection);
            this.dib.setTempCorrection(tempCorrection);
            this.dib.setBootloaderBaudrate(blBaud);
            this.dib.setPeakSuppression(peakSupp);
            this.dib.setMinLoss(minLoss);
            this.dib.setMaxLoss(maxLoss);
            this.dib.store(this.config, this.driver.getDriverConfigPrefix());
            IVNADriverMathHelper mathHelper = this.datapool.getDriver().getMathHelper();
            VNACalibrationBlock mcb = this.datapool.getMainCalibrationBlock();
            mathHelper.createCalibrationPoints(mathHelper.createCalibrationContextForCalibrationPoints(mcb), mcb);
            this.datapool.clearResizedCalibrationBlock();
            this.datapool.clearCalibratedData();
            this.setVisible(false);
        } else {
            new ValidationResultsDialog(this.getOwner(), results, this.getTitle());
        }
        TraceHelper.exit(this, "doOK");
    }

    private void doReset() {
        TraceHelper.entry(this, "doReset");
        this.dib.reset();
        this.updateFieldsFromDIB();
        TraceHelper.exit(this, "doReset");
    }

    private Tuple[] transformData(VNASampleBlock rawScanData) {
        IVNADriverMathHelper mathHelper = this.datapool.getDriver().getMathHelper();
        VNACalibrationBlock mcb = this.datapool.getMainCalibrationBlock();
        VNACalibrationContext ctxCalPoints = mathHelper.createCalibrationContextForCalibrationPoints(mcb);
        mathHelper.createCalibrationPoints(ctxCalPoints, mcb);
        VNACalibrationBlock resizedCalibrationBlock = VNACalibrationBlockHelper.createResizedCalibrationBlock(mcb, 100000000L, 200000000L, 800);
        VNACalibrationContext ctxCalSamples = mathHelper.createCalibrationContextForCalibratedSamples(resizedCalibrationBlock);
        VNACalibratedSampleBlock calibratedData = mathHelper.createCalibratedSamples(ctxCalSamples, rawScanData);
        Tuple[] rc = new Tuple[calibratedData.getCalibratedSamples().length];
        int i = 0;
        while (i < rc.length) {
            VNACalibratedSample data = calibratedData.getCalibratedSamples()[i];
            Tuple at = new Tuple();
            at.setFrq(data.getFrequency());
            at.setVal(data.getMag());
            rc[i] = at;
            ++i;
        }
        return rc;
    }

    private void updateFieldsFromDIB() {
        this.txtFreqMax.setText(VNAFormatFactory.getFrequencyFormat().format(this.dib.getMaxFrequency()));
        this.txtFreqMin.setText(VNAFormatFactory.getFrequencyFormat().format(this.dib.getMinFrequency()));
        this.txtLossMax.setText(VNAFormatFactory.getReflectionLossFormat().format(this.dib.getMaxLoss()));
        this.txtLossMin.setText(VNAFormatFactory.getReflectionLossFormat().format(this.dib.getMinLoss()));
        this.txtPhaseMax.setText(VNAFormatFactory.getPhaseFormat().format(this.dib.getMaxPhase()));
        this.txtPhaseMin.setText(VNAFormatFactory.getPhaseFormat().format(this.dib.getMinPhase()));
        this.txtSteps.setText(VNAFormatFactory.getFrequencyCalibrationFormat().format(this.dib.getNumberOfSamples()));
        this.txtSteps.setText(VNAFormatFactory.getFrequencyCalibrationFormat().format(this.dib.getNumberOfSamples()));
        this.referenceValue.setComplexValue(this.dib.getReferenceResistance());
        this.txtPhaseCorrection.setText(VNAFormatFactory.getGainFormat().format(this.dib.getPhaseCorrection()));
        this.txtIFPhaseCorrection.setText(VNAFormatFactory.getGainFormat().format(this.dib.getIfPhaseCorrection()));
        this.txtGainCorrection.setText(VNAFormatFactory.getGainFormat().format(this.dib.getGainCorrection()));
        this.txtTempCorrection.setText(VNAFormatFactory.getGainFormat().format(this.dib.getTempCorrection()));
        this.txtBootloaderBaudRate.setText(VNAFormatFactory.getFrequencyFormat4Export().format(this.dib.getBootloaderBaudrate()));
        this.cbPeakSuppression.setSelected(this.dib.isPeakSuppression());
    }
}

