/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.tiny;

import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNABaseSample;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.calibrated.VNACalibrationContext;
import krause.vna.data.calibrated.VNACalibrationContextTiny;
import krause.vna.data.calibrated.VNACalibrationPoint;
import krause.vna.data.helper.VNACalibratedSampleHelper;
import krause.vna.device.IVNADriver;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.device.VNADriverMathBaseHelper;
import krause.vna.device.serial.tiny.VNADriverSerialTinyDIB;
import krause.vna.device.serial.tiny.VNADriverSerialTinyFIRCoefficients;
import org.apache.commons.math.complex.Complex;

public class VNADriverSerialTinyMathHelper
extends VNADriverMathBaseHelper {
    static final Complex C_1 = new Complex(1.0, 0.0);
    static final double PHASE_CONSTANT = 57.29577951308232;
    static final double R_Minus_One = -1.0;
    static final double R_Plus_One = 1.0;
    static final double R_Zero = 0.0;
    private static final double SMALL_PHASE = 0.1;

    public VNADriverSerialTinyMathHelper(IVNADriver driver) {
        super(driver);
        TraceHelper.entry(this, "VNADriverSerialTinyMathHelper");
        TraceHelper.exit(this, "VNADriverSerialTinyMathHelper");
    }

    @Override
    public void applyFilter(VNABaseSample[] samples) {
        TraceHelper.entry(this, "applyFilter");
        VNADeviceInfoBlock dib = this.getDriver().getDeviceInfoBlock();
        double[] coeff = null;
        int filterMode = dib.getFilterMode();
        TraceHelper.text(this, "applyFilter", "Filtermode=" + filterMode);
        if (filterMode == 1) {
            TraceHelper.text(this, "applyFilter", "Moving average 4");
            coeff = VNADriverSerialTinyFIRCoefficients.MOVING_AVERAGE_4;
        } else if (filterMode == 2) {
            TraceHelper.text(this, "applyFilter", "Moving average 10");
            coeff = VNADriverSerialTinyFIRCoefficients.MOVING_AVERAGE_10;
        } else {
            TraceHelper.exitWithRC((Object)this, "applyFilter", "No filtering");
            return;
        }
        int numCoeff = coeff.length;
        int[] iLatches = new int[numCoeff];
        int[] qLatches = new int[numCoeff];
        int numSamples = samples.length;
        int c = 0;
        while (c < numCoeff) {
            iLatches[c] = samples[c].getLoss();
            qLatches[c] = samples[c].getAngle();
            ++c;
        }
        int i = numCoeff;
        while (i < numSamples) {
            int c2 = 1;
            while (c2 < numCoeff) {
                iLatches[c2 - 1] = iLatches[c2];
                qLatches[c2 - 1] = qLatches[c2];
                ++c2;
            }
            iLatches[numCoeff - 1] = samples[i].getLoss();
            qLatches[numCoeff - 1] = samples[i].getAngle();
            double newISample = 0.0;
            double newQSample = 0.0;
            int c3 = 0;
            while (c3 < numCoeff) {
                newISample += coeff[c3] * (double)iLatches[c3];
                newQSample += coeff[c3] * (double)qLatches[c3];
                ++c3;
            }
            samples[i].setLoss((int)newISample);
            samples[i].setAngle((int)newQSample);
            ++i;
        }
        TraceHelper.exit(this, "applyFilter");
    }

    private VNABaseSample calculateCorrectedBaseSample(VNACalibrationContextTiny context, VNABaseSample sample, double temp) {
        if (sample != null) {
            VNABaseSample rc = new VNABaseSample(sample);
            double oldReal = sample.getLoss();
            double oldImag = sample.getAngle();
            double deltaTemp = 40.0 - temp;
            double corrTempFactor = 1.0 - deltaTemp * context.getTempCorrection();
            int newReal = (int)(oldReal *= corrTempFactor);
            int newImag = (int)(((oldImag *= corrTempFactor) * context.getGainCorrection() - oldReal * 1.0 * context.getSineCorrection()) / context.getCosineCorrection());
            rc.setLoss(newReal);
            rc.setAngle(newImag);
            return rc;
        }
        return null;
    }

    @Override
    public VNACalibratedSample createCalibratedSample(VNACalibrationContext pContext, VNABaseSample rawSample, VNACalibrationPoint calibPoint) {
        VNACalibrationContextTiny context = (VNACalibrationContextTiny)pContext;
        VNABaseSample correctedRawSample = this.calculateCorrectedBaseSample(context, rawSample, context.getConversionTemperature());
        VNADriverSerialTinyDIB dib = (VNADriverSerialTinyDIB)context.getDib();
        double deltaTemp = context.getCalibrationTemperature() - context.getConversionTemperature();
        double ifPhaseCorrection = deltaTemp * dib.getIfPhaseCorrection();
        if (context.getScanMode().isTransmissionMode()) {
            return this.createCalibratedSampleForTransmission(context, correctedRawSample, calibPoint, ifPhaseCorrection);
        }
        return this.createCalibratedSampleForReflection(context, correctedRawSample, calibPoint, ifPhaseCorrection);
    }

    private VNACalibratedSample createCalibratedSampleForReflection(VNACalibrationContext context, VNABaseSample rawSample, VNACalibrationPoint calib, double ifPhaseCorrection) {
        VNADeviceInfoBlock dib = context.getDib();
        Complex rhoM = rawSample.asComplex();
        Complex rho = rhoM.subtract(calib.getE00()).divide(rhoM.multiply(calib.getE11()).subtract(calib.getDeltaE()));
        double mag = rho.abs();
        if (mag > 1.0) {
            mag = 1.0;
        }
        double swr = (1.0 + mag) / (1.0 - mag);
        double returnLoss = 20.0 * Math.log10(mag);
        returnLoss = Math.max(returnLoss, dib.getMaxLoss());
        double returnPhase = rho.getArgument() * 57.29577951308232;
        if (returnPhase >= 0.0 && returnPhase < 0.1) {
            returnPhase = 0.1;
        } else if (returnPhase > -0.1 && returnPhase < 0.0) {
            returnPhase = -0.1;
        }
        returnPhase += ifPhaseCorrection;
        if (returnPhase > 180.0) {
            returnPhase += -360.0;
        } else if (returnPhase < -180.0) {
            returnPhase += 360.0;
        }
        double f = Math.cos(returnPhase / 57.29577951308232);
        double g = Math.sin(returnPhase / 57.29577951308232);
        double rr = f * mag;
        double ss = g * mag;
        double x_imp = 2.0 * ss / ((1.0 - rr) * (1.0 - rr) + ss * ss) * context.getDib().getReferenceResistance().getReal();
        double r_imp = (1.0 - rr * rr - ss * ss) / ((1.0 - rr) * (1.0 - rr) + ss * ss) * context.getDib().getReferenceResistance().getReal();
        if (r_imp < 0.0) {
            r_imp = 0.0;
        }
        double z_imp = Math.sqrt(r_imp * r_imp + x_imp * x_imp);
        VNACalibratedSample rc = new VNACalibratedSample();
        rc.setFrequency(rawSample.getFrequency());
        rc.setRHO(rho);
        rc.setMag(mag);
        rc.setReflectionLoss(returnLoss);
        rc.setReflectionPhase(returnPhase);
        rc.setSWR(swr);
        rc.setR(r_imp);
        rc.setX(x_imp);
        rc.setZ(z_imp);
        return rc;
    }

    private VNACalibratedSample createCalibratedSampleForTransmission(VNACalibrationContext context, VNABaseSample rawSample, VNACalibrationPoint calPoint, double ifPhaseCorrection) {
        VNADeviceInfoBlock dib = context.getDib();
        VNACalibratedSample rc = new VNACalibratedSample();
        rc.setFrequency(rawSample.getFrequency());
        Complex mDUT = new Complex((double)(rawSample.getAngle() - 512) * 0.003, (double)(rawSample.getLoss() - 512) * 0.003);
        Complex gDUT = mDUT.subtract(calPoint.getE11()).divide(calPoint.getDeltaE());
        rc.setMag(gDUT.abs());
        rc.setTransmissionLoss(Math.max(20.0 * Math.log10(rc.getMag()), dib.getMaxLoss()));
        double tp = -gDUT.getArgument() * 57.29577951308232;
        tp += ifPhaseCorrection;
        if (tp > 180.0) {
            tp -= 180.0;
        } else if (tp < -180.0) {
            tp += -180.0;
        }
        rc.setTransmissionPhase(tp);
        return rc;
    }

    @Override
    public VNACalibrationContext createCalibrationContextForCalibratedSamples(VNACalibrationBlock calBlock) {
        TraceHelper.entry(this, "createCalibrationContextForCalibratedSamples");
        VNADriverSerialTinyDIB dib = (VNADriverSerialTinyDIB)calBlock.getMathHelper().getDriver().getDeviceInfoBlock();
        VNACalibrationContextTiny context = new VNACalibrationContextTiny();
        context.setDib(dib);
        context.setCalibrationBlock(calBlock);
        context.setScanMode(calBlock.getScanMode());
        context.setCalibrationTemperature(calBlock.getTemperature());
        double correctionRadian = dib.getPhaseCorrection() * Math.PI / 180.0;
        context.setSineCorrection(Math.sin(correctionRadian));
        context.setCosineCorrection(Math.cos(correctionRadian));
        context.setGainCorrection(dib.getGainCorrection());
        context.setTempCorrection(dib.getTempCorrection());
        TraceHelper.exit(this, "createCalibrationContextForCalibratedSamples");
        return context;
    }

    @Override
    public VNACalibrationContext createCalibrationContextForCalibrationPoints(VNACalibrationBlock calBlock) {
        TraceHelper.entry(this, "createCalibrationContextForCalibrationPoints");
        VNADriverSerialTinyDIB dib = (VNADriverSerialTinyDIB)calBlock.getMathHelper().getDriver().getDeviceInfoBlock();
        VNACalibrationContextTiny context = new VNACalibrationContextTiny();
        context.setDib(dib);
        context.setCalibrationBlock(calBlock);
        context.setScanMode(calBlock.getScanMode());
        calBlock.calculateCalibrationTemperature();
        context.setCalibrationTemperature(calBlock.getTemperature());
        double correctionRadian = dib.getPhaseCorrection() * Math.PI / 180.0;
        context.setSineCorrection(Math.sin(correctionRadian));
        context.setCosineCorrection(Math.cos(correctionRadian));
        context.setGainCorrection(dib.getGainCorrection());
        context.setTempCorrection(dib.getTempCorrection());
        TraceHelper.exit(this, "createCalibrationContextForCalibrationPoints");
        return context;
    }

    @Override
    public VNACalibrationPoint createCalibrationPoint(VNACalibrationContext pContext, VNABaseSample sampleOpen, VNABaseSample sampleShort, VNABaseSample sampleLoad, VNABaseSample sampleLoop) {
        VNACalibrationContextTiny context = (VNACalibrationContextTiny)pContext;
        if (context.getScanMode().isTransmissionMode()) {
            VNABaseSample corrOpen = this.calculateCorrectedBaseSample(context, sampleOpen, context.getCalibrationTemperature());
            VNABaseSample corrLoop = this.calculateCorrectedBaseSample(context, sampleLoop, context.getCalibrationTemperature());
            return this.createCalibrationPointForTransmission(corrOpen, corrLoop);
        }
        VNABaseSample corrOpen = this.calculateCorrectedBaseSample(context, sampleOpen, context.getCalibrationTemperature());
        VNABaseSample corrShort = this.calculateCorrectedBaseSample(context, sampleShort, context.getCalibrationTemperature());
        VNABaseSample corrLoad = this.calculateCorrectedBaseSample(context, sampleLoad, context.getCalibrationTemperature());
        return this.createCalibrationPointForReflection(corrOpen, corrShort, corrLoad);
    }

    private VNACalibrationPoint createCalibrationPointForReflection(VNABaseSample sampleOpen, VNABaseSample sampleShort, VNABaseSample sampleLoad) {
        VNACalibrationPoint rc = new VNACalibrationPoint();
        Complex M1 = sampleOpen.asComplex();
        Complex M2 = sampleShort.asComplex();
        Complex M3 = sampleLoad.asComplex();
        double A1 = 1.0;
        double A2 = -1.0;
        double A3 = 0.0;
        Complex p1 = M2.multiply(-1.0).subtract(M1.multiply(1.0)).multiply(M1.subtract(M3));
        Complex p2 = M3.multiply(0.0).subtract(M1.multiply(1.0)).multiply(M2.subtract(M1));
        Complex p3 = M2.multiply(-1.0).subtract(M1.multiply(1.0)).multiply(-1.0);
        Complex p4 = M3.multiply(0.0).subtract(M1.multiply(1.0)).multiply(-2.0);
        rc.setDeltaE(p1.add(p2).divide(p3.subtract(p4)));
        rc.setE11(M2.subtract(M1).add(rc.getDeltaE().multiply(-2.0)).divide(M2.multiply(-1.0).subtract(M1.multiply(1.0))));
        rc.setE00(M1.subtract(M1.multiply(1.0).multiply(rc.getE11())).add(rc.getDeltaE().multiply(1.0)));
        rc.setFrequency(sampleOpen.getFrequency());
        return rc;
    }

    private VNACalibrationPoint createCalibrationPointForTransmission(VNABaseSample sampleOpen, VNABaseSample sampleLoop) {
        VNACalibrationPoint rc = new VNACalibrationPoint();
        rc.setFrequency(sampleLoop.getFrequency());
        rc.setE00(new Complex((double)(sampleLoop.getAngle() - 512) * 0.003, (double)(sampleLoop.getLoss() - 512) * 0.003));
        rc.setE11(new Complex((double)(sampleOpen.getAngle() - 512) * 0.003, (double)(sampleOpen.getLoss() - 512) * 0.003));
        rc.setDeltaE(rc.getE00().subtract(rc.getE11()));
        return rc;
    }

    @Override
    public VNACalibratedSampleBlock createCalibratedSamples(VNACalibrationContext context, VNASampleBlock raw) {
        VNACalibratedSampleBlock rc = null;
        TraceHelper.entry(this, "createCalibratedSamples");
        rc = super.createCalibratedSamples(context, raw);
        VNADeviceInfoBlock dib = context.getDib();
        if (dib.isPeakSuppression()) {
            VNACalibratedSampleHelper.removeSwitchPoints(rc.getCalibratedSamples(), dib.getSwitchPoints());
        }
        TraceHelper.exit(this, "createCalibratedSamples");
        return rc;
    }
}

