/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.tiny;

import krause.common.TypedProperties;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNAScanMode;
import krause.vna.device.VNAScanModeParameter;
import krause.vna.device.VNASerialDeviceInfoBlock;
import krause.vna.gui.scale.VNAScaleSymbols;

public class VNADriverSerialTinyDIB
extends VNASerialDeviceInfoBlock {
    public static final int AFTERCOMMANDDELAY = 101;
    public static final int BAURATE_BOOT = 230400;
    public static final int BAURATE_SCAN = 921600;
    public static final int CAL_STEPS = 10000;
    public static final long DDS_TICKS = 10000000L;
    public static final double GAIN_CORR = 1.0;
    public static final double IF_PHASE_CORR = 1.1;
    public static final long MAX_FREQ = 3000000000L;
    public static final long MIN_FREQ = 1000000L;
    public static final double MIN_PHASE = -180.0;
    public static final double MAX_PHASE = 180.0;
    public static final int PRESCALER = 10;
    public static final double PHASE_CORR = 0.0;
    public static final double TEMP_CORR = 0.011;
    public static final double TEMP_REFERENCE = 40.0;
    public static final double MIN_LOSS = 0.0;
    public static final double MAX_LOSS = -80.0;
    private int bootloaderBaudrate;
    private double gainCorrection;
    private double ifPhaseCorrection;
    private double phaseCorrection;
    private int prescaler;
    private String scanCommandReflection;
    private String scanCommandTransmission;
    private double tempCorrection;

    public VNADriverSerialTinyDIB() {
        TraceHelper.entry(this, "VNADriverSerialTinyDIB");
        this.reset();
        this.clearScanModeParameters();
        this.addScanModeParameter(new VNAScanModeParameter(VNAScanMode.MODE_REFLECTION, true, true, true, false, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNLOSS, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNPHASE));
        this.addScanModeParameter(new VNAScanModeParameter(VNAScanMode.MODE_TRANSMISSION, true, false, false, true, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONLOSS, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONPHASE));
        this.setShortName("miniVNA Tiny");
        this.setLongName("mini radio solutions - miniVNA Tiny");
        this.setType("20");
        TraceHelper.exit(this, "VNADriverSerialTinyDIB");
    }

    public int getBootloaderBaudrate() {
        return this.bootloaderBaudrate;
    }

    public double getGainCorrection() {
        return this.gainCorrection;
    }

    public double getIfPhaseCorrection() {
        return this.ifPhaseCorrection;
    }

    public double getPhaseCorrection() {
        return this.phaseCorrection;
    }

    public int getPrescaler() {
        return this.prescaler;
    }

    public String getScanCommandReflection() {
        return this.scanCommandReflection;
    }

    public String getScanCommandTransmission() {
        return this.scanCommandTransmission;
    }

    public double getTempCorrection() {
        return this.tempCorrection;
    }

    @Override
    public void reset() {
        super.reset();
        this.setMinFrequency(1000000L);
        this.setMaxFrequency(3000000000L);
        this.setMinLoss(0.0);
        this.setMaxLoss(-80.0);
        this.setMinPhase(-180.0);
        this.setMaxPhase(180.0);
        this.setNumberOfSamples(10000);
        this.setPrescaler(10);
        this.setScanCommandTransmission("6");
        this.setScanCommandReflection("7");
        this.setDdsTicksPerMHz(10000000L);
        this.setAfterCommandDelay(101);
        this.setBaudrate(921600);
        this.setBootloaderBaudrate(230400);
        this.setPhaseCorrection(0.0);
        this.setGainCorrection(1.0);
        this.setTempCorrection(0.011);
        this.setIfPhaseCorrection(1.1);
        this.setFilterMode(0);
        this.setPeakSuppression(true);
    }

    @Override
    public void restore(TypedProperties config, String prefix) {
        super.restore(config, prefix);
        this.setPhaseCorrection(config.getDouble(String.valueOf(prefix) + "phaseCorrection", 0.0));
        this.setGainCorrection(config.getDouble(String.valueOf(prefix) + "gainCorrection", 1.0));
        this.setTempCorrection(config.getDouble(String.valueOf(prefix) + "tempCorrection", 0.011));
        this.setIfPhaseCorrection(config.getDouble(String.valueOf(prefix) + "ifPhaseCorrection", 1.1));
        this.setBootloaderBaudrate(config.getInteger(String.valueOf(prefix) + "bootloaderBaudrate", 230400));
        this.setDdsTicksPerMHz(config.getLong(String.valueOf(prefix) + "ddsTicks", 10000000L));
        this.setMinFrequency(config.getLong(String.valueOf(prefix) + "freqMin", 1000000L));
        this.setMaxFrequency(config.getLong(String.valueOf(prefix) + "freqMax", 3000000000L));
        this.setMinLoss(config.getDouble(String.valueOf(prefix) + "lossMin", 0.0));
        this.setMaxLoss(config.getDouble(String.valueOf(prefix) + "lossMax", -80.0));
    }

    public void setBootloaderBaudrate(int bootloaderBaudrate) {
        this.bootloaderBaudrate = bootloaderBaudrate;
    }

    public void setGainCorrection(double gainCorrection) {
        this.gainCorrection = gainCorrection;
    }

    public void setIfPhaseCorrection(double ifPhaseCorrection) {
        this.ifPhaseCorrection = ifPhaseCorrection;
    }

    public void setPhaseCorrection(double phaseCorrection) {
        this.phaseCorrection = phaseCorrection;
    }

    public void setPrescaler(int prescaler) {
        this.prescaler = prescaler;
    }

    public void setScanCommandReflection(String scanCommandReflection) {
        this.scanCommandReflection = scanCommandReflection;
    }

    public void setScanCommandTransmission(String scanCommandTransmission) {
        this.scanCommandTransmission = scanCommandTransmission;
    }

    public void setTempCorrection(double tempCorrection) {
        this.tempCorrection = tempCorrection;
    }

    @Override
    public void store(TypedProperties config, String prefix) {
        super.store(config, prefix);
        config.putDouble(String.valueOf(prefix) + "phaseCorrection", this.getPhaseCorrection());
        config.putDouble(String.valueOf(prefix) + "gainCorrection", this.getGainCorrection());
        config.putDouble(String.valueOf(prefix) + "tempCorrection", this.getTempCorrection());
        config.putDouble(String.valueOf(prefix) + "ifPhaseCorrection", this.getIfPhaseCorrection());
        config.putInteger(String.valueOf(prefix) + "bootloaderBaudrate", this.getBootloaderBaudrate());
        config.putLong(String.valueOf(prefix) + "ddsTicks", this.getDdsTicksPerMHz());
        config.putLong(String.valueOf(prefix) + "freqMin", this.getMinFrequency());
        config.putLong(String.valueOf(prefix) + "freqMax", this.getMaxFrequency());
        config.putDouble(String.valueOf(prefix) + "lossMin", this.getMinLoss());
        config.putDouble(String.valueOf(prefix) + "lossMax", this.getMaxLoss());
    }

    @Override
    public long[] getSwitchPoints() {
        return new long[]{1045000000L, 1525000000L};
    }
}

