/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.tiny;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import krause.common.exception.DialogNotImplementedException;
import krause.common.exception.InitializationException;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.IVNABackgroundTaskStatusListener;
import krause.vna.data.VNABaseSample;
import krause.vna.data.VNAFrequencyRange;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.device.IVNAFlashableDevice;
import krause.vna.device.VNASerialDeviceInfoBlock;
import krause.vna.device.serial.VNADriverSerialBase;
import krause.vna.device.serial.tiny.VNADriverSerialTinyDIB;
import krause.vna.device.serial.tiny.VNADriverSerialTinyMathHelper;
import krause.vna.device.serial.tiny.VNADriverSerialTinyMessages;
import krause.vna.device.serial.tiny.gui.VNADriverSerialTinyDialog;
import krause.vna.export.XLSRawExporter;
import krause.vna.firmware.Chip45Loader;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.calibrate.mode1.VNACalibrationRange;
import krause.vna.gui.generator.VNAGeneratorDialog;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class VNADriverSerialTiny
extends VNADriverSerialBase
implements IVNAFlashableDevice {
    private static final int NUM_BYTES_PER_SAMPLE = 12;

    public VNADriverSerialTiny() {
        TraceHelper.entry(this, "VNADriverSerialTiny");
        this.setMathHelper(new VNADriverSerialTinyMathHelper(this));
        this.setDeviceInfoBlock(new VNADriverSerialTinyDIB());
        this.getDeviceInfoBlock().restore(this.config, this.getDriverConfigPrefix());
        TraceHelper.exit(this, "VNADriverSerialTiny");
    }

    @Override
    public long calculateInternalFrequencyValue(long frequency) {
        TraceHelper.entry((Object)this, "calculateInternalFrequencyValue", "In=" + frequency);
        long rc = (long)((double)frequency / 1.0E7 * (double)this.getDeviceInfoBlock().getDdsTicksPerMHz());
        TraceHelper.exitWithRC((Object)this, "calculateInternalFrequencyValue", rc);
        return rc;
    }

    @Override
    public void destroy() {
        String methodName = "destroy";
        TraceHelper.entry(this, "destroy");
        if (this.getPort() != null) {
            TraceHelper.text(this, "destroy", "closing " + this.getPort().getName());
            this.getPort().close();
            this.setPort(null);
            TraceHelper.text(this, "destroy", "port closed");
        }
        TraceHelper.exit(this, "destroy");
    }

    @Override
    public int getBootloadBaudRate() {
        VNADriverSerialTinyDIB dib = (VNADriverSerialTinyDIB)this.getDeviceInfoBlock();
        return dib.getBootloaderBaudrate();
    }

    @Override
    public String getDeviceFirmwareInfo() {
        String methodName = "readFirmwareVersion";
        TraceHelper.entry(this, "readFirmwareVersion");
        String rc = "???";
        try {
            this.flushInputStream();
            this.sendAsAsciiString("9");
            rc = this.readLine(true);
            VNADriverSerialTinyDIB dib = (VNADriverSerialTinyDIB)this.getDeviceInfoBlock();
            this.wait(dib.getAfterCommandDelay());
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
        TraceHelper.exitWithRC((Object)this, "readFirmwareVersion", rc);
        return rc;
    }

    @Override
    public Double getDeviceSupply() {
        Double rc;
        block16: {
            String methodName = "getDevicePowerStatus";
            TraceHelper.entry(this, "getDevicePowerStatus");
            rc = null;
            InputStream stream = null;
            if (this.getPort() != null) {
                try {
                    try {
                        this.flushInputStream();
                        this.sendAsAsciiString("8");
                        byte[] innerdata = new byte[2];
                        int ch = this.readBuffer(innerdata, 0, 2);
                        if (ch == -1) {
                            ProcessingException e = new ProcessingException("No data character received");
                            ErrorLogHelper.exception(this, "getDevicePowerStatus", e);
                            throw e;
                        }
                        rc = (double)(((innerdata[0] & 0xFF) + (innerdata[1] & 0xFF) * 256) * 6) / 1024.0;
                        VNADriverSerialTinyDIB dib = (VNADriverSerialTinyDIB)this.getDeviceInfoBlock();
                        this.wait(dib.getAfterCommandDelay());
                    }
                    catch (ProcessingException pex) {
                        rc = -1.0;
                        if (stream != null) {
                            try {
                                stream.close();
                                stream = null;
                            }
                            catch (IOException e) {
                                ErrorLogHelper.exception(this, "getDevicePowerStatus", e);
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                            stream = null;
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "getDevicePowerStatus", e);
                        }
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                        stream = null;
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "getDevicePowerStatus", e);
                    }
                }
            }
        }
        TraceHelper.exitWithRC((Object)this, "getDevicePowerStatus", rc);
        return rc;
    }

    @Override
    public Double getDeviceTemperature() {
        Double rc;
        block16: {
            String methodName = "getDeviceTemperature";
            TraceHelper.entry(this, "getDeviceTemperature");
            rc = -1.0;
            InputStream stream = null;
            if (this.getPort() != null) {
                try {
                    try {
                        this.flushInputStream();
                        this.sendAsAsciiString("10");
                        byte[] innerdata = new byte[2];
                        int ch = this.readBuffer(innerdata, 0, 2);
                        if (ch == -1) {
                            ProcessingException e = new ProcessingException("No data character received");
                            ErrorLogHelper.exception(this, "getDeviceTemperature", e);
                        }
                        rc = (double)((innerdata[0] & 0xFF) + (innerdata[1] & 0xFF) * 256) / 10.0;
                        VNADriverSerialTinyDIB dib = (VNADriverSerialTinyDIB)this.getDeviceInfoBlock();
                        this.wait(dib.getAfterCommandDelay());
                    }
                    catch (ProcessingException e1) {
                        ErrorLogHelper.exception(this, "getDeviceTemperature", e1);
                        if (stream != null) {
                            try {
                                stream.close();
                                stream = null;
                            }
                            catch (IOException e) {
                                ErrorLogHelper.exception(this, "getDeviceTemperature", e);
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                            stream = null;
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "getDeviceTemperature", e);
                        }
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                        stream = null;
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "getDeviceTemperature", e);
                    }
                }
            }
        }
        TraceHelper.exitWithRC((Object)this, "getDeviceTemperature", rc);
        return rc;
    }

    @Override
    public String getDriverConfigPrefix() {
        return "VNADriver.Serial.Tiny.";
    }

    @Override
    public String getFirmwareLoaderClassName() {
        if (this.config.isMac()) {
            return null;
        }
        return Chip45Loader.class.getName();
    }

    @Override
    public VNACalibrationRange[] getSpecificCalibrationRanges() {
        return new VNACalibrationRange[]{new VNACalibrationRange(this.getDeviceInfoBlock().getMinFrequency(), 30999999L, 10000, 2), new VNACalibrationRange(31000000L, 48999999L, 500, 1), new VNACalibrationRange(49000000L, 52999999L, 2000, 2), new VNACalibrationRange(53000000L, 142999999L, 500, 1), new VNACalibrationRange(143000000L, 147999999L, 2000, 2), new VNACalibrationRange(148000000L, 428999999L, 500, 1), new VNACalibrationRange(429000000L, 441999999L, 2000, 2), new VNACalibrationRange(442000000L, 1229999999L, 500, 1), new VNACalibrationRange(1230000000L, 1310999999L, 2000, 2), new VNACalibrationRange(1311000000L, 2199999999L, 500, 1), new VNACalibrationRange(2200000000L, 2599999999L, 2000, 2), new VNACalibrationRange(2600000000L, this.getDeviceInfoBlock().getMaxFrequency(), 500, 1)};
    }

    @Override
    public boolean hasResetButton() {
        return false;
    }

    @Override
    public void init() throws InitializationException {
        String methodeName = "init";
        TraceHelper.entry(this, "init");
        super.init();
        VNADriverSerialTinyDIB dib = (VNADriverSerialTinyDIB)this.getDeviceInfoBlock();
        dib.restore(this.config, this.getDriverConfigPrefix());
        TraceHelper.text(this, "init", "Trying to open port [" + this.getPortname() + "]");
        try {
            CommPortIdentifier portId = this.getPortIDForName(this.getPortname());
            if (portId == null) {
                InitializationException e = new InitializationException("Port [" + this.getPortname() + "] not found");
                ErrorLogHelper.exception(this, "init", e);
                throw e;
            }
            TraceHelper.text(this, "init", "port [" + this.getPortname() + "] found");
            SerialPort aPort = (SerialPort)portId.open(this.getAppname(), dib.getOpenTimeout());
            TraceHelper.text(this, "init", "port [" + this.getPortname() + "] opened");
            aPort.setFlowControlMode(0);
            TraceHelper.text(this, "init", "port [" + this.getPortname() + "] set to [" + dib.getBaudrate() + "]bd");
            aPort.setSerialPortParams(dib.getBaudrate(), 8, 1, 0);
            aPort.enableReceiveTimeout(dib.getReadTimeout());
            aPort.setInputBufferSize(32000);
            TraceHelper.text(this, "init", "port [" + this.getPortname() + "] setup done");
            this.setPort(aPort);
        }
        catch (PortInUseException e) {
            ErrorLogHelper.exception(this, "init", (Exception)((Object)e));
            throw new InitializationException(e);
        }
        catch (UnsupportedCommOperationException e) {
            ErrorLogHelper.exception(this, "init", (Exception)((Object)e));
            throw new InitializationException(e);
        }
        catch (Throwable t) {
            ErrorLogHelper.text(this, "init", t.getMessage());
            throw new InitializationException(t);
        }
        TraceHelper.exit(this, "init");
    }

    @Override
    public boolean isScanSupported(int numSamples, VNAFrequencyRange range, VNAScanMode mode) {
        boolean rc = true;
        return rc;
    }

    protected VNABaseSample[] receiveRawMessage(long pStartFrequency, int pNumSamples, long pFrequencyStep, IVNABackgroundTaskStatusListener pListener) throws ProcessingException {
        String methodName = "receiveRawMessage";
        TraceHelper.entry((Object)this, "receiveRawMessage", "fs=" + pStartFrequency + " #=" + pNumSamples);
        InputStream stream = null;
        VNABaseSample[] rc = new VNABaseSample[pNumSamples];
        if (pListener != null) {
            pListener.publishProgress(0);
        }
        try {
            try {
                int remainingBytes = 12 * pNumSamples;
                byte[] buffer = new byte[remainingBytes];
                stream = this.getPort().getInputStream();
                int readBytes = 0;
                long endTime = System.currentTimeMillis() + this.getTimeoutBasedOnNumberOfSamples(this.getPort(), pNumSamples);
                while (remainingBytes > 0) {
                    if (stream.available() > 0) {
                        int currBytesRead = stream.read(buffer, readBytes, remainingBytes);
                        TraceHelper.text(this, "receiveRawMessage", "req=" + (remainingBytes -= currBytesRead) + "# act=" + currBytesRead + "# totally read=" + (readBytes += currBytesRead) + " remain=" + remainingBytes);
                        if (pListener != null) {
                            int perc = (int)((double)readBytes * 100.0 / (double)(readBytes + remainingBytes));
                            pListener.publishProgress(perc);
                        }
                    }
                    if (System.currentTimeMillis() <= endTime) continue;
                    String msg = MessageFormat.format(VNADriverSerialTinyMessages.getString("NoChars"), remainingBytes, readBytes);
                    ProcessingException e = new ProcessingException(msg);
                    ErrorLogHelper.exception(this, "receiveRawMessage", e);
                    throw e;
                }
                TraceHelper.text(this, "receiveRawMessage", "all bytes read");
                long currentFrequency = pStartFrequency;
                int i = 0;
                while (i < pNumSamples) {
                    int offset = i * 12;
                    VNABaseSample tempSample = new VNABaseSample();
                    int p1 = (buffer[offset + 0] & 0xFF) + (buffer[offset + 1] & 0xFF) * 256 + (buffer[offset + 2] & 0xFF) * 65536;
                    int p2 = (buffer[offset + 6] & 0xFF) + (buffer[offset + 7] & 0xFF) * 256 + (buffer[offset + 8] & 0xFF) * 65536;
                    int real = (p1 - p2) / 2;
                    int p3 = (buffer[offset + 3] & 0xFF) + (buffer[offset + 4] & 0xFF) * 256 + (buffer[offset + 5] & 0xFF) * 65536;
                    int p4 = (buffer[offset + 9] & 0xFF) + (buffer[offset + 10] & 0xFF) * 256 + (buffer[offset + 11] & 0xFF) * 65536;
                    int imaginary = (p3 - p4) / 2;
                    tempSample.p1 = p1;
                    tempSample.p2 = p2;
                    tempSample.p3 = p3;
                    tempSample.p4 = p4;
                    tempSample.hasPData = true;
                    tempSample.setLoss(real);
                    tempSample.setAngle(imaginary);
                    tempSample.setFrequency(currentFrequency);
                    rc[i] = tempSample;
                    currentFrequency += pFrequencyStep;
                    ++i;
                }
                TraceHelper.text(this, "receiveRawMessage", "Last frequency requested was " + (currentFrequency - pFrequencyStep));
                TraceHelper.text(this, "receiveRawMessage", String.valueOf(pNumSamples) + " step(s) done");
            }
            catch (IOException e) {
                ErrorLogHelper.exception(this, "receiveRawMessage", e);
                throw new ProcessingException(e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                    stream = null;
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "receiveRawMessage", e);
                }
            }
        }
        TraceHelper.exit(this, "receiveRawMessage");
        return rc;
    }

    @Override
    public VNASampleBlock scan(VNAScanMode scanMode, long frequencyLow, long frequencyHigh, int numSamples, IVNABackgroundTaskStatusListener listener) throws ProcessingException {
        String methodName = "scan";
        TraceHelper.entry((Object)this, "scan", "mode=" + scanMode + " low=" + frequencyLow + " high=" + frequencyHigh + " #=" + numSamples);
        VNASampleBlock rc = new VNASampleBlock();
        rc.setDeviceTemperature(this.getDeviceTemperature());
        rc.setDeviceSupply(this.getDeviceSupply());
        VNADriverSerialTinyDIB dib = (VNADriverSerialTinyDIB)this.getDeviceInfoBlock();
        if (this.getPort() != null) {
            this.flushInputStream();
            if (scanMode.isTransmissionMode()) {
                this.sendAsAsciiString(dib.getScanCommandTransmission());
            } else if (scanMode.isReflectionMode()) {
                this.sendAsAsciiString(dib.getScanCommandReflection());
            } else {
                throw new ProcessingException("Unsupported scan mode " + scanMode);
            }
            this.sendFrequency(frequencyLow);
            this.sendFrequency(frequencyHigh);
            this.sendAsAsciiString(Integer.toString(numSamples));
            this.sendAsAsciiString("");
            long frequencyStep = (frequencyHigh - frequencyLow) / (long)(numSamples - 1);
            TraceHelper.text(this, "scan", "Start    " + frequencyLow);
            TraceHelper.text(this, "scan", "Stop     " + frequencyHigh);
            TraceHelper.text(this, "scan", "Steps    " + numSamples);
            TraceHelper.text(this, "scan", "Step     " + frequencyStep);
            TraceHelper.text(this, "scan", "Last     " + (frequencyLow + (long)(numSamples - 1) * frequencyStep));
            rc.setSamples(this.receiveRawMessage(frequencyLow, numSamples, frequencyStep, listener));
            if (this.config.isExportRawData()) {
                XLSRawExporter.export(rc.getSamples(), "rawScanData");
            }
            rc.setScanMode(scanMode);
            rc.setNumberOfSteps(numSamples);
            rc.setStartFrequency(frequencyLow);
            rc.setStopFrequency(frequencyHigh);
            rc.setAnalyserType(this.getDeviceInfoBlock().getType());
            rc.setMathHelper(this.getMathHelper());
            this.wait(dib.getAfterCommandDelay());
        }
        TraceHelper.exit(this, "scan");
        return rc;
    }

    protected void sendFrequency(long frq) throws ProcessingException {
        long corrFrq = this.calculateInternalFrequencyValue(frq);
        VNADriverSerialTinyDIB dib = (VNADriverSerialTinyDIB)this.getDeviceInfoBlock();
        String msg = VNADriverSerialTiny.getFrequencyFormat().format(corrFrq / (long)dib.getPrescaler());
        this.sendAsAsciiString(msg);
    }

    @Override
    public void showDriverDialog(VNAMainFrame pMF) {
        TraceHelper.entry(this, "showDriverDialog");
        VNADriverSerialTinyDialog dlg = new VNADriverSerialTinyDialog(pMF, this);
        dlg.dispose();
        TraceHelper.exit(this, "showDriverDialog");
    }

    @Override
    public void showGeneratorDialog(VNAMainFrame pMF) throws DialogNotImplementedException {
        TraceHelper.entry(this, "showGeneratorDialog");
        new VNAGeneratorDialog(pMF, this);
        TraceHelper.exit(this, "showGeneratorDialog");
    }

    @Override
    public void startGenerator(long frequencyI, long frequencyQ, int attenuationI, int attenuationQ, int phase, int mainAttenuation) throws ProcessingException {
        String methodName = "startGenerator";
        TraceHelper.entry(this, "startGenerator");
        TraceHelper.text(this, "startGenerator", "fI=" + frequencyI);
        TraceHelper.text(this, "startGenerator", "fQ=" + frequencyQ);
        if (this.getPort() != null) {
            this.flushInputStream();
            this.sendAsAsciiString("21");
            this.sendFrequency(frequencyI);
            this.sendFrequency(frequencyI);
            this.sendAsAsciiString("1");
            this.sendAsAsciiString("0");
            this.receiveRawMessage(0L, 1, 1L, null);
            try {
                VNASerialDeviceInfoBlock dib = (VNASerialDeviceInfoBlock)this.getDeviceInfoBlock();
                Thread.sleep(dib.getAfterCommandDelay());
            }
            catch (InterruptedException e) {
                ErrorLogHelper.exception(this, "startGenerator", e);
                throw new ProcessingException(e);
            }
        }
        TraceHelper.exit(this, "startGenerator");
    }

    @Override
    public void stopGenerator() throws ProcessingException {
        String methodName = "stopGenerator";
        TraceHelper.entry(this, "stopGenerator");
        if (this.getPort() != null) {
            this.flushInputStream();
            this.sendAsAsciiString("7");
            this.sendFrequency(0L);
            this.sendFrequency(0L);
            this.sendAsAsciiString("1");
            this.sendAsAsciiString("0");
            this.receiveRawMessage(0L, 1, 1L, null);
            try {
                VNASerialDeviceInfoBlock dib = (VNASerialDeviceInfoBlock)this.getDeviceInfoBlock();
                Thread.sleep(dib.getAfterCommandDelay());
            }
            catch (InterruptedException e) {
                ErrorLogHelper.exception(this, "startGenerator", e);
                throw new ProcessingException(e);
            }
        }
        TraceHelper.exit(this, "stopGenerator");
    }

    @Override
    public boolean supportsAutoReset() {
        return true;
    }
}

