/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.std;

import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNABaseSample;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.calibrated.VNACalibrationContext;
import krause.vna.data.calibrated.VNACalibrationPoint;
import krause.vna.device.IVNADriver;
import krause.vna.device.VNADriverMathBaseHelper;
import krause.vna.device.serial.std.VNADriverSerialStdDIB;

public class VNADriverSerialStdMathHelper
extends VNADriverMathBaseHelper {
    private static final int DEFAULT_ADC_BITS = 1024;
    private static final double DEFAULT_PHASE_PER_BIT = 0.17595307917888564;
    private static final double DEFAULT_RETURNLOSS_PER_BIT = 0.05865102639296188;
    private final double RAD2DEG = 57.29577951308232;

    public VNADriverSerialStdMathHelper(IVNADriver driver) {
        super(driver);
    }

    @Override
    public void applyFilter(VNABaseSample[] samples) {
        TraceHelper.entry(this, "applyFilter");
        TraceHelper.exit(this, "applyFilter");
    }

    @Override
    public VNACalibratedSample createCalibratedSample(VNACalibrationContext context, VNABaseSample rhoMSample, VNACalibrationPoint calib) {
        if (context.getScanMode().isTransmissionMode()) {
            return this.createCalibratedSampleForTransmission(rhoMSample, calib);
        }
        return this.createCalibratedSampleForReflection(context, rhoMSample, calib);
    }

    private VNACalibratedSample createCalibratedSampleForReflection(VNACalibrationContext context, VNABaseSample raw, VNACalibrationPoint calib) {
        double rl = -(((double)raw.getLoss() - calib.getLoss()) * 0.05865102639296188);
        double phase = (double)raw.getAngle() * 0.17595307917888564;
        double mag = Math.pow(10.0, rl / 20.0);
        double swr = Math.abs((1.0 + mag) / (1.0 - mag));
        double f = Math.cos(phase / 57.29577951308232);
        double g = Math.sin(phase / 57.29577951308232);
        double rr = f * mag;
        double ss = g * mag;
        double x_imp = Math.abs(2.0 * ss / ((1.0 - rr) * (1.0 - rr) + ss * ss) * context.getDib().getReferenceResistance().getReal());
        double r_imp = Math.abs((1.0 - rr * rr - ss * ss) / ((1.0 - rr) * (1.0 - rr) + ss * ss) * context.getDib().getReferenceResistance().getReal());
        double z_imp = Math.sqrt(r_imp * r_imp + x_imp * x_imp);
        VNACalibratedSample rc = new VNACalibratedSample();
        rc.setFrequency(raw.getFrequency());
        rc.setMag(mag);
        rc.setReflectionLoss(rl);
        rc.setReflectionPhase(phase);
        rc.setSWR(swr);
        rc.setR(r_imp);
        rc.setX(x_imp);
        rc.setZ(z_imp);
        return rc;
    }

    private VNACalibratedSample createCalibratedSampleForTransmission(VNABaseSample raw, VNACalibrationPoint calib) {
        VNACalibratedSample rc = new VNACalibratedSample();
        rc.setTransmissionLoss(-(((double)raw.getLoss() - calib.getLoss()) * 0.05865102639296188));
        rc.setTransmissionPhase((double)raw.getAngle() * 0.17595307917888564);
        rc.setFrequency(raw.getFrequency());
        return rc;
    }

    @Override
    public VNACalibrationContext createCalibrationContextForCalibratedSamples(VNACalibrationBlock calBlock) {
        TraceHelper.entry(this, "createCalibrationContextForCalibratedSamples");
        VNADriverSerialStdDIB dib = (VNADriverSerialStdDIB)calBlock.getMathHelper().getDriver().getDeviceInfoBlock();
        VNACalibrationContext context = new VNACalibrationContext();
        context.setDib(dib);
        context.setCalibrationBlock(calBlock);
        context.setScanMode(calBlock.getScanMode());
        TraceHelper.exit(this, "createCalibrationContextForCalibratedSamples");
        return context;
    }

    @Override
    public VNACalibrationContext createCalibrationContextForCalibrationPoints(VNACalibrationBlock calBlock) {
        TraceHelper.entry(this, "createCalibrationContextForCalibrationPoints");
        VNADriverSerialStdDIB dib = (VNADriverSerialStdDIB)calBlock.getMathHelper().getDriver().getDeviceInfoBlock();
        VNACalibrationContext context = new VNACalibrationContext();
        context.setDib(dib);
        context.setCalibrationBlock(calBlock);
        context.setScanMode(calBlock.getScanMode());
        TraceHelper.exit(this, "createCalibrationContextForCalibrationPoints");
        return context;
    }

    @Override
    public VNACalibrationPoint createCalibrationPoint(VNACalibrationContext context, VNABaseSample numOpen, VNABaseSample numShort, VNABaseSample numLoad, VNABaseSample numLoop) {
        if (context.getScanMode().isTransmissionMode()) {
            return this.createCalibrationPointForTransmission(numLoop);
        }
        return this.createCalibrationPointForReflection(numOpen);
    }

    private VNACalibrationPoint createCalibrationPointForReflection(VNABaseSample numOpen) {
        VNACalibrationPoint rc = null;
        rc = new VNACalibrationPoint();
        rc.setFrequency(numOpen.getFrequency());
        rc.setLoss(numOpen.getLoss());
        return rc;
    }

    private VNACalibrationPoint createCalibrationPointForTransmission(VNABaseSample numLoop) {
        VNACalibrationPoint rc = null;
        rc = new VNACalibrationPoint();
        rc.setFrequency(numLoop.getFrequency());
        rc.setLoss(numLoop.getLoss());
        return rc;
    }
}

