/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.std;

import krause.common.TypedProperties;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNAScanMode;
import krause.vna.device.VNAScanModeParameter;
import krause.vna.device.VNASerialDeviceInfoBlock;
import krause.vna.gui.scale.VNAScaleSymbols;
import org.apache.commons.math.complex.Complex;

public class VNADriverSerialStdDIB
extends VNASerialDeviceInfoBlock {
    public static final float DDS_MHZ = 400.0f;
    public static final int DEFAULT_TICKS = 10737418;

    public VNADriverSerialStdDIB() {
        this.reset();
        this.clearScanModeParameters();
        this.addScanModeParameter(new VNAScanModeParameter(VNAScanMode.MODE_REFLECTION, true, false, false, false, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNLOSS, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNPHASE));
        this.addScanModeParameter(new VNAScanModeParameter(VNAScanMode.MODE_TRANSMISSION, false, false, false, true, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONLOSS, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONPHASE));
        this.setShortName("miniVNA");
        this.setLongName("mini radio solutions - miniVNA");
        this.setType("1");
    }

    @Override
    public void restore(TypedProperties config, String prefix) {
        TraceHelper.entry((Object)this, "restore", prefix);
        super.restore(config, prefix);
        this.setDdsTicksPerMHz(config.getLong(String.valueOf(prefix) + "ddsTicks", 10737418L));
        TraceHelper.exit(this, "restore");
    }

    @Override
    public void store(TypedProperties config, String prefix) {
        TraceHelper.entry(this, "store");
        super.store(config, prefix);
        config.putLong(String.valueOf(prefix) + "ddsTicks", this.getDdsTicksPerMHz());
        TraceHelper.exit(this, "store");
    }

    @Override
    public void reset() {
        super.reset();
        this.setMinFrequency(100000L);
        this.setMaxFrequency(180000000L);
        this.setMinLoss(5.0);
        this.setMaxLoss(-70.0);
        this.setMinPhase(0.0);
        this.setMaxPhase(180.0);
        this.setNumberOfSamples(3000);
        this.setDdsTicksPerMHz(10737418L);
        this.setReferenceResistance(new Complex(50.0, 0.0));
    }
}

