/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.proext;

import krause.common.TypedProperties;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNAScanMode;
import krause.vna.device.VNAScanModeParameter;
import krause.vna.device.serial.pro.VNADriverSerialProDIB;
import krause.vna.gui.scale.VNAScaleSymbols;
import org.apache.commons.math.complex.Complex;

public class VNADriverSerialProExtDIB
extends VNADriverSerialProDIB {
    private final long DEFAULT_TICKS = 1000000L;
    private final int DEFAULT_AFTER_COMMAND_DELAY = 100;
    private final long MIN_FREQ = 10000000L;
    private final long MAX_FREQ = 1500000000L;
    private final double MIN_LOSS = 10.0;
    private final double MAX_LOSS = -70.0;
    private String scanCommandReflection;
    private String scanCommandTransmission;
    private int prescaler;

    public VNADriverSerialProExtDIB() {
        TraceHelper.entry(this, "VNADriverSerialProExtDIB");
        this.reset();
        this.clearScanModeParameters();
        this.addScanModeParameter(new VNAScanModeParameter(VNAScanMode.MODE_REFLECTION, true, true, true, false, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNLOSS, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNPHASE));
        this.addScanModeParameter(new VNAScanModeParameter(VNAScanMode.MODE_TRANSMISSION, true, false, false, true, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONLOSS, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONPHASE));
        this.setShortName("miniVNA-pro-extender");
        this.setLongName("mini radio solutions - miniVNA pro extender");
        this.setType("3");
        TraceHelper.exit(this, "VNADriverSerialProExtDIB");
    }

    public int getPrescaler() {
        return this.prescaler;
    }

    public String getScanCommandReflection() {
        return this.scanCommandReflection;
    }

    public String getScanCommandTransmission() {
        return this.scanCommandTransmission;
    }

    @Override
    public void reset() {
        super.reset();
        this.setMinFrequency(10000000L);
        this.setMaxFrequency(1500000000L);
        this.setMinLoss(10.0);
        this.setMaxLoss(-70.0);
        this.setMinPhase(-180.0);
        this.setMaxPhase(180.0);
        this.setNumberOfSamples(10000);
        this.setPrescaler(10);
        this.setScanCommandTransmission("6");
        this.setScanCommandReflection("7");
        this.setAfterCommandDelay(100);
        this.setDdsTicksPerMHz(1000000L);
        this.setReferenceResistance(new Complex(50.0, 0.0));
    }

    @Override
    public void restore(TypedProperties config, String prefix) {
        super.restore(config, prefix);
        this.setDdsTicksPerMHz(config.getInteger(String.valueOf(prefix) + "ddsTicks", 1000000L));
        this.setAfterCommandDelay(config.getInteger(String.valueOf(prefix) + "afterCommandDelay", 100));
        this.setMinFrequency(config.getLong(String.valueOf(prefix) + "freqMin", 10000000L));
        this.setMaxFrequency(config.getLong(String.valueOf(prefix) + "freqMax", 1500000000L));
        this.setFixed6dBOnThru(false);
        this.setFirmwareVersion(1);
    }

    public void setPrescaler(int prescaler) {
        this.prescaler = prescaler;
    }

    public void setScanCommandReflection(String scanCommandReflection) {
        this.scanCommandReflection = scanCommandReflection;
    }

    public void setScanCommandTransmission(String scanCommandTransmission) {
        this.scanCommandTransmission = scanCommandTransmission;
    }
}

