/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.pro;

import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNABaseSample;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.calibrated.VNACalibrationContext;
import krause.vna.data.calibrated.VNACalibrationPoint;
import krause.vna.device.IVNADriver;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.device.VNADriverMathBaseHelper;
import krause.vna.device.serial.pro.VNADriverSerialProDIB;
import org.apache.commons.math.complex.Complex;

public class VNADriverSerialProMathHelper
extends VNADriverMathBaseHelper {
    static final Complex C_1 = new Complex(1.0, 0.0);
    static final double PHASE_CONSTANT = 57.29577951308232;
    static final double R_Minus_One = -1.0;
    static final double R_Plus_One = 1.0;
    static final double R_Zero = 0.0;

    public VNADriverSerialProMathHelper(IVNADriver driver) {
        super(driver);
        TraceHelper.entry(this, "VNADriverSerialProMathHelper");
        TraceHelper.exit(this, "VNADriverSerialProMathHelper");
    }

    @Override
    public void applyFilter(VNABaseSample[] samples) {
        TraceHelper.entry(this, "applyFilter");
        TraceHelper.exit(this, "applyFilter");
    }

    @Override
    public VNACalibratedSample createCalibratedSample(VNACalibrationContext context, VNABaseSample rawSample, VNACalibrationPoint calibPoint) {
        if (context.getScanMode().isTransmissionMode()) {
            return this.createCalibratedSampleForTransmission(context.getDib(), rawSample, calibPoint);
        }
        return this.createCalibratedSampleForReflection(context.getDib(), rawSample, calibPoint);
    }

    private VNACalibratedSample createCalibratedSampleForReflection(VNADeviceInfoBlock dib, VNABaseSample rawSample, VNACalibrationPoint calib) {
        VNACalibratedSample rc = new VNACalibratedSample();
        Complex rhoM = rawSample.asComplex();
        rc.setFrequency(rawSample.getFrequency());
        Complex rho = rhoM.subtract(calib.getE00()).divide(rhoM.multiply(calib.getE11()).subtract(calib.getDeltaE()));
        rc.setRHO(rho);
        rc.setReflectionPhase(rho.getArgument() * 57.29577951308232);
        Complex zComplex50Ohms = dib.getReferenceResistance().multiply(C_1.add(rc.getRHO())).divide(C_1.subtract(rc.getRHO()));
        rc.setZComplex50Ohms(zComplex50Ohms);
        rc.setZ(zComplex50Ohms.abs());
        rc.setX(zComplex50Ohms.getImaginary());
        rc.setR(zComplex50Ohms.getReal());
        double mag = rc.getRHO().abs();
        if (mag > 1.0) {
            mag = 1.0;
        }
        rc.setMag(mag);
        double swr = (1.0 + mag) / (1.0 - mag);
        rc.setSWR(swr);
        double rl = 20.0 * Math.log10(rc.getMag());
        rl = Math.max(rl, this.getDriver().getDeviceInfoBlock().getMaxLoss());
        rc.setReflectionLoss(rl);
        return rc;
    }

    private VNACalibratedSample createCalibratedSampleForTransmission(VNADeviceInfoBlock dib, VNABaseSample rawSample, VNACalibrationPoint calPoint) {
        VNACalibratedSample rc = new VNACalibratedSample();
        rc.setFrequency(rawSample.getFrequency());
        Complex mDUT = new Complex((double)(rawSample.getAngle() - 512) * 0.003, (double)(rawSample.getLoss() - 512) * 0.003);
        Complex gDUT = mDUT.subtract(calPoint.getE11()).divide(calPoint.getDeltaE());
        rc.setMag(gDUT.abs());
        rc.setTransmissionLoss(Math.max(20.0 * Math.log10(rc.getMag()), dib.getMaxLoss()));
        rc.setTransmissionPhase(-gDUT.getArgument() * 57.29577951308232);
        return rc;
    }

    @Override
    public VNACalibrationContext createCalibrationContextForCalibratedSamples(VNACalibrationBlock calBlock) {
        TraceHelper.entry(this, "createCalibrationContextForCalibratedSamples");
        VNADriverSerialProDIB dib = (VNADriverSerialProDIB)calBlock.getMathHelper().getDriver().getDeviceInfoBlock();
        VNACalibrationContext context = new VNACalibrationContext();
        context.setDib(dib);
        context.setCalibrationBlock(calBlock);
        context.setScanMode(calBlock.getScanMode());
        TraceHelper.exit(this, "createCalibrationContextForCalibratedSamples");
        return context;
    }

    @Override
    public VNACalibrationContext createCalibrationContextForCalibrationPoints(VNACalibrationBlock calBlock) {
        TraceHelper.entry(this, "createCalibrationContextForCalibrationPoints");
        VNADriverSerialProDIB dib = (VNADriverSerialProDIB)calBlock.getMathHelper().getDriver().getDeviceInfoBlock();
        VNACalibrationContext context = new VNACalibrationContext();
        context.setCalibrationBlock(calBlock);
        context.setScanMode(calBlock.getScanMode());
        context.setDib(dib);
        TraceHelper.exit(this, "createCalibrationContextForCalibrationPoints");
        return context;
    }

    @Override
    public VNACalibrationPoint createCalibrationPoint(VNACalibrationContext context, VNABaseSample numOpen, VNABaseSample numShort, VNABaseSample numLoad, VNABaseSample numLoop) {
        if (context.getScanMode().isTransmissionMode()) {
            return this.createCalibrationPointForTransmission(context.getDib(), numOpen, numLoop);
        }
        return this.createCalibrationPointForReflection(context.getDib(), numOpen, numShort, numLoad);
    }

    private VNACalibrationPoint createCalibrationPointForReflection(VNADeviceInfoBlock dib, VNABaseSample numOpen, VNABaseSample numShort, VNABaseSample numLoad) {
        VNACalibrationPoint rc = new VNACalibrationPoint();
        Complex cOpen = numOpen.asComplex();
        Complex cShort = numShort.asComplex();
        Complex cLoad = numLoad.asComplex();
        Complex p1 = cShort.multiply(-1.0).subtract(cOpen.multiply(1.0)).multiply(cOpen.subtract(cLoad));
        Complex p2 = cLoad.multiply(0.0).subtract(cOpen.multiply(1.0)).multiply(cShort.subtract(cOpen));
        Complex p3 = cShort.multiply(-1.0).subtract(cOpen.multiply(1.0)).multiply(-1.0);
        Complex p4 = cLoad.multiply(0.0).subtract(cOpen.multiply(1.0)).multiply(-2.0);
        rc.setDeltaE(p1.add(p2).divide(p3.subtract(p4)));
        rc.setE11(cShort.subtract(cOpen).add(rc.getDeltaE().multiply(-2.0)).divide(cShort.multiply(-1.0).subtract(cOpen.multiply(1.0))));
        rc.setE00(cOpen.subtract(cOpen.multiply(1.0).multiply(rc.getE11())).add(rc.getDeltaE().multiply(1.0)));
        rc.setFrequency(numOpen.getFrequency());
        return rc;
    }

    private VNACalibrationPoint createCalibrationPointForTransmission(VNADeviceInfoBlock dib, VNABaseSample numOpen, VNABaseSample numLoop) {
        VNACalibrationPoint rc = new VNACalibrationPoint();
        rc.setFrequency(numLoop.getFrequency());
        rc.setE00(new Complex((double)(numLoop.getAngle() - 512) * 0.003, (double)(numLoop.getLoss() - 512) * 0.003));
        rc.setE11(new Complex((double)(numOpen.getAngle() - 512) * 0.003, (double)(numOpen.getLoss() - 512) * 0.003));
        rc.setDeltaE(rc.getE00().subtract(rc.getE11()));
        return rc;
    }
}

