/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.pro;

import krause.common.TypedProperties;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNAScanMode;
import krause.vna.device.VNAScanModeParameter;
import krause.vna.device.VNASerialDeviceInfoBlock;
import krause.vna.gui.scale.VNAScaleSymbols;

public class VNADriverSerialProDIB
extends VNASerialDeviceInfoBlock {
    public static final int FILTER_NONE = 0;
    public static final int FIRMWARE_ORG = 0;
    public static final int FIRMWARE_2_3 = 1;
    private int firmwareVersion;
    private boolean fixed6dBOnThru = false;
    private double attenOffsetI = 0.0;
    private double attenOffsetQ = 0.0;
    public static final float DDS_MHZ = 520.0f;
    public static final int DEFAULT_TICKS = 0x7E07E0;
    private final long MIN_FREQ = 100000L;
    private final long MAX_FREQ = 200000000L;
    private final double MIN_LOSS = 10.0;
    private final double MAX_LOSS = -90.0;

    public VNADriverSerialProDIB() {
        TraceHelper.entry(this, "VNADriverSerialProDIB");
        this.reset();
        this.clearScanModeParameters();
        this.addScanModeParameter(new VNAScanModeParameter(VNAScanMode.MODE_REFLECTION, true, true, true, false, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNLOSS, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNPHASE));
        this.addScanModeParameter(new VNAScanModeParameter(VNAScanMode.MODE_TRANSMISSION, true, false, false, true, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONLOSS, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONPHASE));
        this.setShortName("miniVNA-pro");
        this.setLongName("mini radio solutions - miniVNA pro");
        this.setType("2");
        TraceHelper.exit(this, "VNADriverSerialProDIB");
    }

    public int getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public boolean isFixed6dBOnThru() {
        return this.fixed6dBOnThru;
    }

    @Override
    public void reset() {
        super.reset();
        this.setMinFrequency(100000L);
        this.setMaxFrequency(200000000L);
        this.setMinLoss(10.0);
        this.setMaxLoss(-90.0);
        this.setMinPhase(-180.0);
        this.setMaxPhase(180.0);
        this.setNumberOfSamples(3000);
        this.setDdsTicksPerMHz(0x7E07E0L);
        this.setAttenOffsetI(0.0);
        this.setAttenOffsetQ(0.0);
    }

    @Override
    public void restore(TypedProperties config, String prefix) {
        TraceHelper.entry((Object)this, "restore", prefix);
        super.restore(config, prefix);
        this.setDdsTicksPerMHz(config.getInteger(String.valueOf(prefix) + "ddsTicks", 0x7E07E0));
        this.setFirmwareVersion(config.getInteger(String.valueOf(prefix) + "firmwareVersion", 1));
        this.setFixed6dBOnThru(config.getBoolean(String.valueOf(prefix) + "fixed6Db", true));
        this.setAttenOffsetI(config.getDouble(String.valueOf(prefix) + "attenuatorOffsetI", 0.0));
        this.setAttenOffsetQ(config.getDouble(String.valueOf(prefix) + "attenuatorOffsetQ", 0.0));
        this.setMinLoss(config.getDouble(String.valueOf(prefix) + "lossMin", 10.0));
        this.setMaxLoss(config.getDouble(String.valueOf(prefix) + "lossMax", -90.0));
        TraceHelper.exit(this, "restore");
    }

    public void setFirmwareVersion(int firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public void setFixed6dBOnThru(boolean fixed6dBOnThru) {
        this.fixed6dBOnThru = fixed6dBOnThru;
    }

    @Override
    public void store(TypedProperties config, String prefix) {
        TraceHelper.entry(this, "store");
        super.store(config, prefix);
        config.putLong(String.valueOf(prefix) + "ddsTicks", this.getDdsTicksPerMHz());
        config.putInteger(String.valueOf(prefix) + "firmwareVersion", this.getFirmwareVersion());
        config.putBoolean(String.valueOf(prefix) + "fixed6Db", this.isFixed6dBOnThru());
        config.putDouble(String.valueOf(prefix) + "attenuatorOffsetI", this.getAttenOffsetI());
        config.putDouble(String.valueOf(prefix) + "attenuatorOffsetQ", this.getAttenOffsetQ());
        config.putLong(String.valueOf(prefix) + "freqMin", this.getMinFrequency());
        config.putLong(String.valueOf(prefix) + "freqMax", this.getMaxFrequency());
        config.putDouble(String.valueOf(prefix) + "lossMin", this.getMinLoss());
        config.putDouble(String.valueOf(prefix) + "lossMax", this.getMaxLoss());
        TraceHelper.exit(this, "store");
    }

    public double getAttenOffsetI() {
        return this.attenOffsetI;
    }

    public void setAttenOffsetI(double attenOffsetI) {
        this.attenOffsetI = attenOffsetI;
    }

    public double getAttenOffsetQ() {
        return this.attenOffsetQ;
    }

    public void setAttenOffsetQ(double attenOffsetQ) {
        this.attenOffsetQ = attenOffsetQ;
    }
}

