/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.pro;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import krause.common.exception.DialogNotImplementedException;
import krause.common.exception.InitializationException;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.IVNABackgroundTaskStatusListener;
import krause.vna.data.VNABaseSample;
import krause.vna.data.VNAFrequencyRange;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.device.IVNAFlashableDevice;
import krause.vna.device.serial.VNADriverSerialBase;
import krause.vna.device.serial.pro.VNADriverSerialProDIB;
import krause.vna.device.serial.pro.VNADriverSerialProMathHelper;
import krause.vna.device.serial.pro.VNADriverSerialProMessages;
import krause.vna.device.serial.pro.generator.VNAGeneratorProDialog;
import krause.vna.device.serial.pro.gui.VNADriverSerialProDialog;
import krause.vna.firmware.MegaLoadLoader;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.calibrate.mode1.VNACalibrationRange;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class VNADriverSerialPro
extends VNADriverSerialBase
implements IVNAFlashableDevice {
    private static final int NUM_BYTES_PER_SAMPLE = 8;

    public VNADriverSerialPro() {
        TraceHelper.entry(this, "VNADriverSerialPro");
        this.setMathHelper(new VNADriverSerialProMathHelper(this));
        this.setDeviceInfoBlock(new VNADriverSerialProDIB());
        this.getDeviceInfoBlock().restore(this.config, this.getDriverConfigPrefix());
        TraceHelper.exit(this, "VNADriverSerialPro");
    }

    @Override
    public long calculateInternalFrequencyValue(long frequency) {
        TraceHelper.entry((Object)this, "calculateInternalFrequencyValue", "In=" + frequency);
        long rc = (long)((double)frequency / 1000000.0 * (double)this.getDeviceInfoBlock().getDdsTicksPerMHz());
        TraceHelper.exitWithRC((Object)this, "calculateInternalFrequencyValue", rc);
        return rc;
    }

    @Override
    public void destroy() {
        String methodName = "destroy";
        TraceHelper.entry(this, "destroy");
        if (this.getPort() != null) {
            TraceHelper.text(this, "destroy", "closing " + this.getPort().getName());
            this.getPort().close();
            this.setPort(null);
            TraceHelper.text(this, "destroy", "port closed");
        }
        TraceHelper.exit(this, "destroy");
    }

    @Override
    public String getDeviceFirmwareInfo() {
        String methodName = "readFirmwareVersion";
        TraceHelper.entry(this, "readFirmwareVersion");
        String rc = "???";
        try {
            this.flushInputStream();
            this.sendAsAsciiString("9");
            rc = this.readLine(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TraceHelper.exitWithRC((Object)this, "readFirmwareVersion", rc);
        return rc;
    }

    @Override
    public Double getDeviceSupply() {
        Double rc;
        block16: {
            String methodName = "getDeviceSupply";
            TraceHelper.entry(this, "getDeviceSupply");
            rc = null;
            InputStream stream = null;
            if (this.getPort() != null) {
                try {
                    try {
                        this.flushInputStream();
                        this.sendAsAsciiString("8");
                        byte[] innerdata = new byte[2];
                        int ch = this.readBuffer(innerdata, 0, 2);
                        if (ch == -1) {
                            ProcessingException e = new ProcessingException("No chars received");
                            ErrorLogHelper.exception(this, "getDeviceSupply", e);
                            throw e;
                        }
                        rc = (double)(((innerdata[0] & 0xFF) + (innerdata[1] & 0xFF) * 256) * 6) / 1024.0;
                    }
                    catch (ProcessingException processingException) {
                        if (stream != null) {
                            try {
                                stream.close();
                                stream = null;
                            }
                            catch (IOException e) {
                                ErrorLogHelper.exception(this, "getDeviceSupply", e);
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                            stream = null;
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "getDeviceSupply", e);
                        }
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                        stream = null;
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "getDeviceSupply", e);
                    }
                }
            }
        }
        TraceHelper.exitWithRC((Object)this, "getDeviceSupply", rc);
        return rc;
    }

    @Override
    public String getDriverConfigPrefix() {
        return "VNADriver.Serial.Pro.";
    }

    @Override
    public String getFirmwareLoaderClassName() {
        return MegaLoadLoader.class.getName();
    }

    @Override
    public VNACalibrationRange[] getSpecificCalibrationRanges() {
        long min = this.getDeviceInfoBlock().getMinFrequency();
        long max = this.getDeviceInfoBlock().getMaxFrequency();
        return new VNACalibrationRange[]{new VNACalibrationRange(min, 999999L, 4000, 1), new VNACalibrationRange(1000000L, 9999999L, 4000, 1), new VNACalibrationRange(10000000L, 29999999L, 10000, 1), new VNACalibrationRange(30000000L, max, 10000, 1)};
    }

    @Override
    public boolean hasResetButton() {
        return true;
    }

    @Override
    public void init() throws InitializationException {
        String methodeName = "init";
        TraceHelper.entry(this, "init");
        super.init();
        VNADriverSerialProDIB dib = (VNADriverSerialProDIB)this.getDeviceInfoBlock();
        dib.restore(this.config, this.getDriverConfigPrefix());
        TraceHelper.text(this, "init", "Trying to open port [" + this.getPortname() + "]");
        try {
            CommPortIdentifier portId = this.getPortIDForName(this.getPortname());
            if (portId == null) {
                InitializationException e = new InitializationException("Port [" + this.getPortname() + "] not found");
                ErrorLogHelper.exception(this, "init", e);
                throw e;
            }
            TraceHelper.text(this, "init", "port [" + this.getPortname() + "] found");
            SerialPort aPort = (SerialPort)portId.open(this.getAppname(), dib.getOpenTimeout());
            TraceHelper.text(this, "init", "port [" + this.getPortname() + "] opened");
            aPort.setFlowControlMode(0);
            TraceHelper.text(this, "init", "port [" + this.getPortname() + "] set to [" + dib.getBaudrate() + "]bd");
            aPort.setSerialPortParams(dib.getBaudrate(), 8, 1, 0);
            aPort.enableReceiveTimeout(dib.getReadTimeout());
            aPort.setInputBufferSize(32000);
            TraceHelper.text(this, "init", "port [" + this.getPortname() + "] setup done");
            this.setPort(aPort);
        }
        catch (PortInUseException e) {
            ErrorLogHelper.exception(this, "init", (Exception)((Object)e));
            throw new InitializationException(e);
        }
        catch (UnsupportedCommOperationException e) {
            ErrorLogHelper.exception(this, "init", (Exception)((Object)e));
            throw new InitializationException(e);
        }
        catch (Throwable t) {
            ErrorLogHelper.text(this, "init", t.getMessage());
            throw new InitializationException(t);
        }
        TraceHelper.exit(this, "init");
    }

    @Override
    public boolean isScanSupported(int numSamples, VNAFrequencyRange range, VNAScanMode mode) {
        return true;
    }

    protected VNABaseSample[] receiveRawMessage(long pStartFrequency, int pNumSamples, long pFrequencyStep, IVNABackgroundTaskStatusListener pListener) throws ProcessingException {
        String methodName = "receiveRawMessage";
        TraceHelper.entry((Object)this, "receiveRawMessage", "fs=" + pStartFrequency + " #=" + pNumSamples);
        InputStream stream = null;
        VNABaseSample[] rc = new VNABaseSample[pNumSamples];
        if (pListener != null) {
            pListener.publishProgress(0);
        }
        try {
            try {
                int remainingBytes = 8 * pNumSamples;
                byte[] buffer = new byte[remainingBytes];
                stream = this.getPort().getInputStream();
                int readBytes = 0;
                long startTime = System.currentTimeMillis();
                long endTime = startTime + this.getTimeoutBasedOnNumberOfSamples(this.getPort(), pNumSamples);
                while (remainingBytes > 0) {
                    if (stream.available() > 0) {
                        int currBytesRead = stream.read(buffer, readBytes, remainingBytes);
                        TraceHelper.text(this, "receiveRawMessage", "req=" + (remainingBytes -= currBytesRead) + "# act=" + currBytesRead + "# totally read=" + (readBytes += currBytesRead) + " remain=" + remainingBytes);
                        if (pListener != null) {
                            int perc = (int)((double)readBytes * 100.0 / (double)(readBytes + remainingBytes));
                            pListener.publishProgress(perc);
                        }
                    }
                    if (System.currentTimeMillis() <= endTime) continue;
                    String msg = MessageFormat.format(VNADriverSerialProMessages.getString("NoChars"), readBytes, remainingBytes);
                    ProcessingException e = new ProcessingException(msg);
                    ErrorLogHelper.exception(this, "receiveRawMessage", e);
                    throw e;
                }
                TraceHelper.text(this, "receiveRawMessage", "all bytes read");
                long currentFrequency = pStartFrequency;
                int i = 0;
                while (i < pNumSamples) {
                    int offset = i * 8;
                    VNABaseSample tempSample = new VNABaseSample();
                    int p1 = (buffer[offset + 0] & 0xFF) + (buffer[offset + 1] & 0xFF) * 256;
                    int p2 = (buffer[offset + 4] & 0xFF) + (buffer[offset + 5] & 0xFF) * 256;
                    int real = (p1 - p2) / 2;
                    int p3 = (buffer[offset + 2] & 0xFF) + (buffer[offset + 3] & 0xFF) * 256;
                    int p4 = (buffer[offset + 6] & 0xFF) + (buffer[offset + 7] & 0xFF) * 256;
                    int imaginary = (p3 - p4) / 2;
                    tempSample.setLoss(real);
                    tempSample.setAngle(imaginary);
                    tempSample.setFrequency(currentFrequency);
                    tempSample.p1 = p1;
                    tempSample.p2 = p2;
                    tempSample.p3 = p3;
                    tempSample.p4 = p4;
                    tempSample.hasPData = true;
                    rc[i] = tempSample;
                    currentFrequency += pFrequencyStep;
                    ++i;
                }
                TraceHelper.text(this, "receiveRawMessage", "Last frequency stored was " + (currentFrequency - pFrequencyStep));
                if (pListener != null) {
                    pListener.publishProgress(100);
                }
            }
            catch (IOException e) {
                ErrorLogHelper.exception(this, "receiveRawMessage", e);
                throw new ProcessingException(e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                    stream = null;
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "receiveRawMessage", e);
                }
            }
        }
        TraceHelper.exit(this, "receiveRawMessage");
        return rc;
    }

    @Override
    public VNASampleBlock scan(VNAScanMode mode, long frequencyLow, long frequencyHigh, int requestedSamples, IVNABackgroundTaskStatusListener listener) throws ProcessingException {
        String methodName = "scan";
        TraceHelper.entry((Object)this, "scan", "mode=" + mode + " low=" + frequencyLow + " high=" + frequencyHigh + " #=" + requestedSamples);
        VNASampleBlock rc = new VNASampleBlock();
        if (this.getPort() != null) {
            VNADriverSerialProDIB dib = (VNADriverSerialProDIB)this.getDeviceInfoBlock();
            rc.setDeviceTemperature(this.getDeviceTemperature());
            rc.setDeviceSupply(this.getDeviceSupply());
            this.flushInputStream();
            if (mode.isTransmissionMode()) {
                if (dib.isFixed6dBOnThru()) {
                    this.sendAsAsciiString("20");
                } else {
                    this.sendAsAsciiString("0");
                }
            } else if (mode.isReflectionMode()) {
                this.sendAsAsciiString("1");
            } else {
                throw new ProcessingException("Unsupported scan mode " + mode);
            }
            this.sendFrequency(frequencyLow);
            this.sendAsAsciiString("0");
            boolean oldVNA = dib.getFirmwareVersion() < 1;
            int realSamples = requestedSamples;
            if (oldVNA) {
                if (requestedSamples < 100) {
                    realSamples = 100;
                } else if (requestedSamples % 100 != 0) {
                    realSamples = (requestedSamples / 100 + 1) * 100;
                }
            }
            this.sendAsAsciiString(Integer.toString(realSamples));
            long frequencyStep = (frequencyHigh - frequencyLow) / (long)realSamples;
            this.sendFrequency(frequencyStep);
            TraceHelper.text(this, "scan", "Start           " + frequencyLow);
            TraceHelper.text(this, "scan", "Stop            " + frequencyHigh);
            TraceHelper.text(this, "scan", "Steps requested " + requestedSamples);
            TraceHelper.text(this, "scan", "Steps scanned   " + realSamples);
            TraceHelper.text(this, "scan", "Hertz per Step  " + frequencyStep);
            TraceHelper.text(this, "scan", "Last            " + (frequencyLow + (long)(realSamples - 1) * frequencyStep));
            VNABaseSample[] readSamples = this.receiveRawMessage(frequencyLow, realSamples, frequencyStep, listener);
            if (requestedSamples != realSamples) {
                VNABaseSample[] newSamples = new VNABaseSample[requestedSamples];
                int i = 0;
                while (i < requestedSamples) {
                    newSamples[i] = readSamples[i];
                    ++i;
                }
                rc.setSamples(newSamples);
            } else {
                rc.setSamples(readSamples);
            }
            rc.setScanMode(mode);
            rc.setNumberOfSteps(requestedSamples);
            rc.setStartFrequency(frequencyLow);
            rc.setStopFrequency(frequencyHigh);
            rc.setAnalyserType(this.getDeviceInfoBlock().getType());
            rc.setMathHelper(this.getMathHelper());
        }
        TraceHelper.exit(this, "scan");
        return rc;
    }

    protected void sendAttenuation(int att) throws ProcessingException {
        String msg = VNADriverSerialPro.getFrequencyFormat().format(Math.pow(10.0, (60.2 - (double)att / 100.0) / 20.0));
        this.sendAsAsciiString(msg);
    }

    protected void sendFrequency(long frq) throws ProcessingException {
        String msg = VNADriverSerialPro.getFrequencyFormat().format((double)frq / 1000000.0 * (double)this.getDeviceInfoBlock().getDdsTicksPerMHz());
        this.sendAsAsciiString(msg);
    }

    protected void sendPhase(int phase) throws ProcessingException {
        String msg = VNADriverSerialPro.getFrequencyFormat().format((double)phase / 100.0 / 180.0 * 8192.0);
        this.sendAsAsciiString(msg);
    }

    @Override
    public void showDriverDialog(VNAMainFrame pMF) {
        TraceHelper.entry(this, "showDriverDialog");
        VNADriverSerialProDialog dlg = new VNADriverSerialProDialog(pMF, this);
        dlg.dispose();
        TraceHelper.exit(this, "showDriverDialog");
    }

    @Override
    public void showGeneratorDialog(VNAMainFrame pMF) throws DialogNotImplementedException {
        TraceHelper.entry(this, "showGeneratorDialog");
        VNAGeneratorProDialog dlg = new VNAGeneratorProDialog(pMF, this);
        dlg.showInPlace();
        TraceHelper.exit(this, "showGeneratorDialog");
    }

    @Override
    public void startGenerator(long frequencyI, long frequencyQ, int attenuationI, int attenuationQ, int phase, int mainAttenuation) throws ProcessingException {
        String methodName = "startGenerator";
        TraceHelper.entry(this, "startGenerator");
        VNADriverSerialProDIB dib = (VNADriverSerialProDIB)this.getDeviceInfoBlock();
        TraceHelper.text(this, "startGenerator", "fI=" + frequencyI);
        TraceHelper.text(this, "startGenerator", "fQ=" + frequencyQ);
        TraceHelper.text(this, "startGenerator", "aI=" + attenuationI);
        attenuationI = (int)((double)attenuationI + dib.getAttenOffsetI() * 100.0);
        attenuationI = Math.max(0, attenuationI);
        TraceHelper.text(this, "startGenerator", "aI=" + attenuationI + " !corrected");
        TraceHelper.text(this, "startGenerator", "aQ=" + attenuationQ);
        attenuationQ = (int)((double)attenuationQ + dib.getAttenOffsetQ() * 100.0);
        attenuationQ = Math.max(0, attenuationQ);
        TraceHelper.text(this, "startGenerator", "aQ=" + attenuationQ + " !corrected");
        TraceHelper.text(this, "startGenerator", "ph=" + phase);
        if (this.getPort() != null) {
            this.flushInputStream();
            this.sendAsAsciiString("2");
            this.sendFrequency(frequencyI);
            this.sendFrequency(frequencyQ);
            this.sendPhase(phase);
            this.sendAsAsciiString("3");
            this.sendAttenuation(attenuationQ);
            this.sendAttenuation(attenuationI);
            try {
                Thread.sleep(dib.getAfterCommandDelay());
            }
            catch (InterruptedException e) {
                ErrorLogHelper.exception(this, "startGenerator", e);
                throw new ProcessingException(e);
            }
        }
        TraceHelper.exit(this, "startGenerator");
    }

    @Override
    public void stopGenerator() throws ProcessingException {
        String methodName = "stopGenerator";
        TraceHelper.entry(this, "stopGenerator");
        if (this.getPort() != null) {
            this.flushInputStream();
            this.sendAsAsciiString("2");
            this.sendFrequency(0L);
            this.sendFrequency(0L);
            this.sendAsAsciiString("0");
            this.sendAsAsciiString("3");
            this.sendAsAsciiString("0");
            this.sendAsAsciiString("0");
            VNADriverSerialProDIB dib = (VNADriverSerialProDIB)this.getDeviceInfoBlock();
            try {
                Thread.sleep(dib.getAfterCommandDelay());
            }
            catch (InterruptedException e) {
                ErrorLogHelper.exception(this, "stopGenerator", e);
                throw new ProcessingException(e);
            }
        }
        TraceHelper.exit(this, "stopGenerator");
    }

    @Override
    public boolean supportsAutoReset() {
        return true;
    }

    @Override
    public int getBootloadBaudRate() {
        VNADriverSerialProDIB dib = (VNADriverSerialProDIB)this.getDeviceInfoBlock();
        return dib.getBaudrate();
    }
}

