/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.metro;

import krause.common.TypedProperties;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNAScanMode;
import krause.vna.device.VNAScanModeParameter;
import krause.vna.device.VNASerialDeviceInfoBlock;
import krause.vna.gui.scale.VNAScaleSymbols;
import org.apache.commons.math.complex.Complex;

public class VNADriverSerialMetroDIB
extends VNASerialDeviceInfoBlock {
    public static final float DDS_MHZ = 400.0f;
    public static final int DEFAULT_TICKS = 10737418;
    public static final long MAX_FREQUENCY = 4400000000L;
    public static final double MAX_RETURNLOSS = -60.0;
    public static final double MAX_TRANSMISSIONLOSS = -76.0;
    public static final double MAX_PHASE = 180.0;
    public static final long MIN_FREQUENCY = 100000L;
    public static final double MIN_LOSS = 5.0;
    public static final double MIN_PHASE = 0.0;
    public static final boolean INVERT_REFLECTION_LOSS = true;
    public static final boolean INVERT_TRANSMISSION_LOSS = true;
    private double maxReflectionLoss;
    private double maxTransmissionLoss;

    public VNADriverSerialMetroDIB() {
        this.reset();
        this.clearScanModeParameters();
        this.addScanModeParameter(new VNAScanModeParameter(VNAScanMode.MODE_REFLECTION, true, false, false, false, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNLOSS, VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNPHASE));
        this.addScanModeParameter(new VNAScanModeParameter(VNAScanMode.MODE_TRANSMISSION, false, false, false, true, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONLOSS, VNAScaleSymbols.SCALE_TYPE.SCALE_TRANSMISSIONPHASE));
        this.setShortName("MetroVNA");
        this.setLongName("IZ7LDG - MetroVNA");
        this.setType("30");
    }

    public double getMaxReflectionLoss() {
        return this.maxReflectionLoss;
    }

    public double getMaxTransmissionLoss() {
        return this.maxTransmissionLoss;
    }

    @Override
    public void reset() {
        super.reset();
        this.setMinFrequency(100000L);
        this.setMaxFrequency(180000000L);
        this.setMinPhase(0.0);
        this.setMaxPhase(180.0);
        this.setNumberOfSamples(3000);
        this.setDdsTicksPerMHz(10737418L);
        this.setReferenceResistance(new Complex(50.0, 0.0));
        this.setMaxReflectionLoss(-60.0);
        this.setMaxTransmissionLoss(-76.0);
        this.setMinLoss(5.0);
        this.setMaxLoss(-76.0);
    }

    @Override
    public void restore(TypedProperties config, String prefix) {
        TraceHelper.entry((Object)this, "restore", prefix);
        super.restore(config, prefix);
        this.setDdsTicksPerMHz(config.getLong(String.valueOf(prefix) + "ddsTicks", 10737418L));
        this.setMaxTransmissionLoss(config.getDouble(String.valueOf(prefix) + "maxTransmissionLoss", -76.0));
        this.setMaxReflectionLoss(config.getDouble(String.valueOf(prefix) + "maxReflectionLoss", -60.0));
        this.setMinLoss(config.getDouble(String.valueOf(prefix) + "minLoss", 5.0));
        this.setMinFrequency(config.getLong(String.valueOf(prefix) + "minFrequency", 100000L));
        this.setMaxFrequency(config.getLong(String.valueOf(prefix) + "maxFrequency", 180000000L));
        TraceHelper.exit(this, "restore");
    }

    public void setMaxReflectionLoss(double maxReflectionLoss) {
        this.maxReflectionLoss = maxReflectionLoss;
    }

    public void setMaxTransmissionLoss(double maxTransmissionLoss) {
        this.maxTransmissionLoss = maxTransmissionLoss;
    }

    @Override
    public void store(TypedProperties config, String prefix) {
        TraceHelper.entry(this, "store");
        super.store(config, prefix);
        config.putLong(String.valueOf(prefix) + "ddsTicks", this.getDdsTicksPerMHz());
        config.putDouble(String.valueOf(prefix) + "minLoss", this.getMinLoss());
        config.putDouble(String.valueOf(prefix) + "maxTransmissionLoss", this.getMaxTransmissionLoss());
        config.putDouble(String.valueOf(prefix) + "maxReflectionLoss", this.getMaxReflectionLoss());
        config.putLong(String.valueOf(prefix) + "minFrequency", this.getMinFrequency());
        config.putLong(String.valueOf(prefix) + "maxFrequency", this.getMaxFrequency());
        TraceHelper.exit(this, "store");
    }
}

