/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.metro;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import krause.common.exception.DialogNotImplementedException;
import krause.common.exception.InitializationException;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.IVNABackgroundTaskStatusListener;
import krause.vna.data.VNABaseSample;
import krause.vna.data.VNAFrequencyRange;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.device.VNASerialDeviceInfoBlock;
import krause.vna.device.serial.VNADriverSerialBase;
import krause.vna.device.serial.metro.VNADriverSerialMetroDIB;
import krause.vna.device.serial.metro.VNADriverSerialMetroMathHelper;
import krause.vna.device.serial.metro.VNADriverSerialMetroMessages;
import krause.vna.device.serial.metro.gui.VNADriverSerialMetroDialog;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.calibrate.mode1.VNACalibrationRange;
import krause.vna.gui.generator.VNAGeneratorDialog;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class VNADriverSerialMetro
extends VNADriverSerialBase {
    private static final int NUM_BYTES_PER_SAMPLE = 4;

    public VNADriverSerialMetro() {
        this.setMathHelper(new VNADriverSerialMetroMathHelper(this));
        this.setDeviceInfoBlock(new VNADriverSerialMetroDIB());
        this.getDeviceInfoBlock().restore(this.config, this.getDriverConfigPrefix());
    }

    @Override
    public long calculateInternalFrequencyValue(long frequency) {
        TraceHelper.entry((Object)this, "calculateInternalFrequencyValue", "In=" + frequency);
        long rc = (long)((double)frequency / 1000000.0 * (double)this.getDeviceInfoBlock().getDdsTicksPerMHz());
        TraceHelper.exitWithRC((Object)this, "calculateInternalFrequencyValue", rc);
        return rc;
    }

    @Override
    public void destroy() {
        String methodName = "destroy";
        TraceHelper.entry(this, "destroy");
        if (this.getPort() != null) {
            this.getPort().close();
            this.setPort(null);
        }
        TraceHelper.exit(this, "destroy");
    }

    @Override
    public String getDeviceFirmwareInfo() {
        return "???";
    }

    @Override
    public Double getDeviceSupply() {
        return 5.0;
    }

    @Override
    public String getDriverConfigPrefix() {
        return "VNADriver.Serial.MetroVNA.";
    }

    @Override
    public VNACalibrationRange[] getSpecificCalibrationRanges() {
        return new VNACalibrationRange[]{new VNACalibrationRange(this.getDeviceInfoBlock().getMinFrequency(), this.getDeviceInfoBlock().getMaxFrequency(), 30000, 1)};
    }

    @Override
    public void init() throws InitializationException {
        String methodeName = "init";
        TraceHelper.entry(this, "init");
        super.init();
        VNADriverSerialMetroDIB dib = (VNADriverSerialMetroDIB)this.getDeviceInfoBlock();
        dib.restore(this.config, this.getDriverConfigPrefix());
        try {
            CommPortIdentifier portId = this.getPortIDForName(this.getPortname());
            if (portId == null) {
                InitializationException e = new InitializationException("Port [" + this.getPortname() + "] not found");
                ErrorLogHelper.exception(this, "init", e);
                throw e;
            }
            this.setPort((SerialPort)portId.open(this.getAppname(), dib.getOpenTimeout()));
            this.getPort().setFlowControlMode(0);
            this.getPort().setSerialPortParams(dib.getBaudrate(), 8, 2, 0);
            this.getPort().enableReceiveTimeout(dib.getReadTimeout());
            this.getPort().setInputBufferSize(65536);
        }
        catch (PortInUseException e) {
            ErrorLogHelper.exception(this, "init", (Exception)((Object)e));
            throw new InitializationException(e);
        }
        catch (UnsupportedCommOperationException e) {
            ErrorLogHelper.exception(this, "init", (Exception)((Object)e));
            throw new InitializationException(e);
        }
        catch (Throwable t) {
            ErrorLogHelper.text(this, "init", t.getMessage());
            throw new InitializationException(t);
        }
        TraceHelper.exit(this, "init");
    }

    @Override
    public boolean isScanSupported(int numSamples, VNAFrequencyRange range, VNAScanMode mode) {
        return true;
    }

    @Override
    public VNASampleBlock scan(VNAScanMode pScanMode, long pFrequencyLow, long pFrequencyHigh, int pSamples, IVNABackgroundTaskStatusListener pListener) throws ProcessingException {
        String methodName = "scan";
        TraceHelper.entry(this, "scan");
        long frequencyStep = (pFrequencyHigh - pFrequencyLow) / (long)pSamples;
        VNASampleBlock rc = new VNASampleBlock();
        rc.setAnalyserType(this.getDeviceInfoBlock().getType());
        rc.setScanMode(pScanMode);
        rc.setNumberOfSteps(pSamples);
        rc.setStartFrequency(pFrequencyLow);
        rc.setStopFrequency(pFrequencyHigh);
        rc.setMathHelper(this.getMathHelper());
        if (this.getPort() != null) {
            this.flushInputStream();
            if (pScanMode.isTransmissionMode()) {
                this.sendAsAsciiString("1");
            } else if (pScanMode.isReflectionMode()) {
                this.sendAsAsciiString("0");
            } else {
                throw new ProcessingException("Unsupported scan mode " + pScanMode);
            }
            this.sendFrequency(pFrequencyLow);
            this.sendAsAsciiString(Integer.toString(pSamples));
            this.sendFrequency(frequencyStep);
            rc.setSamples(this.receiveRawMessage(pScanMode, pFrequencyLow, pSamples, frequencyStep, pListener));
            this.stopGenerator();
        }
        TraceHelper.exit(this, "scan");
        return rc;
    }

    protected void sendFrequency(long frq) throws ProcessingException {
        String msg = VNADriverSerialMetro.getFrequencyFormat().format((double)frq / 1000000.0 * (double)this.getDeviceInfoBlock().getDdsTicksPerMHz());
        TraceHelper.text(this, "sendFrequency", msg);
        this.sendAsAsciiString(msg);
    }

    @Override
    public void showDriverDialog(VNAMainFrame pMF) {
        TraceHelper.entry(this, "showDriverDialog");
        VNADriverSerialMetroDialog dlg = new VNADriverSerialMetroDialog(pMF, this);
        dlg.dispose();
        TraceHelper.exit(this, "showDriverDialog");
    }

    @Override
    public void showGeneratorDialog(VNAMainFrame pMF) throws DialogNotImplementedException {
        TraceHelper.entry(this, "showGeneratorDialog");
        new VNAGeneratorDialog(pMF, this);
        TraceHelper.exit(this, "showGeneratorDialog");
    }

    @Override
    public void startGenerator(long frequencyI, long frequencyQ, int attenuationI, int attenuationQ, int phase, int mainAttenuation) throws ProcessingException {
        TraceHelper.entry(this, "startGenerator");
        TraceHelper.entry((Object)this, "startGenerator", "" + frequencyI);
        if (this.getPort() != null) {
            this.flushInputStream();
            this.sendAsAsciiString("0");
            this.sendFrequency(frequencyI);
            this.sendAsAsciiString("1");
            this.sendAsAsciiString("0");
            this.receiveRawMessage(VNAScanMode.MODE_TRANSMISSION, 0L, 1, 1L, null);
            try {
                VNASerialDeviceInfoBlock dib = (VNASerialDeviceInfoBlock)this.getDeviceInfoBlock();
                Thread.sleep(dib.getAfterCommandDelay());
            }
            catch (InterruptedException e) {
                ErrorLogHelper.exception(this, "startGenerator", e);
                throw new ProcessingException(e);
            }
        }
        TraceHelper.exit(this, "startGenerator");
    }

    @Override
    public void stopGenerator() throws ProcessingException {
        String methodName = "stopGenerator";
        TraceHelper.entry(this, "stopGenerator");
        if (this.getPort() != null) {
            this.flushInputStream();
            this.sendAsAsciiString("0");
            this.sendFrequency(0L);
            this.sendAsAsciiString("1");
            this.sendAsAsciiString("0");
            this.receiveRawMessage(VNAScanMode.MODE_TRANSMISSION, 0L, 1, 1L, null);
            try {
                VNASerialDeviceInfoBlock dib = (VNASerialDeviceInfoBlock)this.getDeviceInfoBlock();
                Thread.sleep(dib.getAfterCommandDelay());
            }
            catch (InterruptedException e) {
                ErrorLogHelper.exception(this, "startGenerator", e);
                throw new ProcessingException(e);
            }
        }
        TraceHelper.exit(this, "stopGenerator");
    }

    private VNABaseSample[] receiveRawMessage(VNAScanMode pScanMode, long frequency, int pNumSamples, long frequencyStep, IVNABackgroundTaskStatusListener listener) throws ProcessingException {
        String methodName = "receiveRawMessage";
        TraceHelper.entry((Object)this, "receiveRawMessage", "fStart=" + frequency + " #=" + pNumSamples + " fStep=" + frequencyStep);
        InputStream stream = null;
        VNABaseSample[] rc = new VNABaseSample[pNumSamples];
        if (listener != null) {
            listener.publishProgress(0);
        }
        try {
            try {
                int remainingBytes = 4 * pNumSamples;
                byte[] buffer = new byte[remainingBytes];
                stream = this.getPort().getInputStream();
                int readBytes = 0;
                long endTime = System.currentTimeMillis() + this.getTimeoutBasedOnNumberOfSamples(this.getPort(), pNumSamples);
                while (remainingBytes > 0) {
                    if (stream.available() > 0) {
                        TraceHelper.text(this, "receiveRawMessage", "try to read " + remainingBytes + " bytes");
                        int currBytesRead = stream.read(buffer, readBytes, remainingBytes);
                        TraceHelper.text(this, "receiveRawMessage", "read=" + (readBytes += currBytesRead) + " remain=" + (remainingBytes -= currBytesRead));
                        if (listener != null) {
                            int perc = (int)((double)readBytes * 100.0 / (double)(readBytes + remainingBytes));
                            listener.publishProgress(perc);
                        }
                    }
                    if (System.currentTimeMillis() <= endTime || remainingBytes <= 0) continue;
                    String msg = MessageFormat.format(VNADriverSerialMetroMessages.getString("NoChars"), readBytes, remainingBytes);
                    ProcessingException e = new ProcessingException(msg);
                    ErrorLogHelper.exception(this, "receiveRawMessage", e);
                    throw e;
                }
                TraceHelper.text(this, "receiveRawMessage", "all bytes read");
                long localFrequency = frequency;
                int i = 0;
                while (i < pNumSamples) {
                    int offset = i * 4;
                    VNABaseSample tempSample = new VNABaseSample();
                    tempSample.setAngle((buffer[offset] & 0xFF) + 256 * (buffer[offset + 1] & 0xFF));
                    tempSample.setLoss((buffer[offset + 2] & 0xFF) + 256 * (buffer[offset + 3] & 0xFF));
                    tempSample.setFrequency(localFrequency);
                    rc[i] = tempSample;
                    localFrequency += frequencyStep;
                    ++i;
                }
            }
            catch (IOException e) {
                ErrorLogHelper.exception(this, "receiveRawMessage", e);
                throw new ProcessingException(e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                    stream = null;
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "receiveRawMessage", e);
                }
            }
        }
        TraceHelper.exit(this, "receiveRawMessage");
        return rc;
    }
}

