/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.max6;

import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNABaseSample;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.calibrated.VNACalibrationContext;
import krause.vna.data.calibrated.VNACalibrationPoint;
import krause.vna.device.IVNADriver;
import krause.vna.device.VNADriverMathBaseHelper;
import krause.vna.device.serial.max6.VNADriverSerialMax6DIB;

public class VNADriverSerialMax6MathHelper
extends VNADriverMathBaseHelper {
    public static final int DEFAULT_ADC_BITS = 1024;
    public static final double DEFAULT_PHASE_PER_BIT = 0.17595307917888564;
    public static final double DEFAULT_TRANSMISSION_SCALE = 0.145;
    public static final double DEFAULT_TRANSMISSION_OFFSET = 0.0;
    public static final double DEFAULT_REFLECTION_OFFSET = 0.0;
    public static final double DEFAULT_REFLECTION_SCALE = 0.05865103;
    public static final double DEFAULT_RSS_OFFSET = 80.0;
    public static final double DEFAULT_RSS_SCALE = 0.145;
    public final double RAD2DEG = 57.29577951308232;
    public final double R_50 = 50.0;

    public VNADriverSerialMax6MathHelper(IVNADriver driver) {
        super(driver);
    }

    @Override
    public VNACalibratedSample createCalibratedSample(VNACalibrationContext context, VNABaseSample rawSample, VNACalibrationPoint calibPoint) {
        VNADriverSerialMax6DIB myDib = (VNADriverSerialMax6DIB)context.getDib();
        if (context.getScanMode().isRss1Mode()) {
            return this.createCalibratedSampleForRss1(myDib, rawSample, calibPoint);
        }
        if (context.getScanMode().isRss3Mode()) {
            return this.createCalibratedSampleForRss3(myDib, rawSample, calibPoint);
        }
        if (context.getScanMode().isReflectionMode()) {
            return this.createCalibratedSampleForReflectionMode0(myDib, rawSample, calibPoint);
        }
        return null;
    }

    private VNACalibratedSample createCalibratedSampleForReflectionMode0(VNADriverSerialMax6DIB dib, VNABaseSample raw, VNACalibrationPoint calib) {
        double rl = -(((double)raw.getLoss() - calib.getLoss()) * dib.getReflectionScale() - dib.getReflectionOffset());
        double phase = (double)raw.getAngle() * 0.17595307917888564;
        double mag = Math.pow(10.0, rl / 20.0);
        double swr = Math.abs((1.0 + mag) / (1.0 - mag));
        double f = Math.cos(phase / 57.29577951308232);
        double g = Math.sin(phase / 57.29577951308232);
        double rr = f * mag;
        double ss = g * mag;
        double x_imp = Math.abs(2.0 * ss / ((1.0 - rr) * (1.0 - rr) + ss * ss) * dib.getReferenceResistance().getReal());
        double r_imp = Math.abs((1.0 - rr * rr - ss * ss) / ((1.0 - rr) * (1.0 - rr) + ss * ss) * dib.getReferenceResistance().getReal());
        double z_imp = Math.sqrt(r_imp * r_imp + x_imp * x_imp);
        VNACalibratedSample rc = new VNACalibratedSample();
        rc.setFrequency(raw.getFrequency());
        rc.setMag(mag);
        rc.setReflectionLoss(rl);
        rc.setSWR(swr);
        rc.setReflectionPhase(phase);
        rc.setR(r_imp);
        rc.setX(x_imp);
        rc.setZ(z_imp);
        return rc;
    }

    private VNACalibratedSample createCalibratedSampleForRss1(VNADriverSerialMax6DIB dib, VNABaseSample raw, VNACalibrationPoint calib) {
        VNACalibratedSample rc = this.createCalibratedSampleForReflectionMode2(dib, raw, calib);
        rc.setTransmissionLoss(-((double)(calib.getRss1() - raw.getRss1()) * dib.getTransmissionScale()));
        rc.setRelativeSignalStrength1((double)raw.getRss1() * dib.getRss1Scale() - dib.getRss1Offset());
        return rc;
    }

    private VNACalibratedSample createCalibratedSampleForRss3(VNADriverSerialMax6DIB dib, VNABaseSample raw, VNACalibrationPoint calib) {
        VNACalibratedSample rc = this.createCalibratedSampleForRss1(dib, raw, calib);
        rc.setRelativeSignalStrength2((double)(raw.getRss2() - calib.getRss2()) * dib.getRss2Scale() - dib.getRss2Offset());
        rc.setRelativeSignalStrength3((double)(raw.getRss3() - calib.getRss3()) * dib.getRss3Scale() - dib.getRss3Offset());
        return rc;
    }

    @Override
    public VNACalibrationPoint createCalibrationPoint(VNACalibrationContext context, VNABaseSample pOpen, VNABaseSample pShort, VNABaseSample pLoad, VNABaseSample pLoop) {
        if (context.getScanMode().isRss1Mode()) {
            return this.createCalibrationPointForRss1(pOpen, pLoop);
        }
        if (context.getScanMode().isRss3Mode()) {
            return this.createCalibrationPointForRss3(pOpen, pLoop);
        }
        if (context.getScanMode().isReflectionMode()) {
            return this.createCalibrationPointForReflection(pOpen);
        }
        return null;
    }

    private VNACalibrationPoint createCalibrationPointForReflection(VNABaseSample numOpen) {
        VNACalibrationPoint rc = null;
        rc = new VNACalibrationPoint();
        rc.setFrequency(numOpen.getFrequency());
        rc.setLoss(numOpen.getLoss());
        return rc;
    }

    private VNACalibrationPoint createCalibrationPointForRss1(VNABaseSample numOpen, VNABaseSample numLoop) {
        VNACalibrationPoint rc = null;
        rc = new VNACalibrationPoint();
        rc.setFrequency(numLoop.getFrequency());
        rc.setLoss(numOpen.getLoss());
        rc.setRss1(numLoop.getRss1());
        return rc;
    }

    private VNACalibrationPoint createCalibrationPointForRss3(VNABaseSample numOpen, VNABaseSample numLoop) {
        VNACalibrationPoint rc = null;
        rc = new VNACalibrationPoint();
        rc.setFrequency(numLoop.getFrequency());
        rc.setLoss(numLoop.getLoss());
        rc.setRss1(numLoop.getRss1());
        rc.setRss2(numLoop.getRss2());
        rc.setRss3(numLoop.getRss3());
        return rc;
    }

    private VNACalibratedSample createCalibratedSampleForReflectionMode2(VNADriverSerialMax6DIB dib, VNABaseSample raw, VNACalibrationPoint calib) {
        double rl = -(-(calib.getLoss() - (double)raw.getLoss()) * dib.getReflectionScale() - dib.getReflectionOffset());
        double phase = (double)raw.getAngle() * 0.17595307917888564;
        double mag = Math.pow(10.0, rl / 20.0);
        double swr = Math.abs((1.0 + mag) / (1.0 - mag));
        double f = Math.cos(phase / 57.29577951308232);
        double g = Math.sin(phase / 57.29577951308232);
        double rr = f * mag;
        double ss = g * mag;
        double x_imp = Math.abs(2.0 * ss / ((1.0 - rr) * (1.0 - rr) + ss * ss) * 50.0);
        double r_imp = Math.abs((1.0 - rr * rr - ss * ss) / ((1.0 - rr) * (1.0 - rr) + ss * ss) * 50.0);
        double z_imp = Math.sqrt(r_imp * r_imp + x_imp * x_imp);
        VNACalibratedSample rc = new VNACalibratedSample();
        rc.setFrequency(raw.getFrequency());
        rc.setMag(mag);
        rc.setReflectionLoss(rl);
        rc.setSWR(swr);
        rc.setReflectionPhase(phase);
        rc.setR(r_imp);
        rc.setX(x_imp);
        rc.setZ(z_imp);
        return rc;
    }

    @Override
    public void applyFilter(VNABaseSample[] samples) {
        TraceHelper.entry(this, "applyFilter");
        TraceHelper.exit(this, "applyFilter");
    }

    @Override
    public VNACalibrationContext createCalibrationContextForCalibratedSamples(VNACalibrationBlock calBlock) {
        TraceHelper.entry(this, "createCalibrationContextForCalibratedSamples");
        VNADriverSerialMax6DIB dib = (VNADriverSerialMax6DIB)calBlock.getMathHelper().getDriver().getDeviceInfoBlock();
        VNACalibrationContext context = new VNACalibrationContext();
        context.setDib(dib);
        context.setCalibrationBlock(calBlock);
        context.setScanMode(calBlock.getScanMode());
        TraceHelper.exit(this, "createCalibrationContextForCalibratedSamples");
        return context;
    }

    @Override
    public VNACalibrationContext createCalibrationContextForCalibrationPoints(VNACalibrationBlock calBlock) {
        TraceHelper.entry(this, "createCalibrationContextForCalibrationPoints");
        VNADriverSerialMax6DIB dib = (VNADriverSerialMax6DIB)calBlock.getMathHelper().getDriver().getDeviceInfoBlock();
        VNACalibrationContext context = new VNACalibrationContext();
        context.setDib(dib);
        context.setCalibrationBlock(calBlock);
        context.setScanMode(calBlock.getScanMode());
        TraceHelper.exit(this, "createCalibrationContextForCalibrationPoints");
        return context;
    }
}

