/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial.max6;

import java.text.MessageFormat;
import krause.common.exception.DialogNotImplementedException;
import krause.common.exception.InitializationException;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.IVNABackgroundTaskStatusListener;
import krause.vna.data.VNABaseSample;
import krause.vna.data.VNAFrequencyRange;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.device.serial.VNADriverSerialBase;
import krause.vna.device.serial.max6.VNADriverSerialMax6DIB;
import krause.vna.device.serial.max6.VNADriverSerialMax6MathHelper;
import krause.vna.device.serial.max6.VNADriverSerialMax6Messages;
import krause.vna.device.serial.max6.gui.VNADriverSerialMax6Dialog;
import krause.vna.device.serial.max6.gui.VNAGeneratorMAX6Dialog;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.calibrate.mode1.VNACalibrationRange;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class VNADriverSerialMax6
extends VNADriverSerialBase {
    public VNADriverSerialMax6() {
        this.setMathHelper(new VNADriverSerialMax6MathHelper(this));
        this.setDeviceInfoBlock(new VNADriverSerialMax6DIB());
        this.getDeviceInfoBlock().restore(this.config, this.getDriverConfigPrefix());
    }

    @Override
    public void init() throws InitializationException {
        String methodeName = "init";
        TraceHelper.entry(this, "init");
        super.init();
        VNADriverSerialMax6DIB dib = (VNADriverSerialMax6DIB)this.getDeviceInfoBlock();
        dib.restore(this.config, this.getDriverConfigPrefix());
        try {
            CommPortIdentifier portId = this.getPortIDForName(this.getPortname());
            if (portId == null) {
                InitializationException e = new InitializationException("Port [" + this.getPortname() + "] not found");
                ErrorLogHelper.exception(this, "init", e);
                throw e;
            }
            this.setPort((SerialPort)portId.open(this.getAppname(), dib.getOpenTimeout()));
            this.getPort().setFlowControlMode(0);
            this.getPort().setSerialPortParams(dib.getBaudrate(), 8, 1, 0);
            this.getPort().enableReceiveTimeout(dib.getReadTimeout());
            this.getPort().setInputBufferSize(20000);
            TraceHelper.text(this, "init", "getReceiveThreshold=" + this.getPort().getReceiveThreshold());
            TraceHelper.text(this, "init", "getInputBufferSize=" + this.getPort().getInputBufferSize());
        }
        catch (PortInUseException e) {
            ErrorLogHelper.exception(this, "init", (Exception)((Object)e));
            throw new InitializationException(e);
        }
        catch (UnsupportedCommOperationException e) {
            ErrorLogHelper.exception(this, "init", (Exception)((Object)e));
            throw new InitializationException(e);
        }
        catch (Throwable t) {
            ErrorLogHelper.text(this, "init", t.getMessage());
            throw new InitializationException(t);
        }
        TraceHelper.exit(this, "init");
    }

    private VNABaseSample[] receiveRawMessage(VNADriverSerialMax6DIB dib, VNAScanMode mode, long frequency, int samples, long frequencyStep, IVNABackgroundTaskStatusListener listener) throws ProcessingException {
        String methodName = "receiveRawMessage";
        TraceHelper.entry(this, "receiveRawMessage");
        VNABaseSample[] rc = new VNABaseSample[samples];
        int totalChars = 0;
        long localFrequency = frequency;
        byte[] innerdata = new byte[20];
        if (listener != null) {
            listener.publishProgress(0);
        }
        int i = 0;
        while (i < samples) {
            int read;
            if (listener != null && i % 100 == 0) {
                listener.publishProgress((int)((double)i * 100.0 / (double)samples));
            }
            VNABaseSample tempSample = new VNABaseSample();
            if (mode.isRss1Mode()) {
                read = this.readBuffer(innerdata, 0, 6);
                if (read != 6) {
                    String msg = MessageFormat.format(VNADriverSerialMax6Messages.getString("NoChars"), i, read);
                    ProcessingException e = new ProcessingException(msg);
                    ErrorLogHelper.exception(this, "receiveRawMessage", e);
                    throw e;
                }
                totalChars += read;
                tempSample.setAngle((innerdata[0] & 0xFF) + 256 * (innerdata[1] & 0xFF));
                tempSample.setLoss((innerdata[2] & 0xFF) + 256 * (innerdata[3] & 0xFF));
                tempSample.setRss1((innerdata[4] & 0xFF) + 256 * (innerdata[5] & 0xFF));
                tempSample.setFrequency(localFrequency);
            } else if (mode.isRss3Mode()) {
                read = this.readBuffer(innerdata, 0, 10);
                if (read != 10) {
                    String msg = MessageFormat.format(VNADriverSerialMax6Messages.getString("NoChars"), i, read);
                    ProcessingException e = new ProcessingException(msg);
                    ErrorLogHelper.exception(this, "receiveRawMessage", e);
                    throw e;
                }
                totalChars += read;
                tempSample.setAngle((innerdata[0] & 0xFF) + 256 * (innerdata[1] & 0xFF));
                tempSample.setLoss((innerdata[2] & 0xFF) + 256 * (innerdata[3] & 0xFF));
                tempSample.setRss1((innerdata[4] & 0xFF) + 256 * (innerdata[5] & 0xFF));
                tempSample.setRss2((innerdata[6] & 0xFF) + 256 * (innerdata[7] & 0xFF));
                tempSample.setRss3((innerdata[8] & 0xFF) + 256 * (innerdata[9] & 0xFF));
                tempSample.setFrequency(localFrequency);
            } else if (mode.isReflectionMode()) {
                read = this.readBuffer(innerdata, 0, 4);
                if (read != 4) {
                    String msg = MessageFormat.format(VNADriverSerialMax6Messages.getString("NoChars"), i, read);
                    ProcessingException e = new ProcessingException(msg);
                    ErrorLogHelper.exception(this, "receiveRawMessage", e);
                    throw e;
                }
                totalChars += read;
                tempSample.setAngle((innerdata[0] & 0xFF) + 256 * (innerdata[1] & 0xFF));
                tempSample.setLoss((innerdata[2] & 0xFF) + 256 * (innerdata[3] & 0xFF));
                tempSample.setFrequency(localFrequency);
            }
            rc[i] = tempSample;
            localFrequency += frequencyStep;
            ++i;
        }
        if (listener != null) {
            listener.publishProgress(100);
        }
        TraceHelper.exitWithRC((Object)this, "receiveRawMessage", String.valueOf(totalChars) + " chars received");
        return rc;
    }

    @Override
    public void destroy() {
        String methodName = "destroy";
        TraceHelper.entry(this, "destroy");
        if (this.getPort() != null) {
            this.getPort().close();
            this.setPort(null);
        }
        TraceHelper.exit(this, "destroy");
    }

    protected void sendFrequency(long frq) throws ProcessingException {
        String msg = VNADriverSerialMax6.getFrequencyFormat().format((double)frq / 1000000.0 * (double)this.getDeviceInfoBlock().getDdsTicksPerMHz());
        TraceHelper.text(this, "sendFrequency", msg);
        this.sendAsAsciiString(msg);
    }

    @Override
    public VNASampleBlock scan(VNAScanMode mode, long frequencyLow, long frequencyHigh, int samples, IVNABackgroundTaskStatusListener listener) throws ProcessingException {
        String methodName = "scan";
        TraceHelper.entry(this, "scan");
        long frequencyStep = (frequencyHigh - frequencyLow) / (long)samples;
        VNADriverSerialMax6DIB dib = (VNADriverSerialMax6DIB)this.getDeviceInfoBlock();
        VNASampleBlock rc = new VNASampleBlock();
        rc.setAnalyserType(this.getDeviceInfoBlock().getType());
        rc.setScanMode(mode);
        rc.setNumberOfSteps(samples);
        rc.setStartFrequency(frequencyLow);
        rc.setStopFrequency(frequencyHigh);
        rc.setMathHelper(this.getMathHelper());
        try {
            if (this.getPort() != null) {
                this.flushInputStream();
                if (mode.isRss1Mode()) {
                    this.sendAsAsciiString("M2");
                } else if (mode.isRss3Mode()) {
                    this.sendAsAsciiString("M3");
                } else if (mode.isReflectionMode()) {
                    this.sendAsAsciiString("M0");
                } else {
                    throw new ProcessingException("Unsupported scan mode " + mode);
                }
                Thread.sleep(dib.getAfterCommandDelay());
                this.sendFrequency(frequencyLow);
                Thread.sleep(dib.getAfterCommandDelay());
                this.sendAsAsciiString(Integer.toString(samples));
                Thread.sleep(dib.getAfterCommandDelay());
                this.sendFrequency(frequencyStep);
                rc.setSamples(this.receiveRawMessage(dib, mode, frequencyLow, samples, frequencyStep, listener));
            }
        }
        catch (InterruptedException e) {
            ProcessingException p = new ProcessingException(e);
            ErrorLogHelper.exception(this, "scan", p);
            throw p;
        }
        TraceHelper.exit(this, "scan");
        return rc;
    }

    @Override
    public void stopGenerator() throws ProcessingException {
        String methodName = "stopGenerator";
        TraceHelper.entry(this, "stopGenerator");
        if (this.getPort() != null) {
            this.flushInputStream();
            this.sendAsAsciiString("0");
            this.sendFrequency(0L);
            this.sendAsAsciiString("1");
            this.sendAsAsciiString("0");
        }
        TraceHelper.exit(this, "stopGenerator");
    }

    @Override
    public void showDriverDialog(VNAMainFrame pMF) {
        TraceHelper.entry(this, "showDriverDialog");
        VNADriverSerialMax6Dialog dlg = new VNADriverSerialMax6Dialog(pMF, this);
        dlg.dispose();
        TraceHelper.exit(this, "showDriverDialog");
    }

    @Override
    public long calculateInternalFrequencyValue(long frequency) {
        TraceHelper.entry((Object)this, "calculateInternalFrequencyValue", "In=" + frequency);
        long rc = (long)((double)frequency / 1000000.0 * (double)this.getDeviceInfoBlock().getDdsTicksPerMHz());
        TraceHelper.exitWithRC((Object)this, "calculateInternalFrequencyValue", rc);
        return rc;
    }

    @Override
    public void showGeneratorDialog(VNAMainFrame pMF) throws DialogNotImplementedException {
        TraceHelper.entry(this, "showGeneratorDialog");
        new VNAGeneratorMAX6Dialog(pMF, this);
        TraceHelper.exit(this, "showGeneratorDialog");
    }

    @Override
    public String getDeviceFirmwareInfo() {
        String rc = "";
        String methodName = "readFirmwareVersion";
        TraceHelper.entry(this, "readFirmwareVersion");
        try {
            rc = String.valueOf(rc) + "Version:";
            rc = String.valueOf(rc) + this.readVersion();
            Thread.sleep(((VNADriverSerialMax6DIB)this.getDeviceInfoBlock()).getAfterCommandDelay());
            rc = String.valueOf(rc) + System.getProperty("line.separator");
            rc = String.valueOf(rc) + "Serial:";
            rc = String.valueOf(rc) + this.readSerial();
        }
        catch (InterruptedException e) {
            ErrorLogHelper.exception(this, "readFirmwareVersion", e);
        }
        catch (ProcessingException e) {
            ErrorLogHelper.exception(this, "readFirmwareVersion", e);
        }
        TraceHelper.exitWithRC((Object)this, "readFirmwareVersion", rc);
        return rc;
    }

    private String readVersion() {
        String rc = "???";
        String methodName = "readVersion";
        TraceHelper.entry(this, "readVersion");
        try {
            this.flushInputStream();
            this.sendAsAsciiString("version");
            rc = this.readLine(false);
            rc = String.valueOf(rc) + this.readLine(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TraceHelper.exitWithRC((Object)this, "readVersion", rc);
        return rc;
    }

    private String readSerial() throws ProcessingException {
        String rc = "";
        String methodName = "readSerial";
        TraceHelper.entry(this, "readSerial");
        this.flushInputStream();
        this.sendAsAsciiString("serial");
        rc = this.readLine(true);
        TraceHelper.exitWithRC((Object)this, "readSerial", rc);
        return rc;
    }

    protected void sendAttenuation(int att) throws ProcessingException {
        String msg = VNADriverSerialMax6.getFrequencyFormat().format(16383 - att);
        this.sendAsAsciiString(msg);
    }

    @Override
    public void startGenerator(long frequencyI, long frequencyQ, int attenuationI, int attenuationQ, int phase, int mainAttenuation) throws ProcessingException {
        String methodName = "startGenerator";
        TraceHelper.entry(this, "startGenerator");
        TraceHelper.text(this, "startGenerator", "fI=" + frequencyI);
        TraceHelper.text(this, "startGenerator", "fQ=" + frequencyQ);
        TraceHelper.text(this, "startGenerator", "aI=" + attenuationI);
        TraceHelper.text(this, "startGenerator", "aQ=" + attenuationQ);
        TraceHelper.text(this, "startGenerator", "ph=" + phase);
        if (this.getPort() != null) {
            this.flushInputStream();
            this.sendAsAsciiString("M4");
            this.sendFrequency(frequencyI);
            this.sendAsAsciiString("1");
            this.sendAsAsciiString("0");
            this.sendAttenuation(attenuationI);
            this.receiveRawMessage(null, VNAScanMode.MODE_RSS3, frequencyI, 1, 0L, null);
        }
        TraceHelper.exit(this, "startGenerator");
    }

    @Override
    public String getDriverConfigPrefix() {
        return "VNADriver.Serial.MAX6.";
    }

    @Override
    public Double getDeviceSupply() {
        return 5.0;
    }

    @Override
    public boolean isScanSupported(int numSamples, VNAFrequencyRange range, VNAScanMode mode) {
        return true;
    }

    @Override
    public VNACalibrationRange[] getSpecificCalibrationRanges() {
        return new VNACalibrationRange[]{new VNACalibrationRange(this.getDeviceInfoBlock().getMinFrequency(), this.getDeviceInfoBlock().getMaxFrequency(), 30000, 1)};
    }
}

