/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import krause.common.exception.InitializationException;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.device.VNAGenericDriver;
import krause.vna.gui.OptionDialogHelper;
import krause.vna.gui.VNAMainFrame;
import purejavacomm.CommPort;
import purejavacomm.CommPortIdentifier;
import purejavacomm.SerialPort;

public abstract class VNADriverSerialBase
extends VNAGenericDriver {
    private SerialPort port;
    private CommPort commPort;
    private String appname;
    private static NumberFormat theFormat = null;
    public static final int DEFAULT_INPUTBUFFER_SIZE = 32000;

    public static NumberFormat getFrequencyFormat() {
        if (theFormat == null) {
            theFormat = NumberFormat.getNumberInstance(Locale.US);
            theFormat.setGroupingUsed(false);
            theFormat.setMaximumFractionDigits(0);
            theFormat.setMinimumFractionDigits(0);
        }
        return theFormat;
    }

    @Override
    public final List<String> getPortList() throws ProcessingException {
        String methodeName = "getPortList";
        ArrayList<String> rc = new ArrayList<String>();
        TraceHelper.entry(this, "getPortList");
        try {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                String name;
                CommPortIdentifier portId = null;
                portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1 || "tty".equals(name = portId.getName())) continue;
                if (name.startsWith("tty")) {
                    String sName = name.substring(3);
                    try {
                        Integer.parseInt(sName);
                    }
                    catch (NumberFormatException e) {
                        rc.add(name);
                    }
                    continue;
                }
                rc.add(name);
            }
        }
        catch (Throwable t) {
            ProcessingException p = new ProcessingException(t);
            ErrorLogHelper.exception(this, "getPortList", p);
            throw p;
        }
        TraceHelper.exitWithRC((Object)this, "getPortList", rc);
        return rc;
    }

    @Override
    public void init() throws InitializationException {
        TraceHelper.entry(this, "init");
        super.init();
        this.appname = this.config.getProperty(String.valueOf(this.getDriverConfigPrefix()) + "appname", "VNA-J2");
        TraceHelper.exit(this, "init");
    }

    public void flushInputStream() {
        TraceHelper.entry(this, "flushInputStream");
        int cnt = 0;
        int read = 0;
        int avl = 0;
        try {
            do {
                if ((avl = this.port.getInputStream().available()) <= 0) continue;
                byte[] tempBuffer = new byte[avl];
                read = this.port.getInputStream().read(tempBuffer);
                ErrorLogHelper.text(this, "flushInputStream", "Flushed " + read + " chars");
                cnt += read;
                Thread.sleep(20L);
            } while (avl > 0);
        }
        catch (Exception e) {
            ErrorLogHelper.exception(this, "flushInputStream", e);
        }
        if (cnt > 0) {
            ErrorLogHelper.text(this, "flushInputStream", "total " + cnt + " chars flushed from stream");
        }
        TraceHelper.exit(this, "flushInputStream");
    }

    protected void sendAsAsciiString(String buffer) throws ProcessingException {
        String methodName = "sendAscii";
        OutputStream oStream = null;
        TraceHelper.entry((Object)this, "sendAscii", buffer);
        try {
            try {
                String local = String.valueOf(buffer) + "\r";
                byte[] tbuf = local.getBytes("ASCII");
                oStream = this.port.getOutputStream();
                oStream.write(tbuf);
            }
            catch (UnsupportedEncodingException e) {
                ErrorLogHelper.exception(this, "sendAscii", e);
                throw new ProcessingException(e);
            }
            catch (IOException e) {
                ErrorLogHelper.exception(this, "sendAscii", e);
                throw new ProcessingException(e);
            }
        }
        finally {
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "sendAscii", e);
                }
            }
        }
        TraceHelper.exit(this, "sendAscii");
    }

    public SerialPort getPort() {
        return this.port;
    }

    public void setPort(SerialPort port) {
        this.port = port;
    }

    public String getAppname() {
        return this.appname;
    }

    public void setAppname(String appname) {
        this.appname = appname;
    }

    @Override
    public void showDriverNetworkDialog(VNAMainFrame pMF) {
        OptionDialogHelper.showInfoDialog(pMF.getJFrame(), "VNADriverSerialBase.Network.1", "VNADriverSerialBase.Network.2");
    }

    public void setCommPort(CommPort commPort) {
        this.commPort = commPort;
    }

    public CommPort getCommPort() {
        return this.commPort;
    }

    protected CommPortIdentifier getPortIDForName(String portname) {
        CommPortIdentifier rc = null;
        TraceHelper.entry((Object)this, "getPortIDForName", portname);
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier aPortId = (CommPortIdentifier)portList.nextElement();
            if (aPortId.getPortType() != 1 || !aPortId.getName().equals(this.getPortname())) continue;
            rc = aPortId;
            break;
        }
        TraceHelper.exitWithRC((Object)this, "getPortIDForName", rc);
        return rc;
    }

    /*
     * Exception decompiling
     */
    protected int readBuffer(byte[] buffer, int offset, int count) throws ProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int readChar() throws ProcessingException {
        int rc = -1;
        try {
            long endTime = System.currentTimeMillis() + (long)this.port.getReceiveTimeout();
            InputStream stream = this.port.getInputStream();
            while (stream.available() == 0) {
                Thread.sleep(10L);
                if (System.currentTimeMillis() <= endTime) continue;
                return rc;
            }
            rc = stream.read();
        }
        catch (Exception e) {
            ErrorLogHelper.exception(this, "readChar", e);
            throw new ProcessingException(e);
        }
        return rc;
    }

    public String readLine(boolean endWithLF) throws ProcessingException {
        String rc = new String();
        boolean end = false;
        while (!end) {
            int ch = this.readChar();
            if (ch == -1) {
                ProcessingException e = new ProcessingException("Timeout");
                ErrorLogHelper.exception(this, "readLine", e);
                throw e;
            }
            char c = (char)ch;
            if (c == '\r') {
                if (endWithLF) continue;
                end = true;
                continue;
            }
            if (c == '\n') {
                if (!endWithLF) continue;
                end = true;
                continue;
            }
            rc = String.valueOf(rc) + (char)ch;
        }
        return rc;
    }

    public void wait(int ms) throws ProcessingException {
        String methodName = "wait";
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            ErrorLogHelper.exception(this, "wait", e);
            throw new ProcessingException(e);
        }
    }

    protected long getTimeoutBasedOnNumberOfSamples(SerialPort port, int pNumSamples) {
        TraceHelper.entry((Object)this, "getTimeoutBasedOnNumberOfSamples", "samples=" + pNumSamples);
        int rto = port.getReceiveTimeout();
        TraceHelper.text(this, "getTimeoutBasedOnNumberOfSamples", "port.receiveTimeOut=" + rto);
        long rc = rto * (1 + pNumSamples / 500);
        TraceHelper.exitWithRC((Object)this, "getTimeoutBasedOnNumberOfSamples", "to=" + rc);
        return rc;
    }
}

