/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.sample;

import java.util.ArrayList;
import java.util.List;
import krause.common.TypedProperties;
import krause.common.exception.DialogNotImplementedException;
import krause.common.exception.InitializationException;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.IVNABackgroundTaskStatusListener;
import krause.vna.data.VNABaseSample;
import krause.vna.data.VNAFrequencyRange;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.device.VNAGenericDriver;
import krause.vna.device.sample.VNADriverSampleDIB;
import krause.vna.device.sample.VNADriverSampleDialog;
import krause.vna.device.sample.VNADriverSampleMathHelper;
import krause.vna.gui.OptionDialogHelper;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.calibrate.mode1.VNACalibrationRange;

public class VNADriverSample
extends VNAGenericDriver {
    public VNADriverSample() {
        this.setMathHelper(new VNADriverSampleMathHelper(this));
        this.setDeviceInfoBlock(new VNADriverSampleDIB());
        this.getDeviceInfoBlock().restore(this.config, this.getDriverConfigPrefix());
    }

    @Override
    public long calculateInternalFrequencyValue(long frequency) {
        TraceHelper.entry((Object)this, "calculateInternalFrequencyValue", "in=" + frequency);
        long rc = frequency;
        TraceHelper.exitWithRC((Object)this, "calculateInternalFrequencyValue", rc);
        return rc;
    }

    @Override
    public void destroy() {
        TraceHelper.entry(this, "destroy");
        TraceHelper.exit(this, "destroy");
    }

    @Override
    public String getDeviceFirmwareInfo() {
        return "Sample Driver V1.0";
    }

    @Override
    public Double getDeviceSupply() {
        return 5.0;
    }

    @Override
    public String getDriverConfigPrefix() {
        return "VNADriver.Sample.";
    }

    @Override
    public List<String> getPortList() {
        ArrayList<String> rc = new ArrayList<String>();
        rc.add("DummySamplePort");
        return rc;
    }

    @Override
    public VNACalibrationRange[] getSpecificCalibrationRanges() {
        VNACalibrationRange[] rc = null;
        long min = this.getDeviceInfoBlock().getMinFrequency();
        long max = this.getDeviceInfoBlock().getMaxFrequency();
        rc = new VNACalibrationRange[]{new VNACalibrationRange(min, max, 20000, 1)};
        return rc;
    }

    @Override
    public void init() throws InitializationException {
        super.init();
        TraceHelper.entry(this, "init");
        this.getDeviceInfoBlock().restore(this.config, this.getDriverConfigPrefix());
        TraceHelper.exit(this, "init");
    }

    public void init(TypedProperties vnaConfig) throws InitializationException {
        TraceHelper.entry(this, "init");
        TraceHelper.exit(this, "init");
    }

    @Override
    public boolean isScanSupported(int numSamples, VNAFrequencyRange range, VNAScanMode mode) {
        return true;
    }

    @Override
    public VNASampleBlock scan(VNAScanMode scanMode, long frequencyLow, long frequencyHigh, int samples, IVNABackgroundTaskStatusListener listener) {
        TraceHelper.entry(this, "scan");
        VNASampleBlock rc = new VNASampleBlock();
        rc.setAnalyserType(this.getDeviceInfoBlock().getType());
        long freqSteps = (frequencyHigh - frequencyLow) / (long)samples;
        rc.setNumberOfSteps(samples);
        rc.setStartFrequency(frequencyLow);
        rc.setStopFrequency(frequencyHigh);
        rc.setScanMode(scanMode);
        rc.setMathHelper(this.getMathHelper());
        VNABaseSample[] rawSamples = new VNABaseSample[samples];
        double offset = Math.random();
        double factor = offset * (double)samples;
        int i = 0;
        while (i < samples) {
            if (i % 100 == 0) {
                listener.publishProgress((int)((double)i * 100.0 / (double)samples));
            }
            VNABaseSample sample = new VNABaseSample();
            sample.setFrequency(frequencyLow + freqSteps * (long)i);
            sample.setAngle(512 + (int)(512.0 * Math.sin(offset + (double)i / factor) * Math.cos(offset + (double)i / factor)));
            sample.setLoss(512 + (int)(512.0 * Math.cos(offset - (double)i / factor) * Math.sin(offset + (double)i / factor)));
            sample.setRss1(512 + (int)(237.0 * Math.cos(offset + (double)i / factor) * Math.sin(offset + (double)i / factor)));
            sample.setRss2(512 + (int)(148.0 * Math.cos(offset + (double)i / factor) * Math.sin(offset + (double)i / factor)));
            sample.setRss3(512 + (int)(347.0 * Math.cos(offset + (double)i / factor) * Math.sin(offset + (double)i / factor)));
            rawSamples[i] = sample;
            ++i;
        }
        rc.setSamples(rawSamples);
        TraceHelper.exit(this, "scan");
        return rc;
    }

    @Override
    public void showDriverDialog(VNAMainFrame pMF) {
        TraceHelper.entry(this, "showDriverDialog");
        VNADriverSampleDialog dlg = new VNADriverSampleDialog(pMF, this);
        dlg.dispose();
        TraceHelper.exit(this, "showDriverDialog");
    }

    @Override
    public void showDriverNetworkDialog(VNAMainFrame pMF) {
        TraceHelper.entry(this, "showDriverNetworkDialog");
        OptionDialogHelper.showInfoDialog(pMF.getJFrame(), "VNADriverSerialBase.Network.1", "VNADriverSerialBase.Network.2");
        TraceHelper.exit(this, "showDriverNetworkDialog");
    }

    @Override
    public void showGeneratorDialog(VNAMainFrame pMF) throws DialogNotImplementedException {
        TraceHelper.entry(this, "showGeneratorDialog");
        throw new DialogNotImplementedException();
    }

    @Override
    public void startGenerator(long frequencyI, long frequencyQ, int attenuationI, int attenuationQ, int phase, int mainAttenuation) throws ProcessingException {
        TraceHelper.entry(this, "startGenerator");
        TraceHelper.exit(this, "startGenerator");
    }

    @Override
    public void stopGenerator() throws ProcessingException {
        TraceHelper.entry(this, "stopGenerator");
        TraceHelper.exit(this, "stopGenerator");
    }
}

