/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import krause.common.exception.InitializationException;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.IVNABackgroundTaskStatusListener;
import krause.vna.data.VNASampleBlock;
import krause.vna.device.VNAGenericDriver;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.net.VNANetworkDialog;
import krause.vna.net.data.VNAClientRequest;
import krause.vna.net.data.VNAServerResponse;
import krause.vna.resources.VNAMessages;

public abstract class VNADriverNetBase
extends VNAGenericDriver {
    protected int timeout;
    protected String ip;
    protected int port;

    @Override
    public void destroy() {
        TraceHelper.entry(this, "destroy");
        TraceHelper.exit(this, "destroy");
    }

    @Override
    public final List<String> getPortList() {
        ArrayList<String> rc = new ArrayList<String>();
        TraceHelper.entry(this, "getPortList");
        rc.add(VNAMessages.getString("VNADriverNetBase.portInfo"));
        TraceHelper.exit(this, "getPortList");
        return rc;
    }

    @Override
    public void init() throws InitializationException {
        String methodeName = "init";
        TraceHelper.entry(this, "init");
        this.getDeviceInfoBlock().restore(this.config, this.getDriverConfigPrefix());
        TraceHelper.exit(this, "init");
    }

    public VNASampleBlock scan(boolean pTransMissionMode, long pFrequencyLow, long pFrequencyHigh, int pNumSamples, IVNABackgroundTaskStatusListener listener) throws ProcessingException {
        VNASampleBlock rc;
        block21: {
            String methodName = "runVNA";
            rc = null;
            TraceHelper.entry(this, "runVNA");
            ObjectInputStream inStream = null;
            ObjectOutputStream outStream = null;
            Socket serverConn = null;
            try {
                try {
                    serverConn = new Socket(this.getDeviceInfoBlock().getRemoteAddress(), this.getDeviceInfoBlock().getRemotePort());
                    serverConn.setSoTimeout(this.getDeviceInfoBlock().getRemoteTimeout());
                    outStream = new ObjectOutputStream(serverConn.getOutputStream());
                    VNAClientRequest req = new VNAClientRequest(VNAClientRequest.CLIENT_CMDS.SCAN, this.getDeviceInfoBlock());
                    req.setNumberOfSamples(pNumSamples);
                    req.setStartFrequency(pFrequencyLow);
                    req.setStopFrequency(pFrequencyHigh);
                    req.setTransmissionMode(pTransMissionMode);
                    outStream.writeObject(req);
                    TraceHelper.text(this, "runVNA", "Request send class=" + req.getClass().getSimpleName());
                    inStream = new ObjectInputStream(serverConn.getInputStream());
                    Object obj = inStream.readObject();
                    TraceHelper.text(this, "runVNA", "Object received class=" + obj.getClass().getSimpleName());
                    if (!(obj instanceof VNAServerResponse)) break block21;
                    TraceHelper.text(this, "runVNA", "VNAServerResponse received");
                    VNAServerResponse resp = (VNAServerResponse)obj;
                    TraceHelper.text(this, "runVNA", "Response type=" + (Object)((Object)resp.getResponseType()));
                    if (resp.getResponseType() == VNAServerResponse.SERVER_RESPONSES.SCAN_DATA) {
                        rc = resp.getData();
                        rc.setAnalyserType(this.getDeviceInfoBlock().getType());
                        rc.setMathHelper(this.getMathHelper());
                        break block21;
                    }
                    TraceHelper.text(this, "runVNA", "Response info=" + resp.getInfoText());
                    throw new ProcessingException(resp.getInfoText());
                }
                catch (Exception e) {
                    ErrorLogHelper.exception(this, "runVNA", e);
                    throw new ProcessingException(e);
                }
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "runVNA", e);
                    }
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "runVNA", e);
                    }
                }
                if (serverConn != null) {
                    try {
                        serverConn.close();
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "runVNA", e);
                    }
                }
            }
        }
        TraceHelper.exit(this, "runVNA");
        return rc;
    }

    public void startGenerator(int frequencyI, int frequencyQ, int attenuationI, int attenuationQ, int phase, int mainAttenuation) throws ProcessingException {
        String methodName = "startGenerator";
        ObjectInputStream inStream = null;
        ObjectOutputStream outStream = null;
        Socket serverConn = null;
        try {
            try {
                serverConn = new Socket(this.getDeviceInfoBlock().getRemoteAddress(), this.getDeviceInfoBlock().getRemotePort());
                serverConn.setSoTimeout(this.getDeviceInfoBlock().getRemoteTimeout());
                outStream = new ObjectOutputStream(serverConn.getOutputStream());
                VNAClientRequest req = new VNAClientRequest(VNAClientRequest.CLIENT_CMDS.START_GEN, this.getDeviceInfoBlock());
                req.setAttenuationI(attenuationI);
                req.setAttenuationQ(attenuationQ);
                req.setFrequencyI(frequencyI);
                req.setFrequencyQ(frequencyQ);
                req.setMainAttenuation(mainAttenuation);
                outStream.writeObject(req);
                TraceHelper.text(this, "startGenerator", "Request send class=" + req.getClass().getSimpleName());
                inStream = new ObjectInputStream(serverConn.getInputStream());
                Object obj = inStream.readObject();
                TraceHelper.text(this, "startGenerator", "Object received class=" + obj.getClass().getSimpleName());
                if (obj instanceof VNAServerResponse) {
                    TraceHelper.text(this, "startGenerator", "VNAServerResponse received");
                    VNAServerResponse resp = (VNAServerResponse)obj;
                    TraceHelper.text(this, "startGenerator", "Response type=" + (Object)((Object)resp.getResponseType()));
                    if (resp.getResponseType() != VNAServerResponse.SERVER_RESPONSES.GEN_STARTED) {
                        TraceHelper.text(this, "startGenerator", "Response info=" + resp.getInfoText());
                        throw new ProcessingException(resp.getInfoText());
                    }
                }
            }
            catch (Exception e) {
                ErrorLogHelper.exception(this, "startGenerator", e);
                throw new ProcessingException(e);
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "startGenerator", e);
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "startGenerator", e);
                }
            }
            if (serverConn != null) {
                try {
                    serverConn.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "startGenerator", e);
                }
            }
        }
        TraceHelper.exit(this, "startGenerator");
    }

    @Override
    public void stopGenerator() throws ProcessingException {
        String methodName = "stopGenerator";
        TraceHelper.entry(this, "stopGenerator");
        ObjectInputStream inStream = null;
        ObjectOutputStream outStream = null;
        Socket serverConn = null;
        try {
            try {
                serverConn = new Socket(this.getDeviceInfoBlock().getRemoteAddress(), this.getDeviceInfoBlock().getRemotePort());
                serverConn.setSoTimeout(this.getDeviceInfoBlock().getRemoteTimeout());
                outStream = new ObjectOutputStream(serverConn.getOutputStream());
                VNAClientRequest req = new VNAClientRequest(VNAClientRequest.CLIENT_CMDS.STOP_GEN, this.getDeviceInfoBlock());
                outStream.writeObject(req);
                TraceHelper.text(this, "stopGenerator", "Request send class=" + req.getClass().getSimpleName());
                inStream = new ObjectInputStream(serverConn.getInputStream());
                Object obj = inStream.readObject();
                TraceHelper.text(this, "stopGenerator", "Object received class=" + obj.getClass().getSimpleName());
                if (obj instanceof VNAServerResponse) {
                    TraceHelper.text(this, "stopGenerator", "VNAServerResponse received");
                    VNAServerResponse resp = (VNAServerResponse)obj;
                    TraceHelper.text(this, "stopGenerator", "Response type=" + (Object)((Object)resp.getResponseType()));
                    if (resp.getResponseType() != VNAServerResponse.SERVER_RESPONSES.GEN_STOPPED) {
                        TraceHelper.text(this, "stopGenerator", "Response info=" + resp.getInfoText());
                        throw new ProcessingException(resp.getInfoText());
                    }
                }
            }
            catch (Exception e) {
                ErrorLogHelper.exception(this, "stopGenerator", e);
                throw new ProcessingException(e);
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "stopGenerator", e);
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "stopGenerator", e);
                }
            }
            if (serverConn != null) {
                try {
                    serverConn.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "stopGenerator", e);
                }
            }
        }
        TraceHelper.exit(this, "stopGenerator");
    }

    @Override
    public String getDeviceFirmwareInfo() {
        String rc;
        block33: {
            Socket serverConn;
            ObjectOutputStream outStream;
            ObjectInputStream inStream;
            block32: {
                TraceHelper.entry(this, "readFirmwareVersion");
                rc = null;
                inStream = null;
                outStream = null;
                serverConn = null;
                try {
                    try {
                        serverConn = new Socket(this.getDeviceInfoBlock().getRemoteAddress(), this.getDeviceInfoBlock().getRemotePort());
                        serverConn.setSoTimeout(this.getDeviceInfoBlock().getRemoteTimeout());
                        outStream = new ObjectOutputStream(serverConn.getOutputStream());
                        VNAClientRequest req = new VNAClientRequest(VNAClientRequest.CLIENT_CMDS.READ_FIRMWARE, this.getDeviceInfoBlock());
                        outStream.writeObject(req);
                        TraceHelper.text(this, "readFirmwareVersion", "Request send class=" + req.getClass().getSimpleName());
                        inStream = new ObjectInputStream(serverConn.getInputStream());
                        Object obj = inStream.readObject();
                        TraceHelper.text(this, "readFirmwareVersion", "Object received class=" + obj.getClass().getSimpleName());
                        if (!(obj instanceof VNAServerResponse)) break block32;
                        TraceHelper.text(this, "readFirmwareVersion", "VNAServerResponse received");
                        VNAServerResponse resp = (VNAServerResponse)obj;
                        TraceHelper.text(this, "readFirmwareVersion", "Response type=" + (Object)((Object)resp.getResponseType()));
                        if (resp.getResponseType() == VNAServerResponse.SERVER_RESPONSES.FIRMWARE_VERSION) {
                            rc = resp.getInfoText();
                            break block32;
                        }
                        TraceHelper.text(this, "readFirmwareVersion", "Response info=" + resp.getInfoText());
                        throw new ProcessingException(resp.getInfoText());
                    }
                    catch (Exception e) {
                        ErrorLogHelper.exception(this, "readFirmwareVersion", e);
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException e2) {
                                ErrorLogHelper.exception(this, "readFirmwareVersion", e2);
                            }
                        }
                        if (outStream != null) {
                            try {
                                outStream.close();
                            }
                            catch (IOException e3) {
                                ErrorLogHelper.exception(this, "readFirmwareVersion", e3);
                            }
                        }
                        if (serverConn != null) {
                            try {
                                serverConn.close();
                            }
                            catch (IOException e4) {
                                ErrorLogHelper.exception(this, "readFirmwareVersion", e4);
                            }
                        }
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "readFirmwareVersion", e);
                        }
                    }
                    if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "readFirmwareVersion", e);
                        }
                    }
                    if (serverConn != null) {
                        try {
                            serverConn.close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "readFirmwareVersion", e);
                        }
                    }
                    throw throwable;
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "readFirmwareVersion", e);
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "readFirmwareVersion", e);
                }
            }
            if (serverConn != null) {
                try {
                    serverConn.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "readFirmwareVersion", e);
                }
            }
        }
        TraceHelper.exit(this, "readFirmwareVersion");
        return rc;
    }

    @Override
    public void showDriverNetworkDialog(VNAMainFrame pMF) {
        TraceHelper.entry(this, "showDriverNetworkDialog");
        VNANetworkDialog dlg = new VNANetworkDialog(pMF, this);
        dlg.showInPlace();
        TraceHelper.exit(this, "showDriverNetworkDialog");
    }

    @Override
    public long calculateInternalFrequencyValue(long frequency) {
        TraceHelper.entry(this, "calculateInternalFrequencyValue");
        TraceHelper.exit(this, "calculateInternalFrequencyValue");
        return frequency;
    }
}

