/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device;

import krause.vna.device.VNATLParms;
import org.apache.commons.math.complex.Complex;

public class VNATLHelper {
    public static final double SL = 983.571056430446;
    public static final double SLfps = 9.83571056430446E8;
    public static final double NEPER = 20.0 / Math.log(10.0);
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;
    public static final double PI_HALF = 1.5707963267948966;
    public static final double TWO_PI = Math.PI * 2;

    public static VNATLParms getTLParms(double freq, double lenFt, double Zohf, double VFhf, double K1, double K2, double K0) {
        VNATLParms results = new VNATLParms();
        double Rdc = 2.0 * (K0 / 100.0 / NEPER) * Zohf;
        double Rhf = 2.0 * (K1 / 100.0 / NEPER * Math.sqrt(freq)) * Zohf;
        double Lhf = Zohf / (9.83571056430446E8 * VFhf);
        double Ghf = 2.0 * (K2 / 100.0 / NEPER * freq) / Zohf;
        double Chf = 1.0 / (Zohf * 9.83571056430446E8 * VFhf);
        double w = Math.PI * 2 * freq * 1000000.0;
        Complex Zint = new Complex(Rhf, Rhf).multiply(new Complex(Rhf, Rhf)).add(new Complex(Rdc * Rdc, 0.0)).sqrt();
        Complex RjwL = new Complex(0.0, w * Lhf).add(Zint);
        Complex GjwC = new Complex(Ghf, w * Chf);
        Complex Zo = RjwL.divide(GjwC).sqrt();
        Complex Gamma = RjwL.multiply(GjwC).sqrt();
        results.setZ0(Zo);
        results.setCorrectedVf(w / (9.83571056430446E8 * Gamma.getImaginary()));
        results.setLoss(Gamma.getReal() * NEPER * lenFt);
        return results;
    }

    public static Complex ZIZL(Complex Zload, double Freq, double lenFt, double Zohf, double VFhf, double K1, double K2, double K0) {
        VNATLParms vTLParms = VNATLHelper.getTLParms(Freq /= 1000000.0, lenFt, Zohf, VFhf, K1, K2, K0);
        Complex Zo = vTLParms.getZ0();
        double VF = vTLParms.getCorrectedVf();
        double Loss = vTLParms.getLoss();
        double AlphaL = Loss / NEPER;
        double BetaL = Math.PI * 2 * Freq / (983.571056430446 * VF) * lenFt;
        Complex Sinh_gL = new Complex(Math.cos(BetaL) * Math.sinh(AlphaL), Math.sin(BetaL) * Math.cosh(AlphaL));
        Complex Cosh_gL = new Complex(Math.cos(BetaL) * Math.cosh(AlphaL), Math.sin(BetaL) * Math.sinh(AlphaL));
        Complex rc = Zo.multiply(Zload.multiply(Cosh_gL).add(Zo.multiply(Sinh_gL)).divide(Zo.multiply(Cosh_gL).add(Zload.multiply(Sinh_gL))));
        return rc;
    }
}

