/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device;

import krause.common.TypedProperties;
import krause.util.ras.logging.TraceHelper;
import krause.vna.device.VNADeviceInfoBlock;
import org.apache.commons.math.complex.Complex;

public abstract class VNASerialDeviceInfoBlock
extends VNADeviceInfoBlock {
    public static final String PROPERTIES_OPEN_TIMEOUT = "openTimeout";
    public static final int DEFAULT_OPEN_TIMEOUT = 5000;
    public static final String PROPERTIES_READ_TIMEOUT = "readTimeout";
    public static final int DEFAULT_READ_TIMEOUT = 20000;
    public static final String PROPERTIES_AFTER_COMMAND_DELAY = "afterCommandDelay";
    public static final int DEFAULT_AFTER_COMMAND_DELAY = 50;
    public static final String PROPERTIES_BAUDRATE = "baudRate";
    public static final int DEFAULT_PROPERTIES_BAUDRATE = 115200;
    public static final String PROPERTIES_PEAKSUPPRESSION = "peakSuppression";
    private int openTimeout;
    private int readTimeout;
    private int afterCommandDelay;
    private int baudrate;

    @Override
    public void reset() {
        super.reset();
        this.openTimeout = 5000;
        this.readTimeout = 20000;
        this.afterCommandDelay = 50;
        this.baudrate = 115200;
    }

    @Override
    public void restore(TypedProperties config, String prefix) {
        TraceHelper.entry(this, "restore");
        this.reset();
        this.setAfterCommandDelay(config.getInteger(String.valueOf(prefix) + PROPERTIES_AFTER_COMMAND_DELAY, this.getAfterCommandDelay()));
        this.setOpenTimeout(config.getInteger(String.valueOf(prefix) + PROPERTIES_OPEN_TIMEOUT, this.getOpenTimeout()));
        this.setReadTimeout(config.getInteger(String.valueOf(prefix) + PROPERTIES_READ_TIMEOUT, this.getReadTimeout()));
        this.setBaudrate(config.getInteger(String.valueOf(prefix) + PROPERTIES_BAUDRATE, this.getBaudrate()));
        this.setNumberOfSamples(config.getInteger(String.valueOf(prefix) + "nofSamples", this.getNumberOfSamples()));
        this.setFilterMode(config.getInteger(String.valueOf(prefix) + "filterMode", this.getFilterMode()));
        double real = config.getDouble(String.valueOf(prefix) + "referenceReal", 50.0);
        double imag = config.getDouble(String.valueOf(prefix) + "referenceImag", 0.0);
        this.setReferenceResistance(new Complex(real, imag));
        this.setPeakSuppression(config.getBoolean(String.valueOf(prefix) + PROPERTIES_PEAKSUPPRESSION, true));
        TraceHelper.exit(this, "restore");
    }

    @Override
    public void store(TypedProperties config, String prefix) {
        TraceHelper.entry(this, "store");
        config.putInteger(String.valueOf(prefix) + PROPERTIES_AFTER_COMMAND_DELAY, this.getAfterCommandDelay());
        config.putInteger(String.valueOf(prefix) + PROPERTIES_OPEN_TIMEOUT, this.getOpenTimeout());
        config.putInteger(String.valueOf(prefix) + PROPERTIES_READ_TIMEOUT, this.getReadTimeout());
        config.putInteger(String.valueOf(prefix) + PROPERTIES_BAUDRATE, this.getBaudrate());
        config.putInteger(String.valueOf(prefix) + "nofSamples", this.getNumberOfSamples());
        config.putDouble(String.valueOf(prefix) + "referenceReal", this.getReferenceResistance().getReal());
        config.putDouble(String.valueOf(prefix) + "referenceImag", this.getReferenceResistance().getImaginary());
        config.putInteger(String.valueOf(prefix) + "filterMode", this.getFilterMode());
        config.putBoolean(String.valueOf(prefix) + PROPERTIES_PEAKSUPPRESSION, this.isPeakSuppression());
        TraceHelper.exit(this, "store");
    }

    public int getOpenTimeout() {
        return this.openTimeout;
    }

    public void setOpenTimeout(int openTimeout) {
        this.openTimeout = openTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getAfterCommandDelay() {
        return this.afterCommandDelay;
    }

    public void setAfterCommandDelay(int afterCommandDelay) {
        this.afterCommandDelay = afterCommandDelay;
    }

    public void setBaudrate(int baudrate) {
        this.baudrate = baudrate;
    }

    public int getBaudrate() {
        return this.baudrate;
    }
}

