/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import krause.common.exception.InitializationException;
import krause.common.validation.ValidationResult;
import krause.common.validation.ValidationResults;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNAScanMode;
import krause.vna.device.IVNADriver;
import krause.vna.device.IVNADriverMathHelper;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.device.VNAScanRange;
import krause.vna.gui.calibrate.mode1.VNACalibrationRange;
import krause.vna.gui.calibrate.mode1.VNACalibrationRangeComparator;
import krause.vna.resources.VNAMessages;

public abstract class VNAGenericDriver
implements IVNADriver {
    public static final int MINIMUM_SCAN_POINTS = 3000;
    public static final int MAXIMUM_SCAN_POINTS = 30000;
    protected VNAConfig config = VNAConfig.getSingleton();
    private VNADeviceInfoBlock deviceInfoBlock = null;
    private IVNADriverMathHelper mathHelper = null;
    private String portname = null;

    protected String generateScanRangeFilename() {
        String fName = VNAConfig.getSingleton().getPresetsDirectory();
        fName = String.valueOf(fName) + "/CalRanges_";
        fName = String.valueOf(fName) + this.getDeviceInfoBlock().getShortName();
        fName = String.valueOf(fName) + ".txt";
        return fName;
    }

    @Override
    public final VNACalibrationRange[] getCalibrationRanges() {
        VNACalibrationRange[] rc = null;
        TraceHelper.entry(this, "getCalibrationRanges");
        rc = this.loadCalibrationRanges();
        if (rc == null) {
            rc = this.getSpecificCalibrationRanges();
        }
        this.saveCalibrationRanges(rc);
        TraceHelper.entry(this, "getCalibrationRanges");
        return rc;
    }

    @Override
    public VNAScanMode getDefaultMode() {
        return VNAScanMode.MODE_REFLECTION;
    }

    @Override
    public String getDeviceFirmwareInfo() {
        String methodName = "getDeviceFirmwareInfo";
        TraceHelper.entry(this, "getDeviceFirmwareInfo");
        TraceHelper.exitWithRC((Object)this, "getDeviceFirmwareInfo", "null");
        return null;
    }

    @Override
    public VNADeviceInfoBlock getDeviceInfoBlock() {
        return this.deviceInfoBlock;
    }

    @Override
    public Double getDeviceSupply() {
        String methodName = "getDevicePowerStatus";
        TraceHelper.entry(this, "getDevicePowerStatus");
        TraceHelper.exitWithRC((Object)this, "getDevicePowerStatus", "null");
        return null;
    }

    @Override
    public Double getDeviceTemperature() {
        String methodName = "getDeviceTemperature";
        TraceHelper.entry(this, "getDeviceTemperature");
        TraceHelper.exitWithRC((Object)this, "getDeviceTemperature", "null");
        return null;
    }

    @Override
    public final IVNADriverMathHelper getMathHelper() {
        return this.mathHelper;
    }

    @Override
    public String getPortname() {
        return this.portname;
    }

    @Override
    public void init() throws InitializationException {
        TraceHelper.entry(this, "init");
        this.setPortname(this.config.getPortName(this));
        TraceHelper.exit(this, "init");
    }

    protected VNACalibrationRange[] loadCalibrationRanges() {
        ArrayList<VNACalibrationRange> listRanges;
        String fName;
        long max;
        long min;
        VNACalibrationRange[] rc;
        block50: {
            FilterInputStream dis;
            FileInputStream fstream;
            block51: {
                String methodeName = "loadCalibrationRanges";
                rc = null;
                TraceHelper.entry(this, "loadCalibrationRanges");
                min = this.getDeviceInfoBlock().getMinFrequency();
                max = this.getDeviceInfoBlock().getMaxFrequency();
                fName = this.generateScanRangeFilename();
                fstream = null;
                dis = null;
                BufferedReader br = null;
                listRanges = new ArrayList<VNACalibrationRange>();
                try {
                    String line;
                    fstream = new FileInputStream(fName);
                    dis = new DataInputStream(fstream);
                    br = new BufferedReader(new InputStreamReader(dis));
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).length() > 0) {
                            String[] parts = line.split("[\t ]");
                            if (parts.length == 4) {
                                long start = Long.parseLong(parts[0]);
                                long stop = Long.parseLong(parts[1]);
                                int steps = Integer.parseInt(parts[2]);
                                int overscans = Integer.parseInt(parts[3]);
                                VNACalibrationRange sr = new VNACalibrationRange(start, stop, steps, overscans);
                                listRanges.add(sr);
                                continue;
                            }
                            ErrorLogHelper.text(this, "loadCalibrationRanges", "Line [" + line + "] ignored");
                            continue;
                        }
                        ErrorLogHelper.text(this, "loadCalibrationRanges", "Empty line ignored");
                    }
                }
                catch (FileNotFoundException line) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "loadCalibrationRanges", e);
                        }
                    }
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "loadCalibrationRanges", e);
                        }
                    }
                    if (fstream != null) {
                        try {
                            fstream.close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "loadCalibrationRanges", e);
                        }
                    }
                    break block50;
                }
                catch (IOException e) {
                    try {
                        ErrorLogHelper.exception(this, "loadCalibrationRanges", e);
                        break block50;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e2) {
                                ErrorLogHelper.exception(this, "loadCalibrationRanges", e2);
                            }
                        }
                        if (dis != null) {
                            try {
                                dis.close();
                            }
                            catch (IOException e3) {
                                ErrorLogHelper.exception(this, "loadCalibrationRanges", e3);
                            }
                        }
                        if (fstream != null) {
                            try {
                                fstream.close();
                            }
                            catch (IOException e4) {
                                ErrorLogHelper.exception(this, "loadCalibrationRanges", e4);
                            }
                        }
                    }
                }
                if (br == null) break block51;
                try {
                    br.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "loadCalibrationRanges", e);
                }
            }
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "loadCalibrationRanges", e);
                }
            }
            if (fstream != null) {
                try {
                    fstream.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "loadCalibrationRanges", e);
                }
            }
        }
        TraceHelper.text(this, "loadCalibrationRanges", "File read");
        Collections.sort(listRanges, new VNACalibrationRangeComparator());
        TraceHelper.text(this, "loadCalibrationRanges", "Ranges sorted");
        boolean ok = true;
        if (listRanges.size() > 0) {
            if (((VNACalibrationRange)listRanges.get(0)).getStart() != min) {
                ErrorLogHelper.text(this, "loadCalibrationRanges", "First range must start at [" + min + "]");
                ok = false;
            }
            if (((VNACalibrationRange)listRanges.get(listRanges.size() - 1)).getStop() != max) {
                ErrorLogHelper.text(this, "loadCalibrationRanges", "Last range must end at [" + max + "]");
                ok = false;
            }
            int i = 1;
            while (i < listRanges.size()) {
                VNAScanRange prevSr;
                VNAScanRange asr = (VNAScanRange)listRanges.get(i);
                if (asr.getStart() < min || asr.getStart() >= asr.getStop() || asr.getStop() > max || asr.getNumScanPoints() < 10 || asr.getNumScanPoints() > 30000) {
                    ErrorLogHelper.text(this, "loadCalibrationRanges", "Range [" + asr + "] not valid");
                    ok = false;
                }
                if ((prevSr = (VNAScanRange)listRanges.get(i - 1)).getStop() + 1L != asr.getStart()) {
                    ErrorLogHelper.text(this, "loadCalibrationRanges", "Range [" + prevSr + "] and [" + asr + "] are not not consecutively");
                    ok = false;
                }
                ++i;
            }
        }
        TraceHelper.text(this, "loadCalibrationRanges", "Validation result=" + ok);
        if (ok && listRanges.size() > 0) {
            rc = listRanges.toArray(new VNACalibrationRange[listRanges.size()]);
        } else {
            File f = new File(fName);
            String fNameNew = String.valueOf(fName) + ".bak";
            f.renameTo(new File(fNameNew));
            ErrorLogHelper.text(this, "loadCalibrationRanges", "Old rangefile renamed from [" + fName + "] to [" + fNameNew + "]");
        }
        TraceHelper.entry(this, "loadCalibrationRanges");
        return rc;
    }

    public void saveCalibrationRanges(VNACalibrationRange[] ranges) {
        block24: {
            TraceHelper.entry(this, "saveCalibrationRanges");
            BufferedWriter bw = null;
            OutputStreamWriter fw = null;
            File fi = null;
            try {
                try {
                    fi = new File(this.generateScanRangeFilename());
                    fw = new FileWriter(fi, false);
                    bw = new BufferedWriter(fw);
                    int i = 0;
                    while (i < ranges.length) {
                        bw.write("" + ranges[i].getStart());
                        bw.write(" ");
                        bw.write("" + ranges[i].getStop());
                        bw.write(" ");
                        bw.write("" + ranges[i].getNumScanPoints());
                        bw.write(" ");
                        bw.write("" + ranges[i].getNumOverScans());
                        bw.newLine();
                        ++i;
                    }
                }
                catch (Exception exception) {
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "saveCalibrationRanges", e);
                        }
                    }
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "saveCalibrationRanges", e);
                        }
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "saveCalibrationRanges", e);
                    }
                }
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "saveCalibrationRanges", e);
                    }
                }
                throw throwable;
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "saveCalibrationRanges", e);
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "saveCalibrationRanges", e);
                }
            }
        }
        TraceHelper.entry(this, "saveCalibrationRanges");
    }

    public void setDeviceInfoBlock(VNADeviceInfoBlock deviceInfoBlock) {
        this.deviceInfoBlock = deviceInfoBlock;
    }

    public void setMathHelper(IVNADriverMathHelper mathHelper) {
        this.mathHelper = mathHelper;
    }

    @Override
    public void setPortname(String portname) {
        this.portname = portname;
    }

    @Override
    public ValidationResults validateScanRange(VNAScanRange range) {
        ValidationResults results = new ValidationResults();
        TraceHelper.entry(this, "validateScanRange");
        if (range.getStop() - range.getStart() < 1000L) {
            String msg = VNAMessages.getString("VNAGenericDriver.ScanRange.tooSmall");
            ValidationResult res = new ValidationResult(MessageFormat.format(msg, 1000));
            res.setType(ValidationResult.ValidationType.ERROR);
            res.setErrorObject(null);
            results.add(res);
        } else {
            TraceHelper.text(this, "validateScanRange", "Old-range=" + range);
            int samples = range.getNumScanPoints();
            long frequencyStep = (range.getStop() - range.getStart()) / (long)samples;
            long newStop = range.getStart() + frequencyStep * (long)samples;
            long newStart = range.getStart();
            if (newStop > this.getDeviceInfoBlock().getMaxFrequency()) {
                newStop = range.getStop();
                newStart = newStop - frequencyStep * (long)samples;
            }
            range.setStart(newStart);
            range.setStop(newStop);
            TraceHelper.text(this, "validateScanRange", "New-range=" + range);
        }
        TraceHelper.exitWithRC((Object)this, "validateScanRange", results);
        return results;
    }
}

