/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.device;

import java.text.NumberFormat;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNABaseSample;
import krause.vna.data.VNAMinMaxPair;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.calibrated.VNACalibrationContext;
import krause.vna.data.calibrated.VNACalibrationPoint;
import krause.vna.device.IVNADriver;
import krause.vna.device.IVNADriverMathHelper;
import krause.vna.gui.format.VNAFormatFactory;
import org.apache.commons.math.complex.Complex;

public abstract class VNADriverMathBaseHelper
implements IVNADriverMathHelper {
    private static final double PHASE_FULL = 360.0;
    private static final double PHASE_HALF = 180.0;
    private static final double DEG2RAD = Math.PI / 180;
    private static final double RAD2DEG = 57.29577951308232;
    private static final double PI_HALF = 1.5707963267948966;
    private static final double PHASE_SWITCH = 170.0;
    private static final double PHASE_MINDIFF = 0.02;
    private static final double ONE_GHZ = 1.0E9;
    private IVNADriver driver;

    public VNADriverMathBaseHelper(IVNADriver driver) {
        TraceHelper.entry(this, "VNADriverMathBaseHelper");
        this.driver = driver;
        TraceHelper.exit(this, "VNADriverMathBaseHelper");
    }

    @Override
    public VNACalibratedSampleBlock createCalibratedSamples(VNACalibrationContext context, VNASampleBlock raw) {
        TraceHelper.entry(this, "createCalibratedSamples");
        context.setConversionTemperature(raw.getDeviceTemperature());
        int listLength = raw.getSamples().length;
        VNACalibrationBlock calBlock = context.getCalibrationBlock();
        TraceHelper.text(this, "createCalibratedSamples", "calibration data created at temp=" + context.getCalibrationTemperature());
        TraceHelper.text(this, "createCalibratedSamples", "raw data created at temp=" + context.getConversionTemperature());
        if (context.getPexLength() != null && context.getPexVf() != null) {
            context.setPexShiftConstant(720.0 * context.getPexLength() / (2.99792458E8 * context.getPexVf()));
            TraceHelper.text(this, "createCalibratedSamples", "port extension will be enabled with constant " + context.getPexShiftConstant());
        }
        VNACalibratedSampleBlock rc = new VNACalibratedSampleBlock(listLength);
        int i = 0;
        while (i < listLength) {
            VNACalibratedSample s = this.createCalibratedSample(context, raw.getSamples()[i], calBlock.getCalibrationPoints()[i]);
            this.postProcessCalibratedSample(s, context);
            rc.consumeCalibratedSample(s, i);
            ++i;
        }
        this.postProcessCalibratedSamples(rc, context);
        TraceHelper.exit(this, "createCalibratedSamples");
        return rc;
    }

    private void postProcessCalibratedSamples(VNACalibratedSampleBlock csb, VNACalibrationContext context) {
        VNACalibratedSample[] samples;
        int len;
        TraceHelper.entry(this, "postProcessCalibratedSamples");
        if (context.getScanMode().isTransmissionMode() && (len = (samples = csb.getCalibratedSamples()).length) > 1) {
            NumberFormat ff = VNAFormatFactory.getFrequencyFormat();
            VNAMinMaxPair mmGroupDelay = csb.getMmGRPDLY();
            double diffFreq = (double)((samples[1].getFrequency() - samples[0].getFrequency()) * 2L) * Math.PI;
            TraceHelper.text(this, "postProcessCalibratedSamples", "Hz/step=" + ff.format(diffFreq));
            VNACalibratedSample lastSample = samples[0];
            lastSample.setGroupDelay(0.0);
            double lastDiffPhase = 0.0;
            int i = 1;
            while (i < len) {
                boolean print = false;
                VNACalibratedSample currentSample = samples[i];
                double lastPhase = lastSample.getTransmissionPhase();
                double currentPhase = currentSample.getTransmissionPhase();
                double diffPhase = currentPhase - lastPhase;
                if (diffPhase > 170.0) {
                    diffPhase -= 360.0;
                    print = true;
                } else if (diffPhase < -170.0) {
                    diffPhase += 360.0;
                    print = true;
                } else if (diffPhase >= -0.02 && diffPhase <= 0.02) {
                    diffPhase = lastDiffPhase;
                    print = true;
                }
                lastDiffPhase = diffPhase;
                double diffPhaseRad = diffPhase * (Math.PI / 180);
                double groupDelay = -(diffPhaseRad / diffFreq) * 1.0E9;
                currentSample.setGroupDelay(groupDelay);
                mmGroupDelay.consume(groupDelay, i);
                print = false;
                if (print) {
                    TraceHelper.text(this, "postProcessCalibratedSamples", "i*=" + i + " frq=" + ff.format(currentSample.getFrequency()) + " grpdel=" + groupDelay + " diff\u00b0=" + diffPhase + " last\u00b0=" + lastPhase + " current\u00b0=" + currentPhase);
                }
                lastSample = currentSample;
                ++i;
            }
        }
        TraceHelper.exit(this, "postProcessCalibratedSamples");
    }

    private void postProcessCalibratedSample(VNACalibratedSample sample, VNACalibrationContext context) {
        if (!context.getScanMode().isTransmissionMode() && context.getScanMode().isReflectionMode()) {
            sample.setTheta((1.5707963267948966 - Math.atan2(sample.getR(), sample.getX())) * 57.29577951308232);
            if (sample.getRHO() == null) {
                double radian = sample.getReflectionPhase() * (Math.PI / 180);
                double amplitude = Math.pow(10.0, sample.getReflectionLoss() / 20.0);
                double real = amplitude * Math.cos(radian);
                double imag = amplitude * Math.sin(radian);
                sample.setRHO(new Complex(real, imag));
            }
            if (context.getPexShiftConstant() != null) {
                double refRes = context.getDib().getReferenceResistance().getReal();
                double phaseShift = context.getPexShiftConstant() * (double)sample.getFrequency();
                double newPhase = sample.getReflectionPhase() + phaseShift;
                while (newPhase < -180.0) {
                    newPhase += 360.0;
                }
                while (newPhase > 180.0) {
                    newPhase -= 360.0;
                }
                double L3 = Math.cos(Math.PI / 180 * newPhase) * sample.getMag();
                double M3 = Math.sin(Math.PI / 180 * newPhase) * sample.getMag();
                double newR = (1.0 - L3 * L3 - M3 * M3) / ((1.0 - L3) * (1.0 - L3) + M3 * M3) * refRes;
                double newX = 2.0 * M3 / ((1.0 - L3) * (1.0 - L3) + M3 * M3) * refRes;
                double newZ = Math.sqrt(newR * newR + newX * newX);
                double newReflCoeff = Math.sqrt(((newR - refRes) * (newR - refRes) + newX * newX) / ((newR + refRes) * (newR + refRes) + newX * newX));
                double newSWR = (1.0 + newReflCoeff) / (1.0 - newReflCoeff);
                sample.setR(newR);
                sample.setX(newX);
                sample.setZ(newZ);
                sample.setReflectionPhase(newPhase);
                sample.setSWR(newSWR);
            }
        }
    }

    @Override
    public void createCalibrationPoints(VNACalibrationContext context, VNACalibrationBlock calBlock) {
        TraceHelper.entry(this, "createCalibrationPoints");
        TraceHelper.text(this, "createCalibrationPoints", "creating calibration points for temp=" + calBlock.getTemperature());
        int listLength = calBlock.getNumberOfSteps();
        VNACalibrationPoint[] rc = new VNACalibrationPoint[listLength];
        boolean useOpen = calBlock.getCalibrationData4Open() != null && calBlock.getCalibrationData4Open().getSamples() != null;
        boolean useLoad = calBlock.getCalibrationData4Load() != null && calBlock.getCalibrationData4Load().getSamples() != null;
        boolean useLoop = calBlock.getCalibrationData4Loop() != null && calBlock.getCalibrationData4Loop().getSamples() != null;
        boolean useShort = calBlock.getCalibrationData4Short() != null && calBlock.getCalibrationData4Short().getSamples() != null;
        int i = 0;
        while (i < listLength) {
            VNABaseSample sOpen = null;
            VNABaseSample sShort = null;
            VNABaseSample sLoad = null;
            VNABaseSample sLoop = null;
            if (useLoad) {
                sLoad = calBlock.getCalibrationData4Load().getSamples()[i];
            }
            if (useOpen) {
                sOpen = calBlock.getCalibrationData4Open().getSamples()[i];
            }
            if (useShort) {
                sShort = calBlock.getCalibrationData4Short().getSamples()[i];
            }
            if (useLoop) {
                sLoop = calBlock.getCalibrationData4Loop().getSamples()[i];
            }
            rc[i] = this.createCalibrationPoint(context, sOpen, sShort, sLoad, sLoop);
            ++i;
        }
        calBlock.setCalibrationPoints(rc);
        TraceHelper.exit(this, "createCalibrationPoints");
    }

    public void calculateMovingAverage(VNASampleBlock rawBlock, int degree) {
        int min = degree;
        VNABaseSample[] rawSamples = rawBlock.getSamples();
        int max = rawSamples.length - degree;
        int i = min;
        while (i < max) {
            int loc = rawSamples[i].getLoss();
            int j = i - degree;
            while (j < i) {
                loc += rawSamples[i].getLoss();
                ++j;
            }
            j = i + 1;
            while (j <= i + degree) {
                loc += rawSamples[i].getLoss();
                ++j;
            }
            rawSamples[i].setLoss(loc /= 2 * degree + 1);
            ++i;
        }
    }

    public void calculateExponentialAverage4Loss(VNASampleBlock rawBlock, int n) {
        int min = 1;
        VNABaseSample[] rawSamples = rawBlock.getSamples();
        int max = rawSamples.length;
        int div = 1 << n;
        int output = rawSamples[0].getLoss();
        int i = min;
        while (i < max) {
            VNABaseSample current = rawSamples[i];
            int input = current.getLoss();
            output = input / div + output - output / div;
            current.setLoss(output);
            ++i;
        }
    }

    public void calculateExponentialAverage4Phase(VNASampleBlock rawBlock, int n) {
        int min = 1;
        VNABaseSample[] rawSamples = rawBlock.getSamples();
        int max = rawSamples.length;
        int div = 1 << n;
        int output = rawSamples[0].getAngle();
        int i = min;
        while (i < max) {
            VNABaseSample current = rawSamples[i];
            int input = current.getAngle();
            output = input / div + output - output / div;
            current.setAngle(output);
            ++i;
        }
    }

    @Override
    public final VNACalibrationBlock createCalibrationBlockFromRaw(VNACalibrationContext context, VNASampleBlock listOpen, VNASampleBlock listShort, VNASampleBlock listLoad, VNASampleBlock listLoop) throws ProcessingException {
        VNASampleBlock blk;
        TraceHelper.entry(this, "createCalibrationBlockFromRaw");
        if (listLoad != null) {
            blk = listLoad;
        } else if (listOpen != null) {
            blk = listOpen;
        } else if (listShort != null) {
            blk = listShort;
        } else if (listLoop != null) {
            blk = listLoop;
        } else {
            throw new ProcessingException("No data set on raw data");
        }
        VNACalibrationBlock rc = new VNACalibrationBlock(blk);
        rc.setCalibrationData4Load(listLoad);
        rc.setCalibrationData4Open(listOpen);
        rc.setCalibrationData4Short(listShort);
        rc.setCalibrationData4Loop(listLoop);
        this.createCalibrationPoints(context, rc);
        TraceHelper.exit(this, "createCalibrationBlockFromRaw");
        return rc;
    }

    @Override
    public IVNADriver getDriver() {
        return this.driver;
    }

    @Override
    public void setDriver(IVNADriver pDriver) {
        this.driver = pDriver;
    }
}

